/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.addons.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.TreeSet;
import javax.inject.Inject;
import org.jboss.forge.addon.addons.facets.AddonClassifierFacet;
import org.jboss.forge.addon.addons.project.AddonProjectConfiguratorImpl;
import org.jboss.forge.addon.addons.ui.AddAddonDependencyCommand;
import org.jboss.forge.addon.addons.ui.NewUICommandWizardImpl;
import org.jboss.forge.addon.facets.constraints.FacetConstraint;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.ProjectFactory;
import org.jboss.forge.addon.projects.facets.MetadataFacet;
import org.jboss.forge.addon.projects.ui.AbstractProjectCommand;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIContextProvider;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.input.UICompleter;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.addons.AddonId;
import org.jboss.forge.furnace.repositories.AddonRepository;
import org.jboss.forge.furnace.util.Strings;

@FacetConstraint(value={AddonClassifierFacet.class})
public class AddAddonDependencyCommandImpl
extends AbstractProjectCommand
implements AddAddonDependencyCommand {
    @Inject
    private ProjectFactory projectFactory;
    @Inject
    private AddonProjectConfiguratorImpl configurator;
    @Inject
    private Furnace furnace;
    @Inject
    @WithAttributes(label="Addon Coordinates", description="Addon coordinates to be added as a dependency for the selected project", required=true)
    private UIInput<AddonId> addon;

    public void initializeUI(UIBuilder builder) throws Exception {
        final TreeSet<AddonId> addonChoices = new TreeSet<AddonId>();
        Project project = this.getSelectedProject((UIContextProvider)builder);
        for (AddonRepository repository : this.furnace.getRepositories()) {
            for (AddonId id : repository.listEnabled()) {
                boolean isContainerAddon = id.getName().contains("org.jboss.forge.furnace.container");
                if (isContainerAddon || this.configurator.dependsOnAddon(project, id)) continue;
                addonChoices.add(id);
            }
        }
        this.addon.setCompleter((UICompleter)new UICompleter<AddonId>(){

            public Iterable<AddonId> getCompletionProposals(UIContext context, InputComponent<?, AddonId> input, String value) {
                ArrayList<AddonId> addons = new ArrayList<AddonId>();
                for (AddonId addonId : addonChoices) {
                    if (!Strings.isNullOrEmpty((String)value) && !value.startsWith(addonId.toCoordinates())) continue;
                    addons.add(addonId);
                }
                return addons;
            }
        });
        builder.add(this.addon);
    }

    public Result execute(UIExecutionContext context) throws Exception {
        Project project = this.getSelectedProject((UIContextProvider)context);
        AddonId addonId = (AddonId)this.addon.getValue();
        this.configurator.installSelectedAddons(project, Collections.singleton(addonId), false);
        return Results.success((String)("Addon " + addonId + " added as a dependency to project " + ((MetadataFacet)project.getFacet(MetadataFacet.class)).getProjectName()));
    }

    protected boolean isProjectRequired() {
        return true;
    }

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(NewUICommandWizardImpl.class).name("Addon: Add Dependency").description("Adds the provided addon as a dependency to the selected project").category(Categories.create((String[])new String[]{"Forge", "Setup"}));
    }

    protected ProjectFactory getProjectFactory() {
        return this.projectFactory;
    }
}

