/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.addons.ui;

import java.util.Arrays;
import java.util.TreeSet;
import javax.inject.Inject;
import org.jboss.forge.addon.addons.project.AddonProjectConfigurator;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.ui.command.AbstractUICommand;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UINavigationContext;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.input.UISelectMany;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.NavigationResult;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.addon.ui.wizard.UIWizardStep;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.addons.AddonId;
import org.jboss.forge.furnace.repositories.AddonRepository;
import org.jboss.forge.furnace.versions.Version;
import org.jboss.forge.furnace.versions.Versions;

public class FurnaceAddonSetupStep
extends AbstractUICommand
implements UIWizardStep {
    private static final String DEFAULT_CONTAINER_NAME = "org.jboss.forge.furnace.container:cdi";
    private static final String DEFAULT_DEPENDENCY_NAME = "org.jboss.forge.addon:core";
    @Inject
    @WithAttributes(label="Furnace container", required=true, requiredMessage="You must select one Furnace container")
    private UISelectOne<AddonId> furnaceContainer;
    @Inject
    @WithAttributes(label="Create API, Impl, SPI, Tests, and Addon modules")
    private UIInput<Boolean> splitProjects;
    @Inject
    @WithAttributes(label="Depend on these addons")
    private UISelectMany<AddonId> addons;
    @Inject
    private Furnace furnace;
    @Inject
    private AddonProjectConfigurator addonProjectFactory;

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(((Object)((Object)this)).getClass()).name("Furnace Addon Setup").description("Enable Furnace Addon development in your project.").category(Categories.create((String[])new String[]{"Project", "Furnace"}));
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        this.configureAddonDependencies();
        builder.add(this.furnaceContainer).add(this.splitProjects).add(this.addons);
    }

    private void configureAddonDependencies() {
        TreeSet<AddonId> addonChoices = new TreeSet<AddonId>();
        TreeSet<AddonId> containerChoices = new TreeSet<AddonId>();
        AddonId defaultContainer = null;
        AddonId defaultDependency = null;
        for (AddonRepository repository : this.furnace.getRepositories()) {
            for (AddonId id : repository.listEnabled()) {
                if (DEFAULT_CONTAINER_NAME.equals(id.getName())) {
                    defaultContainer = id;
                } else if (DEFAULT_DEPENDENCY_NAME.equals(id.getName())) {
                    defaultDependency = id;
                }
                boolean isContainerAddon = id.getName().contains("org.jboss.forge.furnace.container");
                if (isContainerAddon) {
                    containerChoices.add(id);
                    continue;
                }
                addonChoices.add(id);
            }
        }
        ((UISelectOne)this.furnaceContainer.setValueChoices(containerChoices)).setDefaultValue(defaultContainer);
        this.addons.setValueChoices(addonChoices);
        if (defaultDependency != null) {
            this.addons.setDefaultValue(Arrays.asList(defaultDependency));
        }
    }

    public Result execute(UIExecutionContext context) throws Exception {
        Project project = (Project)context.getUIContext().getAttributeMap().get(Project.class);
        TreeSet<Object> dependencyAddons = new TreeSet<Object>();
        if (this.addons.hasValue() || this.addons.hasDefaultValue()) {
            for (AddonId id : this.addons.getValue()) {
                dependencyAddons.add(id);
            }
        }
        dependencyAddons.add(this.furnaceContainer.getValue());
        Version forgeVersion = Versions.getImplementationVersionFor(((Object)((Object)this)).getClass());
        if (((Boolean)this.splitProjects.getValue()).booleanValue()) {
            this.addonProjectFactory.setupComplexAddonProject(project, forgeVersion, dependencyAddons);
        } else {
            this.addonProjectFactory.setupSimpleAddonProject(project, forgeVersion, dependencyAddons);
        }
        return Results.success();
    }

    public NavigationResult next(UINavigationContext context) throws Exception {
        return null;
    }
}

