/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.addons.ui;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import javax.inject.Inject;
import org.jboss.forge.addon.addons.ui.NewAnnotatedUICommandWizard;
import org.jboss.forge.addon.parser.java.resources.JavaResource;
import org.jboss.forge.addon.projects.ProjectFactory;
import org.jboss.forge.addon.projects.ui.AbstractProjectCommand;
import org.jboss.forge.addon.ui.annotation.Command;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.input.UIInputMany;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.furnace.util.Lists;
import org.jboss.forge.roaster.model.source.AnnotationSource;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.forge.roaster.model.source.JavaSource;
import org.jboss.forge.roaster.model.source.MethodSource;

public class NewAnnotatedUICommandWizardImpl
extends AbstractProjectCommand
implements NewAnnotatedUICommandWizard {
    @Inject
    private ProjectFactory projectFactory;
    @Inject
    @WithAttributes(label="Command name", required=true)
    private UIInput<String> named;
    @Inject
    @WithAttributes(label="Categories", required=false)
    private UIInputMany<String> categories;

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(NewAnnotatedUICommandWizardImpl.class).name("Addon: New Annotated UI Command").description("Generates an annotated UICommand implementation").category(Categories.create((String[])new String[]{"Forge", "Generate"}));
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        this.categories.setDefaultValue(new ArrayList());
        builder.add(this.named).add(this.categories);
    }

    public Result execute(UIExecutionContext context) throws Exception {
        JavaResource javaResource = (JavaResource)context.getUIContext().getInitialSelection().get();
        JavaClassSource commandClass = (JavaClassSource)javaResource.getJavaType();
        commandClass = this.createCommand(commandClass, (String)this.named.getValue(), this.categories.getValue());
        javaResource.setContents((JavaSource)commandClass);
        return Results.success((String)"Annotated UICommand created");
    }

    private JavaClassSource createCommand(JavaClassSource command, String commandName, Iterable<String> categories) {
        MethodSource commandMethod = (MethodSource)((MethodSource)command.addMethod().setName(this.toMethodName(command, commandName))).setReturnType(String.class).setBody(String.format("return \"Command %s executed\";", commandName)).setPublic();
        AnnotationSource commandAnn = commandMethod.addAnnotation(Command.class);
        ArrayList categoryList = new ArrayList(Lists.toList(categories));
        commandAnn.setStringValue("value", commandName);
        if (!categoryList.isEmpty()) {
            commandAnn.setStringArrayValue("categories", categoryList.toArray(new String[categoryList.size()]));
        }
        return command;
    }

    private String toMethodName(JavaClassSource targetClass, String name) {
        StringBuilder sb = new StringBuilder();
        boolean upperCase = false;
        for (char c : name.toCharArray()) {
            if (Character.isJavaIdentifierPart(c)) {
                sb.append(upperCase ? Character.toUpperCase(c) : Character.toLowerCase(c));
                upperCase = false;
                continue;
            }
            upperCase = true;
        }
        return sb.toString();
    }

    public boolean isEnabled(UIContext context) {
        boolean enabled = super.isEnabled(context);
        if (enabled) {
            Object initialSelection = context.getInitialSelection().get();
            if (initialSelection instanceof JavaResource) {
                try {
                    enabled = ((JavaResource)initialSelection).getJavaType().isClass();
                }
                catch (FileNotFoundException e) {
                    enabled = false;
                }
            } else {
                enabled = false;
            }
        }
        return enabled;
    }

    protected boolean isProjectRequired() {
        return false;
    }

    protected ProjectFactory getProjectFactory() {
        return this.projectFactory;
    }
}

