/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.addons.project;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import org.jboss.forge.addon.addons.facets.AddonAPIFacet;
import org.jboss.forge.addon.addons.facets.AddonAddonFacet;
import org.jboss.forge.addon.addons.facets.AddonClassifierFacet;
import org.jboss.forge.addon.addons.facets.AddonImplFacet;
import org.jboss.forge.addon.addons.facets.AddonParentFacet;
import org.jboss.forge.addon.addons.facets.AddonSPIFacet;
import org.jboss.forge.addon.addons.facets.AddonTestFacet;
import org.jboss.forge.addon.addons.facets.DefaultFurnaceContainerFacet;
import org.jboss.forge.addon.addons.facets.ForgeBOMFacet;
import org.jboss.forge.addon.addons.facets.ForgeVersionFacet;
import org.jboss.forge.addon.addons.facets.FurnacePluginFacet;
import org.jboss.forge.addon.addons.facets.FurnaceVersionFacet;
import org.jboss.forge.addon.addons.project.AddonProjectConfigurator;
import org.jboss.forge.addon.dependencies.Dependency;
import org.jboss.forge.addon.dependencies.builder.DependencyBuilder;
import org.jboss.forge.addon.facets.FacetFactory;
import org.jboss.forge.addon.facets.FacetNotFoundException;
import org.jboss.forge.addon.facets.Faceted;
import org.jboss.forge.addon.javaee.cdi.CDIFacet_1_1;
import org.jboss.forge.addon.maven.projects.MavenBuildSystem;
import org.jboss.forge.addon.parser.java.facets.JavaCompilerFacet;
import org.jboss.forge.addon.parser.java.facets.JavaSourceFacet;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.ProjectFacet;
import org.jboss.forge.addon.projects.ProjectFactory;
import org.jboss.forge.addon.projects.ProjectProvider;
import org.jboss.forge.addon.projects.dependencies.DependencyInstaller;
import org.jboss.forge.addon.projects.facets.MetadataFacet;
import org.jboss.forge.addon.projects.facets.PackagingFacet;
import org.jboss.forge.addon.projects.facets.ResourcesFacet;
import org.jboss.forge.addon.resource.DirectoryResource;
import org.jboss.forge.addon.resource.FileResource;
import org.jboss.forge.addon.resource.Resource;
import org.jboss.forge.furnace.addons.AddonId;
import org.jboss.forge.furnace.container.simple.lifecycle.SimpleContainer;
import org.jboss.forge.furnace.util.Streams;
import org.jboss.forge.furnace.versions.Version;
import org.jboss.forge.roaster.Roaster;
import org.jboss.forge.roaster.model.source.JavaPackageInfoSource;
import org.jboss.forge.roaster.model.source.JavaSource;

public class AddonProjectConfiguratorImpl
implements AddonProjectConfigurator {
    private static final String FORGE_ADDON_CLASSIFIER = "forge-addon";

    public void setupSimpleAddonProject(Project project, Version forgeVersion, Iterable<AddonId> dependencyAddons) throws FileNotFoundException, FacetNotFoundException {
        FacetFactory facetFactory = this.getFacetFactory();
        this.generateReadme(project);
        facetFactory.install((Faceted)project, FurnaceVersionFacet.class);
        facetFactory.install((Faceted)project, ForgeVersionFacet.class);
        ((ForgeVersionFacet)project.getFacet(ForgeVersionFacet.class)).setVersion(forgeVersion.toString());
        facetFactory.install((Faceted)project, ForgeBOMFacet.class);
        facetFactory.install((Faceted)project, FurnacePluginFacet.class);
        facetFactory.install((Faceted)project, AddonClassifierFacet.class);
        facetFactory.install((Faceted)project, JavaSourceFacet.class);
        facetFactory.install((Faceted)project, ResourcesFacet.class);
        facetFactory.install((Faceted)project, JavaCompilerFacet.class);
        facetFactory.install((Faceted)project, DefaultFurnaceContainerFacet.class);
        facetFactory.install((Faceted)project, CDIFacet_1_1.class);
        facetFactory.install((Faceted)project, AddonTestFacet.class);
        JavaSourceFacet javaSource = (JavaSourceFacet)project.getFacet(JavaSourceFacet.class);
        javaSource.saveJavaSource((JavaSource)((JavaPackageInfoSource)Roaster.create(JavaPackageInfoSource.class)).setPackage(javaSource.getBasePackage()));
        this.installSelectedAddons(project, dependencyAddons, false);
    }

    public void setupComplexAddonProject(Project project, Version forgeVersion, Iterable<AddonId> dependencyAddons) throws FileNotFoundException, FacetNotFoundException {
        FacetFactory facetFactory = this.getFacetFactory();
        DependencyInstaller dependencyInstaller = this.getDependencyInstaller();
        this.generateReadme(project);
        MetadataFacet metadata = (MetadataFacet)project.getFacet(MetadataFacet.class);
        String projectName = metadata.getProjectName();
        metadata.setProjectName(projectName + "-parent");
        ((PackagingFacet)project.getFacet(PackagingFacet.class)).setPackagingType("pom");
        facetFactory.install((Faceted)project, AddonParentFacet.class);
        facetFactory.install((Faceted)project, ForgeBOMFacet.class);
        ((ForgeVersionFacet)project.getFacet(ForgeVersionFacet.class)).setVersion(forgeVersion.toString());
        Project addonProject = this.createSubmoduleProject(project, "addon", projectName, AddonAddonFacet.class);
        Project apiProject = this.createSubmoduleProject(project, "api", projectName + "-api", AddonAPIFacet.class, CDIFacet_1_1.class);
        Project implProject = this.createSubmoduleProject(project, "impl", projectName + "-impl", AddonImplFacet.class, CDIFacet_1_1.class);
        Project spiProject = this.createSubmoduleProject(project, "spi", projectName + "-spi", AddonSPIFacet.class);
        Project testsProject = this.createSubmoduleProject(project, "tests", projectName + "-tests", AddonTestFacet.class);
        Dependency apiProjectDependency = ((MetadataFacet)apiProject.getFacet(MetadataFacet.class)).getOutputDependency();
        Dependency implProjectDependency = ((MetadataFacet)implProject.getFacet(MetadataFacet.class)).getOutputDependency();
        DependencyBuilder spiProjectDependency = DependencyBuilder.create((Dependency)((MetadataFacet)spiProject.getFacet(MetadataFacet.class)).getOutputDependency()).setClassifier(FORGE_ADDON_CLASSIFIER);
        DependencyBuilder addonProjectDependency = DependencyBuilder.create((Dependency)((MetadataFacet)addonProject.getFacet(MetadataFacet.class)).getOutputDependency()).setClassifier(FORGE_ADDON_CLASSIFIER);
        dependencyInstaller.installManaged(project, (Dependency)DependencyBuilder.create((Dependency)addonProjectDependency).setVersion("${project.version}"));
        dependencyInstaller.installManaged(project, (Dependency)DependencyBuilder.create((Dependency)apiProjectDependency).setVersion("${project.version}"));
        dependencyInstaller.installManaged(project, (Dependency)DependencyBuilder.create((Dependency)implProjectDependency).setVersion("${project.version}"));
        dependencyInstaller.installManaged(project, (Dependency)DependencyBuilder.create((Dependency)spiProjectDependency).setVersion("${project.version}"));
        for (Project p : Arrays.asList(addonProject, apiProject, implProject, spiProject)) {
            JavaSourceFacet javaSource = (JavaSourceFacet)p.getFacet(JavaSourceFacet.class);
            javaSource.saveJavaSource((JavaSource)((JavaPackageInfoSource)Roaster.create(JavaPackageInfoSource.class)).setPackage(javaSource.getBasePackage()));
        }
        this.installSelectedAddons(project, dependencyAddons, true);
        this.installSelectedAddons(addonProject, dependencyAddons, false);
        this.installSelectedAddons(apiProject, dependencyAddons, false);
        this.installSelectedAddons(testsProject, dependencyAddons, false);
        dependencyInstaller.install(addonProject, (Dependency)DependencyBuilder.create((Dependency)apiProjectDependency));
        dependencyInstaller.install(addonProject, (Dependency)DependencyBuilder.create((Dependency)implProjectDependency).setOptional(true).setScopeType("runtime"));
        dependencyInstaller.install(addonProject, (Dependency)DependencyBuilder.create((Dependency)spiProjectDependency));
        dependencyInstaller.install(implProject, (Dependency)DependencyBuilder.create((Dependency)apiProjectDependency).setScopeType("provided"));
        dependencyInstaller.install(implProject, (Dependency)DependencyBuilder.create((Dependency)spiProjectDependency).setScopeType("provided"));
        dependencyInstaller.install(apiProject, (Dependency)DependencyBuilder.create((Dependency)spiProjectDependency).setScopeType("provided"));
        dependencyInstaller.install(testsProject, (Dependency)addonProjectDependency);
    }

    private void generateReadme(Project project) {
        String readmeTemplate = Streams.toString((InputStream)this.getClass().getResourceAsStream("README.asciidoc"));
        FileResource child = (FileResource)((DirectoryResource)project.getRoot().reify(DirectoryResource.class)).getChildOfType(FileResource.class, "README.asciidoc");
        MetadataFacet metadata = (MetadataFacet)project.getFacet(MetadataFacet.class);
        readmeTemplate = readmeTemplate.replaceAll("\\{\\{ADDON_GROUP_ID\\}\\}", metadata.getProjectGroupName());
        readmeTemplate = readmeTemplate.replaceAll("\\{\\{ADDON_ARTIFACT_ID\\}\\}", metadata.getProjectName());
        child.createNewFile();
        child.setContents(readmeTemplate);
    }

    public void installSelectedAddons(Project project, Iterable<AddonId> addons, boolean managed) {
        DependencyInstaller dependencyInstaller = this.getDependencyInstaller();
        if (addons != null) {
            for (AddonId addon : addons) {
                Dependency dependency = this.toDependency(addon);
                if (managed) {
                    if (dependencyInstaller.isManaged(project, dependency)) continue;
                    dependencyInstaller.installManaged(project, dependency);
                    continue;
                }
                if (dependencyInstaller.isInstalled(project, dependency)) continue;
                dependencyInstaller.install(project, dependency);
            }
        }
    }

    public Dependency toDependency(AddonId addon) {
        String[] mavenCoords = addon.getName().split(":");
        DependencyBuilder dependency = DependencyBuilder.create().setGroupId(mavenCoords[0]).setArtifactId(mavenCoords[1]).setVersion(addon.getVersion().toString()).setClassifier(FORGE_ADDON_CLASSIFIER);
        return dependency;
    }

    public boolean dependsOnAddon(Project project, AddonId addonId) {
        DependencyInstaller dependencyInstaller = this.getDependencyInstaller();
        Dependency dependency = this.toDependency(addonId);
        return dependencyInstaller.isInstalled(project, dependency);
    }

    private Project createSubmoduleProject(Project parent, String moduleName, String artifactId, Class<? extends ProjectFacet> ... requiredProjectFacets) {
        ProjectFactory projectFactory = this.getProjectFactory();
        MavenBuildSystem buildSystem = this.getBuildSystem();
        DirectoryResource location = ((DirectoryResource)parent.getRoot().reify(DirectoryResource.class)).getOrCreateChildDirectory(moduleName);
        ArrayList<Class> facets = new ArrayList<Class>();
        facets.add(ResourcesFacet.class);
        facets.addAll(Arrays.asList(requiredProjectFacets));
        Project project = projectFactory.createProject((Resource)location, (ProjectProvider)buildSystem, facets);
        MetadataFacet metadata = (MetadataFacet)project.getFacet(MetadataFacet.class);
        metadata.setProjectName(artifactId);
        return project;
    }

    private FacetFactory getFacetFactory() {
        return (FacetFactory)SimpleContainer.getServices((ClassLoader)this.getClass().getClassLoader(), FacetFactory.class).get();
    }

    private ProjectFactory getProjectFactory() {
        return (ProjectFactory)SimpleContainer.getServices((ClassLoader)this.getClass().getClassLoader(), ProjectFactory.class).get();
    }

    private DependencyInstaller getDependencyInstaller() {
        return (DependencyInstaller)SimpleContainer.getServices((ClassLoader)this.getClass().getClassLoader(), DependencyInstaller.class).get();
    }

    private MavenBuildSystem getBuildSystem() {
        return (MavenBuildSystem)SimpleContainer.getServices((ClassLoader)this.getClass().getClassLoader(), MavenBuildSystem.class).get();
    }
}

