/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.addons.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.TreeSet;
import org.jboss.forge.addon.addons.facets.AddonClassifierFacet;
import org.jboss.forge.addon.addons.project.AddonProjectConfigurator;
import org.jboss.forge.addon.addons.ui.AddAddonDependencyCommand;
import org.jboss.forge.addon.addons.ui.NewUICommandWizardImpl;
import org.jboss.forge.addon.facets.constraints.FacetConstraint;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.ProjectFactory;
import org.jboss.forge.addon.projects.facets.MetadataFacet;
import org.jboss.forge.addon.projects.ui.AbstractProjectCommand;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIContextProvider;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UIValidationContext;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.input.InputComponentFactory;
import org.jboss.forge.addon.ui.input.UICompleter;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.addon.ui.validate.UIValidator;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.addons.AddonId;
import org.jboss.forge.furnace.container.simple.lifecycle.SimpleContainer;
import org.jboss.forge.furnace.repositories.AddonRepository;
import org.jboss.forge.furnace.util.Strings;

@FacetConstraint(value={AddonClassifierFacet.class})
public class AddAddonDependencyCommandImpl
extends AbstractProjectCommand
implements AddAddonDependencyCommand {
    private UIInput<String> addon;

    public void initializeUI(UIBuilder builder) throws Exception {
        AddonProjectConfigurator configurator = (AddonProjectConfigurator)SimpleContainer.getServices((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), AddonProjectConfigurator.class).get();
        InputComponentFactory factory = builder.getInputComponentFactory();
        this.addon = (UIInput)((UIInput)((UIInput)factory.createInput("addon", String.class).setLabel("Addon Coordinates")).setDescription("Addon coordinates to be added as a dependency for the selected project")).setRequired(true);
        final TreeSet<AddonId> addonChoices = new TreeSet<AddonId>();
        Project project = this.getSelectedProject((UIContextProvider)builder);
        Furnace furnace = SimpleContainer.getFurnace((ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        for (AddonRepository repository : furnace.getRepositories()) {
            for (AddonId id : repository.listEnabled()) {
                boolean isContainerAddon = id.getName().contains("org.jboss.forge.furnace.container");
                if (isContainerAddon || configurator.dependsOnAddon(project, id)) continue;
                addonChoices.add(id);
            }
        }
        ((UIInput)this.addon.setCompleter((UICompleter)new UICompleter<String>(){

            public Iterable<String> getCompletionProposals(UIContext context, InputComponent<?, String> input, String value) {
                ArrayList<String> addons = new ArrayList<String>();
                for (AddonId addonId : addonChoices) {
                    if (!Strings.isNullOrEmpty((String)value) && !addonId.toCoordinates().startsWith(value)) continue;
                    addons.add(addonId.toCoordinates());
                }
                return addons;
            }
        })).addValidator(new UIValidator(){

            public void validate(UIValidationContext context) {
                String value = (String)context.getCurrentInputComponent().getValue();
                try {
                    AddonId.fromCoordinates((String)value);
                }
                catch (Exception e) {
                    context.addValidationError((InputComponent)AddAddonDependencyCommandImpl.this.addon, e.getMessage());
                }
            }
        });
        builder.add(this.addon);
    }

    public Result execute(UIExecutionContext context) throws Exception {
        AddonProjectConfigurator configurator = (AddonProjectConfigurator)SimpleContainer.getServices((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), AddonProjectConfigurator.class).get();
        Project project = this.getSelectedProject((UIContextProvider)context);
        AddonId addonId = AddonId.fromCoordinates((String)((String)this.addon.getValue()));
        configurator.installSelectedAddons(project, Collections.singleton(addonId), false);
        return Results.success((String)("Addon " + addonId + " added as a dependency to project " + ((MetadataFacet)project.getFacet(MetadataFacet.class)).getProjectName()));
    }

    protected boolean isProjectRequired() {
        return true;
    }

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(NewUICommandWizardImpl.class).name("Addon: Add Dependency").description("Adds the provided addon as a dependency to the selected project").category(Categories.create((String[])new String[]{"Forge", "Setup"}));
    }

    protected ProjectFactory getProjectFactory() {
        return (ProjectFactory)SimpleContainer.getServices((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), ProjectFactory.class).get();
    }
}

