/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.addons.ui;

import java.util.Arrays;
import java.util.TreeSet;
import org.jboss.forge.addon.addons.project.AddonProjectConfigurator;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.ui.command.AbstractUICommand;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UINavigationContext;
import org.jboss.forge.addon.ui.input.InputComponentFactory;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.input.UISelectMany;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.result.NavigationResult;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.addon.ui.wizard.UIWizardStep;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.addons.AddonId;
import org.jboss.forge.furnace.container.simple.lifecycle.SimpleContainer;
import org.jboss.forge.furnace.repositories.AddonRepository;
import org.jboss.forge.furnace.versions.Version;
import org.jboss.forge.furnace.versions.Versions;

public class FurnaceAddonSetupStep
extends AbstractUICommand
implements UIWizardStep {
    private static final String DEFAULT_CONTAINER_NAME = "org.jboss.forge.furnace.container:cdi";
    private static final String DEFAULT_DEPENDENCY_NAME = "org.jboss.forge.addon:core";
    private UISelectOne<AddonId> furnaceContainer;
    private UIInput<Boolean> splitProjects;
    private UISelectMany<AddonId> addons;

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(((Object)((Object)this)).getClass()).name("Furnace Addon Setup").description("Enable Furnace Addon development in your project.").category(Categories.create((String[])new String[]{"Project", "Furnace"}));
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        InputComponentFactory factory = builder.getInputComponentFactory();
        this.furnaceContainer = (UISelectOne)((UISelectOne)((UISelectOne)factory.createSelectOne("furnaceContainer", AddonId.class).setLabel("Furnace container")).setRequired(true)).setRequiredMessage("You must select one Furnace container");
        this.splitProjects = (UIInput)factory.createInput("splitProjects", Boolean.class).setLabel("Create API, Impl, SPI, Tests, and Addon modules");
        this.addons = (UISelectMany)factory.createSelectMany("addons", AddonId.class).setLabel("Depend on these addons");
        this.configureAddonDependencies();
        builder.add(this.furnaceContainer).add(this.splitProjects).add(this.addons);
    }

    private void configureAddonDependencies() {
        TreeSet<AddonId> addonChoices = new TreeSet<AddonId>();
        TreeSet<AddonId> containerChoices = new TreeSet<AddonId>();
        AddonId defaultContainer = null;
        AddonId defaultDependency = null;
        Furnace furnace = SimpleContainer.getFurnace((ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        for (AddonRepository repository : furnace.getRepositories()) {
            for (AddonId id : repository.listEnabled()) {
                if (DEFAULT_CONTAINER_NAME.equals(id.getName())) {
                    defaultContainer = id;
                } else if (DEFAULT_DEPENDENCY_NAME.equals(id.getName())) {
                    defaultDependency = id;
                }
                boolean isContainerAddon = id.getName().contains("org.jboss.forge.furnace.container");
                if (isContainerAddon) {
                    containerChoices.add(id);
                    continue;
                }
                addonChoices.add(id);
            }
        }
        ((UISelectOne)this.furnaceContainer.setValueChoices(containerChoices)).setDefaultValue(defaultContainer);
        this.addons.setValueChoices(addonChoices);
        if (defaultDependency != null) {
            this.addons.setDefaultValue(Arrays.asList(defaultDependency));
        }
    }

    public Result execute(UIExecutionContext context) throws Exception {
        AddonProjectConfigurator addonProjectFactory = (AddonProjectConfigurator)SimpleContainer.getServices((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), AddonProjectConfigurator.class).get();
        Project project = (Project)context.getUIContext().getAttributeMap().get(Project.class);
        TreeSet<Object> dependencyAddons = new TreeSet<Object>();
        if (this.addons.hasValue() || this.addons.hasDefaultValue()) {
            for (AddonId id : this.addons.getValue()) {
                dependencyAddons.add(id);
            }
        }
        dependencyAddons.add(this.furnaceContainer.getValue());
        Version forgeVersion = Versions.getImplementationVersionFor(((Object)((Object)this)).getClass());
        if (((Boolean)this.splitProjects.getValue()).booleanValue()) {
            addonProjectFactory.setupComplexAddonProject(project, forgeVersion, dependencyAddons);
        } else {
            addonProjectFactory.setupSimpleAddonProject(project, forgeVersion, dependencyAddons);
        }
        return Results.success();
    }

    public NavigationResult next(UINavigationContext context) throws Exception {
        return null;
    }
}

