/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.addons.ui;

import java.util.ArrayList;
import java.util.Iterator;
import javax.inject.Inject;
import org.jboss.forge.addon.addons.ui.NewUICommandWizard;
import org.jboss.forge.addon.parser.java.facets.JavaSourceFacet;
import org.jboss.forge.addon.parser.java.ui.AbstractJavaSourceCommand;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.ui.command.AbstractUICommand;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.input.UIInputMany;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.furnace.util.Strings;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.forge.roaster.model.source.MethodSource;

public class NewUICommandWizardImpl
extends AbstractJavaSourceCommand<JavaClassSource>
implements NewUICommandWizard {
    @Inject
    @WithAttributes(label="Command name", required=false)
    private UIInput<String> commandName;
    @Inject
    @WithAttributes(label="Categories", required=false)
    private UIInputMany<String> categories;

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(NewUICommandWizardImpl.class).name("Addon: New UI Command").description("Generates a UICommand implementation").category(Categories.create((String[])new String[]{"Forge", "Generate"}));
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        super.initializeUI(builder);
        this.categories.setDefaultValue(new ArrayList());
        builder.add(this.commandName).add(this.categories);
    }

    public JavaClassSource decorateSource(UIExecutionContext context, Project project, JavaClassSource command) throws Exception {
        if (Strings.isNullOrEmpty((String)((String)this.commandName.getValue()))) {
            this.commandName.setValue((Object)NewUICommandWizardImpl.calculateCommandName(command.getName()));
        }
        command.setSuperType(AbstractUICommand.class);
        command.addImport(UIBuilder.class);
        command.addImport(UIContext.class);
        command.addImport(UIExecutionContext.class);
        command.addImport(UICommandMetadata.class);
        command.addImport(Metadata.class);
        command.addImport(Categories.class);
        command.addImport(Result.class);
        command.addImport(Results.class);
        MethodSource getMetadataMethod = ((MethodSource)((MethodSource)command.addMethod().setPublic()).setName("getMetadata")).setReturnType(UICommandMetadata.class).setParameters("UIContext context");
        getMetadataMethod.addAnnotation(Override.class);
        String getMetadataMethodBody = "return Metadata.forCommand(" + command.getName() + ".class" + ")\n" + "\t.name(\"" + (String)this.commandName.getValue() + "\")";
        Iterator iterator = this.categories.getValue().iterator();
        if (iterator.hasNext()) {
            getMetadataMethodBody = getMetadataMethodBody + "\t.category(Categories.create(";
            while (iterator.hasNext()) {
                getMetadataMethodBody = getMetadataMethodBody + "\"" + (String)iterator.next() + "\"";
                if (!iterator.hasNext()) continue;
                getMetadataMethodBody = getMetadataMethodBody + ", ";
            }
            getMetadataMethodBody = getMetadataMethodBody + "))";
        }
        getMetadataMethodBody = getMetadataMethodBody + ";";
        getMetadataMethod.setBody(getMetadataMethodBody);
        ((MethodSource)((MethodSource)command.addMethod().setPublic()).setName("initializeUI")).setReturnTypeVoid().setBody("// not implemented").setParameters("UIBuilder builder").addThrows(Exception.class).addAnnotation(Override.class);
        ((MethodSource)((MethodSource)command.addMethod().setPublic()).setName("execute")).setReturnType(Result.class).setParameters("UIExecutionContext context").setBody("return Results.fail(\"Not implemented!\");").addThrows(Exception.class).addAnnotation(Override.class);
        return command;
    }

    protected Class<JavaClassSource> getSourceType() {
        return JavaClassSource.class;
    }

    protected String calculateDefaultPackage(UIContext context) {
        Project project = this.getSelectedProject(context);
        return ((JavaSourceFacet)project.getFacet(JavaSourceFacet.class)).getBasePackage() + ".commands";
    }

    protected String getType() {
        return "UI Command";
    }

    static String calculateCommandName(String value) {
        StringBuilder builder = new StringBuilder();
        if (Strings.isNullOrEmpty((String)value)) {
            throw new IllegalArgumentException("It isn't possible to parse a null value");
        }
        if (value.toLowerCase().endsWith("command")) {
            value = value.substring(0, value.toLowerCase().lastIndexOf("command"));
        }
        value = value.replaceFirst(Character.toString(value.charAt(0)), Character.toString(value.charAt(0)).toLowerCase());
        for (int index = 0; index < value.length(); ++index) {
            char charValue = value.charAt(index);
            if (index > 0 && Character.isUpperCase(charValue) && Character.isLowerCase(value.charAt(index - 1))) {
                builder.append("-").append(Character.toLowerCase(charValue));
                continue;
            }
            builder.append(Character.toLowerCase(charValue));
        }
        return builder.toString();
    }
}

