/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.addons.project;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import javax.inject.Inject;
import org.jboss.forge.addon.addons.facets.AddonAPIFacet;
import org.jboss.forge.addon.addons.facets.AddonAddonFacet;
import org.jboss.forge.addon.addons.facets.AddonClassifierFacet;
import org.jboss.forge.addon.addons.facets.AddonImplFacet;
import org.jboss.forge.addon.addons.facets.AddonParentFacet;
import org.jboss.forge.addon.addons.facets.AddonSPIFacet;
import org.jboss.forge.addon.addons.facets.AddonTestFacet;
import org.jboss.forge.addon.addons.facets.DefaultFurnaceContainerFacet;
import org.jboss.forge.addon.addons.facets.ForgeBOMFacet;
import org.jboss.forge.addon.addons.facets.FurnacePluginFacet;
import org.jboss.forge.addon.addons.facets.FurnaceVersionFacet;
import org.jboss.forge.addon.addons.project.AddonProjectConfigurator;
import org.jboss.forge.addon.dependencies.Dependency;
import org.jboss.forge.addon.dependencies.builder.DependencyBuilder;
import org.jboss.forge.addon.facets.FacetFactory;
import org.jboss.forge.addon.facets.FacetNotFoundException;
import org.jboss.forge.addon.facets.Faceted;
import org.jboss.forge.addon.javaee.cdi.CDIFacet_1_1;
import org.jboss.forge.addon.maven.projects.MavenBuildSystem;
import org.jboss.forge.addon.parser.java.facets.JavaCompilerFacet;
import org.jboss.forge.addon.parser.java.facets.JavaSourceFacet;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.ProjectFacet;
import org.jboss.forge.addon.projects.ProjectFactory;
import org.jboss.forge.addon.projects.ProjectProvider;
import org.jboss.forge.addon.projects.dependencies.DependencyInstaller;
import org.jboss.forge.addon.projects.facets.MetadataFacet;
import org.jboss.forge.addon.projects.facets.PackagingFacet;
import org.jboss.forge.addon.projects.facets.ResourcesFacet;
import org.jboss.forge.addon.resource.DirectoryResource;
import org.jboss.forge.addon.resource.FileResource;
import org.jboss.forge.addon.resource.Resource;
import org.jboss.forge.furnace.addons.AddonId;
import org.jboss.forge.furnace.util.Streams;
import org.jboss.forge.furnace.versions.Version;
import org.jboss.forge.roaster.Roaster;
import org.jboss.forge.roaster.model.source.JavaPackageInfoSource;
import org.jboss.forge.roaster.model.source.JavaSource;

public class AddonProjectConfiguratorImpl
implements AddonProjectConfigurator {
    private static final String FORGE_ADDON_CLASSIFIER = "forge-addon";
    @Inject
    private FacetFactory facetFactory;
    @Inject
    private ProjectFactory projectFactory;
    @Inject
    private DependencyInstaller dependencyInstaller;
    @Inject
    private MavenBuildSystem buildSystem;

    public void setupSimpleAddonProject(Project project, Version forgeVersion, Iterable<AddonId> dependencyAddons) throws FileNotFoundException, FacetNotFoundException {
        this.generateReadme(project);
        this.facetFactory.install((Faceted)project, FurnaceVersionFacet.class);
        ((FurnaceVersionFacet)project.getFacet(FurnaceVersionFacet.class)).setVersion(forgeVersion.toString());
        this.facetFactory.install((Faceted)project, ForgeBOMFacet.class);
        this.facetFactory.install((Faceted)project, FurnacePluginFacet.class);
        this.facetFactory.install((Faceted)project, AddonClassifierFacet.class);
        this.facetFactory.install((Faceted)project, JavaSourceFacet.class);
        this.facetFactory.install((Faceted)project, ResourcesFacet.class);
        this.facetFactory.install((Faceted)project, JavaCompilerFacet.class);
        this.facetFactory.install((Faceted)project, DefaultFurnaceContainerFacet.class);
        this.facetFactory.install((Faceted)project, CDIFacet_1_1.class);
        this.facetFactory.install((Faceted)project, AddonTestFacet.class);
        JavaSourceFacet javaSource = (JavaSourceFacet)project.getFacet(JavaSourceFacet.class);
        javaSource.saveJavaSource((JavaSource)((JavaPackageInfoSource)Roaster.create(JavaPackageInfoSource.class)).setPackage(javaSource.getBasePackage()));
        this.installSelectedAddons(project, dependencyAddons, false);
    }

    public void setupComplexAddonProject(Project project, Version forgeVersion, Iterable<AddonId> dependencyAddons) throws FileNotFoundException, FacetNotFoundException {
        this.generateReadme(project);
        MetadataFacet metadata = (MetadataFacet)project.getFacet(MetadataFacet.class);
        String projectName = metadata.getProjectName();
        metadata.setProjectName(projectName + "-parent");
        ((PackagingFacet)project.getFacet(PackagingFacet.class)).setPackagingType("pom");
        this.facetFactory.install((Faceted)project, AddonParentFacet.class);
        ((FurnaceVersionFacet)project.getFacet(FurnaceVersionFacet.class)).setVersion(forgeVersion.toString());
        this.facetFactory.install((Faceted)project, ForgeBOMFacet.class);
        Project addonProject = this.createSubmoduleProject(project, "addon", projectName, AddonAddonFacet.class);
        Project apiProject = this.createSubmoduleProject(project, "api", projectName + "-api", AddonAPIFacet.class, CDIFacet_1_1.class);
        Project implProject = this.createSubmoduleProject(project, "impl", projectName + "-impl", AddonImplFacet.class, CDIFacet_1_1.class);
        Project spiProject = this.createSubmoduleProject(project, "spi", projectName + "-spi", AddonSPIFacet.class);
        Project testsProject = this.createSubmoduleProject(project, "tests", projectName + "-tests", AddonTestFacet.class);
        Dependency apiProjectDependency = ((MetadataFacet)apiProject.getFacet(MetadataFacet.class)).getOutputDependency();
        Dependency implProjectDependency = ((MetadataFacet)implProject.getFacet(MetadataFacet.class)).getOutputDependency();
        DependencyBuilder spiProjectDependency = DependencyBuilder.create((Dependency)((MetadataFacet)spiProject.getFacet(MetadataFacet.class)).getOutputDependency()).setClassifier(FORGE_ADDON_CLASSIFIER);
        DependencyBuilder addonProjectDependency = DependencyBuilder.create((Dependency)((MetadataFacet)addonProject.getFacet(MetadataFacet.class)).getOutputDependency()).setClassifier(FORGE_ADDON_CLASSIFIER);
        this.dependencyInstaller.installManaged(project, (Dependency)DependencyBuilder.create((Dependency)addonProjectDependency).setVersion("${project.version}"));
        this.dependencyInstaller.installManaged(project, (Dependency)DependencyBuilder.create((Dependency)apiProjectDependency).setVersion("${project.version}"));
        this.dependencyInstaller.installManaged(project, (Dependency)DependencyBuilder.create((Dependency)implProjectDependency).setVersion("${project.version}"));
        this.dependencyInstaller.installManaged(project, (Dependency)DependencyBuilder.create((Dependency)spiProjectDependency).setVersion("${project.version}"));
        for (Project p : Arrays.asList(addonProject, apiProject, implProject, spiProject)) {
            JavaSourceFacet javaSource = (JavaSourceFacet)p.getFacet(JavaSourceFacet.class);
            javaSource.saveJavaSource((JavaSource)((JavaPackageInfoSource)Roaster.create(JavaPackageInfoSource.class)).setPackage(javaSource.getBasePackage()));
        }
        this.installSelectedAddons(project, dependencyAddons, true);
        this.installSelectedAddons(addonProject, dependencyAddons, false);
        this.installSelectedAddons(apiProject, dependencyAddons, false);
        this.installSelectedAddons(testsProject, dependencyAddons, false);
        this.dependencyInstaller.install(addonProject, (Dependency)DependencyBuilder.create((Dependency)apiProjectDependency));
        this.dependencyInstaller.install(addonProject, (Dependency)DependencyBuilder.create((Dependency)implProjectDependency).setOptional(true).setScopeType("runtime"));
        this.dependencyInstaller.install(addonProject, (Dependency)DependencyBuilder.create((Dependency)spiProjectDependency));
        this.dependencyInstaller.install(implProject, (Dependency)DependencyBuilder.create((Dependency)apiProjectDependency).setScopeType("provided"));
        this.dependencyInstaller.install(implProject, (Dependency)DependencyBuilder.create((Dependency)spiProjectDependency).setScopeType("provided"));
        this.dependencyInstaller.install(apiProject, (Dependency)DependencyBuilder.create((Dependency)spiProjectDependency).setScopeType("provided"));
        this.dependencyInstaller.install(testsProject, (Dependency)addonProjectDependency);
    }

    private void generateReadme(Project project) {
        String readmeTemplate = Streams.toString((InputStream)this.getClass().getResourceAsStream("README.asciidoc"));
        FileResource child = (FileResource)((DirectoryResource)project.getRoot().reify(DirectoryResource.class)).getChildOfType(FileResource.class, "README.asciidoc");
        MetadataFacet metadata = (MetadataFacet)project.getFacet(MetadataFacet.class);
        readmeTemplate = readmeTemplate.replaceAll("\\{\\{ADDON_GROUP_ID\\}\\}", metadata.getProjectGroupName());
        readmeTemplate = readmeTemplate.replaceAll("\\{\\{ADDON_ARTIFACT_ID\\}\\}", metadata.getProjectName());
        child.createNewFile();
        child.setContents(readmeTemplate);
    }

    public void installSelectedAddons(Project project, Iterable<AddonId> addons, boolean managed) {
        if (addons != null) {
            for (AddonId addon : addons) {
                Dependency dependency = this.toDependency(addon);
                if (managed) {
                    this.dependencyInstaller.installManaged(project, dependency);
                    continue;
                }
                this.dependencyInstaller.install(project, dependency);
            }
        }
    }

    public Dependency toDependency(AddonId addon) {
        String[] mavenCoords = addon.getName().split(":");
        DependencyBuilder dependency = DependencyBuilder.create().setGroupId(mavenCoords[0]).setArtifactId(mavenCoords[1]).setVersion(addon.getVersion().toString()).setClassifier(FORGE_ADDON_CLASSIFIER);
        return dependency;
    }

    public boolean dependsOnAddon(Project project, AddonId addonId) {
        Dependency dependency = this.toDependency(addonId);
        return this.dependencyInstaller.isInstalled(project, dependency);
    }

    private Project createSubmoduleProject(Project parent, String moduleName, String artifactId, Class<? extends ProjectFacet> ... requiredProjectFacets) {
        DirectoryResource location = ((DirectoryResource)parent.getRoot().reify(DirectoryResource.class)).getOrCreateChildDirectory(moduleName);
        ArrayList<Class> facets = new ArrayList<Class>();
        facets.add(ResourcesFacet.class);
        facets.addAll(Arrays.asList(requiredProjectFacets));
        Project project = this.projectFactory.createProject((Resource)location, (ProjectProvider)this.buildSystem, facets);
        MetadataFacet metadata = (MetadataFacet)project.getFacet(MetadataFacet.class);
        metadata.setProjectName(artifactId);
        return project;
    }
}

