/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.addons.ui;

import java.util.TreeSet;
import javax.inject.Inject;
import org.jboss.forge.addon.addons.project.AddonProjectConfigurator;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.ui.command.AbstractUICommand;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UINavigationContext;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.input.UISelectMany;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.NavigationResult;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.addon.ui.wizard.UIWizardStep;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.addons.AddonId;
import org.jboss.forge.furnace.repositories.AddonRepository;

public class FurnaceAddonSetupStep
extends AbstractUICommand
implements UIWizardStep {
    @Inject
    @WithAttributes(label="Furnace container", required=true, requiredMessage="You must select one Furnace container")
    private UISelectOne<AddonId> furnaceContainer;
    @Inject
    @WithAttributes(label="Create API, Impl, SPI, Tests, and Addon modules")
    private UIInput<Boolean> splitProjects;
    @Inject
    @WithAttributes(label="Depend on these addons")
    private UISelectMany<AddonId> addons;
    @Inject
    private Furnace furnace;
    @Inject
    private AddonProjectConfigurator addonProjectFactory;

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(((Object)((Object)this)).getClass()).name("Furnace Addon Setup").description("Enable Furnace Addon development in your project.").category(Categories.create((String[])new String[]{"Project", "Furnace"}));
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        this.configureAddonDependencies();
        builder.add(this.furnaceContainer).add(this.splitProjects).add(this.addons);
    }

    private void configureAddonDependencies() {
        TreeSet<AddonId> addonChoices = new TreeSet<AddonId>();
        TreeSet<AddonId> containerChoices = new TreeSet<AddonId>();
        for (AddonRepository repository : this.furnace.getRepositories()) {
            for (AddonId id : repository.listEnabled()) {
                boolean isContainerAddon = id.getName().contains("org.jboss.forge.furnace.container");
                if (isContainerAddon) {
                    containerChoices.add(id);
                    continue;
                }
                addonChoices.add(id);
            }
        }
        this.addons.setValueChoices(addonChoices);
        this.furnaceContainer.setValueChoices(containerChoices);
    }

    public Result execute(UIExecutionContext context) throws Exception {
        Project project = (Project)context.getUIContext().getAttributeMap().get(Project.class);
        TreeSet<Object> dependencyAddons = new TreeSet<Object>();
        if (this.addons.hasValue()) {
            for (AddonId id : this.addons.getValue()) {
                dependencyAddons.add(id);
            }
        }
        dependencyAddons.add(this.furnaceContainer.getValue());
        if (((Boolean)this.splitProjects.getValue()).booleanValue()) {
            this.addonProjectFactory.setupComplexAddonProject(project, this.furnace.getVersion(), dependencyAddons);
        } else {
            this.addonProjectFactory.setupSimpleAddonProject(project, this.furnace.getVersion(), dependencyAddons);
        }
        return Results.success();
    }

    public NavigationResult next(UINavigationContext context) throws Exception {
        return null;
    }
}

