/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.addons.ui;

import java.util.Arrays;
import java.util.Iterator;
import java.util.TreeSet;
import javax.inject.Inject;
import org.jboss.forge.addon.addons.facets.AddonTestFacet;
import org.jboss.forge.addon.addons.ui.NewFurnaceTestCommand;
import org.jboss.forge.addon.dependencies.Dependency;
import org.jboss.forge.addon.dependencies.builder.DependencyBuilder;
import org.jboss.forge.addon.facets.constraints.FacetConstraint;
import org.jboss.forge.addon.parser.java.facets.JavaSourceFacet;
import org.jboss.forge.addon.parser.java.resources.JavaResource;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.ProjectFactory;
import org.jboss.forge.addon.projects.dependencies.DependencyInstaller;
import org.jboss.forge.addon.projects.ui.AbstractProjectCommand;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.input.UISelectMany;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.addons.AddonId;
import org.jboss.forge.furnace.repositories.AddonRepository;
import org.jboss.forge.roaster.Roaster;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.forge.roaster.model.source.JavaSource;
import org.jboss.forge.roaster.model.source.MethodSource;

@FacetConstraint(value={AddonTestFacet.class})
public class NewFurnaceTestCommandImpl
extends AbstractProjectCommand
implements NewFurnaceTestCommand {
    private static final String DEFAULT_CONTAINER_NAME = "org.jboss.forge.furnace.container:cdi";
    private static final String DEFAULT_DEPENDENCY_NAME = "org.jboss.forge.addon:core";
    @Inject
    private ProjectFactory projectFactory;
    @Inject
    private Furnace furnace;
    @Inject
    private DependencyInstaller dependencyInstaller;
    @Inject
    @WithAttributes(label="Package Name", type="org.jboss.forge.inputType.JAVA_PACKAGE_PICKER")
    private UIInput<String> packageName;
    @Inject
    @WithAttributes(label="Test Class Name", required=true)
    private UIInput<String> named;
    @Inject
    @WithAttributes(label="Furnace container", required=true, requiredMessage="You must select one Furnace container")
    private UISelectOne<AddonId> furnaceContainer;
    @Inject
    @WithAttributes(label="Dependency addons", description="Addons this test depends upon")
    private UISelectMany<AddonId> addonDependencies;

    public void initializeUI(UIBuilder builder) throws Exception {
        this.configureAddonDependencies();
        Project project = this.getSelectedProject(builder.getUIContext());
        this.packageName.setDefaultValue((Object)((JavaSourceFacet)project.getFacet(JavaSourceFacet.class)).getBasePackage());
        builder.add(this.packageName).add(this.named).add(this.furnaceContainer).add(this.addonDependencies);
    }

    private void configureAddonDependencies() {
        TreeSet<AddonId> addonChoices = new TreeSet<AddonId>();
        TreeSet<AddonId> containerChoices = new TreeSet<AddonId>();
        AddonId defaultContainer = null;
        AddonId defaultDependency = null;
        for (AddonRepository repository : this.furnace.getRepositories()) {
            for (AddonId id : repository.listEnabled()) {
                if (DEFAULT_CONTAINER_NAME.equals(id.getName())) {
                    defaultContainer = id;
                } else if (DEFAULT_DEPENDENCY_NAME.equals(id.getName())) {
                    defaultDependency = id;
                }
                boolean isContainerAddon = id.getName().contains("org.jboss.forge.furnace.container");
                if (isContainerAddon) {
                    containerChoices.add(id);
                    continue;
                }
                addonChoices.add(id);
            }
        }
        ((UISelectOne)this.furnaceContainer.setValueChoices(containerChoices)).setDefaultValue(defaultContainer);
        this.addonDependencies.setValueChoices(addonChoices);
        if (defaultDependency != null) {
            this.addonDependencies.setDefaultValue(Arrays.asList(defaultDependency));
        }
    }

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(((Object)((Object)this)).getClass()).name("Addon: New Test").description("Generates a Furnace test case for an addon").category(Categories.create((String[])new String[]{"Forge", "Generate"}));
    }

    public Result execute(UIExecutionContext context) throws Exception {
        UIContext uiContext = context.getUIContext();
        Project project = this.getSelectedProject(uiContext);
        JavaClassSource javaClass = (JavaClassSource)((JavaClassSource)((JavaClassSource)Roaster.create(JavaClassSource.class)).setName((String)this.named.getValue())).setPackage((String)this.packageName.getValue());
        javaClass.addImport("org.jboss.arquillian.container.test.api.Deployment");
        javaClass.addImport("org.jboss.arquillian.junit.Arquillian");
        javaClass.addImport("org.jboss.forge.arquillian.AddonDependency");
        javaClass.addImport("org.jboss.forge.arquillian.Dependencies");
        javaClass.addImport("org.jboss.forge.arquillian.archive.ForgeArchive");
        javaClass.addImport("org.jboss.forge.furnace.repositories.AddonDependencyEntry");
        javaClass.addImport("org.jboss.shrinkwrap.api.ShrinkWrap");
        javaClass.addImport("org.junit.runner.RunWith");
        javaClass.addAnnotation("RunWith").setLiteralValue("Arquillian.class");
        StringBuilder body = new StringBuilder("ForgeArchive archive = ShrinkWrap.create(ForgeArchive.class).addBeansXML()");
        StringBuilder dependenciesAnnotationBody = new StringBuilder();
        body.append(".addAsAddonDependencies(");
        AddonId furnaceContainerId = (AddonId)this.furnaceContainer.getValue();
        this.addAddonDependency(project, body, dependenciesAnnotationBody, furnaceContainerId);
        Iterator it = this.addonDependencies.getValue().iterator();
        if (it.hasNext()) {
            body.append(",");
            dependenciesAnnotationBody.append(",");
        }
        while (it.hasNext()) {
            AddonId addonId = (AddonId)it.next();
            this.addAddonDependency(project, body, dependenciesAnnotationBody, addonId);
            if (!it.hasNext()) continue;
            body.append(",");
            dependenciesAnnotationBody.append(",");
        }
        body.append(")");
        body.append(";");
        body.append("return archive;");
        MethodSource getDeployment = ((MethodSource)((MethodSource)((MethodSource)javaClass.addMethod().setName("getDeployment")).setPublic()).setStatic(true)).setBody(body.toString()).setReturnType("ForgeArchive");
        getDeployment.addAnnotation("Deployment");
        String annotationBody = dependenciesAnnotationBody.toString();
        if (annotationBody.length() > 0) {
            getDeployment.addAnnotation("Dependencies").setLiteralValue("{" + annotationBody + "}");
        }
        JavaSourceFacet facet = (JavaSourceFacet)project.getFacet(JavaSourceFacet.class);
        JavaResource javaResource = facet.saveTestJavaSource((JavaSource)javaClass);
        uiContext.setSelection((Object)javaResource);
        return Results.success((String)("Test class " + javaClass.getQualifiedName() + " created"));
    }

    private void addAddonDependency(Project project, StringBuilder body, StringBuilder dependenciesAnnotationBody, AddonId addonId) {
        DependencyBuilder dependency = DependencyBuilder.create((String)addonId.getName()).setVersion(addonId.getVersion().toString()).setClassifier("forge-addon").setScopeType("test");
        String name = addonId.getName();
        if (!this.dependencyInstaller.isInstalled(project, (Dependency)dependency)) {
            this.dependencyInstaller.install(project, (Dependency)dependency);
        }
        body.append("AddonDependencyEntry.create(\"").append(name);
        dependenciesAnnotationBody.append("@AddonDependency(name = \"").append(name);
        body.append("\")");
        dependenciesAnnotationBody.append("\")");
    }

    protected boolean isProjectRequired() {
        return true;
    }

    protected ProjectFactory getProjectFactory() {
        return this.projectFactory;
    }
}

