/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.addons.ui;

import java.util.Arrays;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import org.jboss.forge.addon.addons.facets.AddonTestFacet;
import org.jboss.forge.addon.addons.ui.NewFurnaceTestCommand;
import org.jboss.forge.addon.dependencies.Dependency;
import org.jboss.forge.addon.dependencies.builder.DependencyBuilder;
import org.jboss.forge.addon.facets.constraints.FacetConstraint;
import org.jboss.forge.addon.parser.java.facets.JavaSourceFacet;
import org.jboss.forge.addon.parser.java.resources.JavaResource;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.ProjectFactory;
import org.jboss.forge.addon.projects.dependencies.DependencyInstaller;
import org.jboss.forge.addon.projects.ui.AbstractProjectCommand;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.facets.HintsFacet;
import org.jboss.forge.addon.ui.input.InputComponentFactory;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.input.UISelectMany;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.addons.AddonId;
import org.jboss.forge.furnace.container.simple.lifecycle.SimpleContainer;
import org.jboss.forge.furnace.repositories.AddonRepository;
import org.jboss.forge.roaster.Roaster;
import org.jboss.forge.roaster.model.source.AnnotationSource;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.forge.roaster.model.source.JavaSource;
import org.jboss.forge.roaster.model.source.MethodSource;

@FacetConstraint(value={AddonTestFacet.class})
public class NewFurnaceTestCommandImpl
extends AbstractProjectCommand
implements NewFurnaceTestCommand {
    private static final String DEFAULT_CONTAINER_NAME = "org.jboss.forge.furnace.container:cdi";
    private static final String DEFAULT_DEPENDENCY_NAME = "org.jboss.forge.addon:core";
    private UIInput<String> packageName;
    private UIInput<String> named;
    private UIInput<Boolean> reuseProjectAddons;
    private UISelectOne<AddonId> furnaceContainer;
    private UISelectMany<AddonId> addonDependencies;

    public void initializeUI(UIBuilder builder) throws Exception {
        InputComponentFactory factory = builder.getInputComponentFactory();
        this.packageName = (UIInput)factory.createInput("packageName", String.class).setLabel("Package Name");
        ((HintsFacet)this.packageName.getFacet(HintsFacet.class)).setInputType("org.jboss.forge.inputType.JAVA_PACKAGE_PICKER");
        this.named = (UIInput)((UIInput)factory.createInput("named", String.class).setLabel("Test Class Name")).setRequired(true);
        this.reuseProjectAddons = (UIInput)((UIInput)((UIInput)factory.createInput("reuseProjectAddons", Boolean.class).setLabel("Use Addons from current project as dependencies (automatic discovery)")).setDescription("This will create an empty @AddonDependencies and reuse the addons in the current project's pom.xml")).setDefaultValue((Object)true);
        this.furnaceContainer = (UISelectOne)((UISelectOne)factory.createSelectOne("furnaceContainer", AddonId.class).setLabel("Furnace container")).setRequiredMessage("You must select one Furnace container");
        this.addonDependencies = (UISelectMany)((UISelectMany)factory.createSelectMany("addonDependencies", AddonId.class).setLabel("Dependency addons")).setDescription("Addons this test depends upon");
        this.configureAddonDependencies();
        Project project = this.getSelectedProject(builder.getUIContext());
        this.packageName.setDefaultValue((Object)((JavaSourceFacet)project.getFacet(JavaSourceFacet.class)).getBasePackage());
        builder.add(this.packageName).add(this.named).add(this.reuseProjectAddons).add(this.furnaceContainer).add(this.addonDependencies);
    }

    private void configureAddonDependencies() {
        TreeSet<AddonId> addonChoices = new TreeSet<AddonId>();
        TreeSet<AddonId> containerChoices = new TreeSet<AddonId>();
        AddonId defaultContainer = null;
        AddonId defaultDependency = null;
        Furnace furnace = SimpleContainer.getFurnace((ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        for (AddonRepository repository : furnace.getRepositories()) {
            for (AddonId id : repository.listEnabled()) {
                if (DEFAULT_CONTAINER_NAME.equals(id.getName())) {
                    defaultContainer = id;
                } else if (DEFAULT_DEPENDENCY_NAME.equals(id.getName())) {
                    defaultDependency = id;
                }
                boolean isContainerAddon = id.getName().contains("org.jboss.forge.furnace.container");
                if (isContainerAddon) {
                    containerChoices.add(id);
                    continue;
                }
                addonChoices.add(id);
            }
        }
        ((UISelectOne)this.furnaceContainer.setValueChoices(containerChoices)).setDefaultValue(defaultContainer);
        this.addonDependencies.setValueChoices(addonChoices);
        if (defaultDependency != null) {
            this.addonDependencies.setDefaultValue(Arrays.asList(defaultDependency));
        }
        Callable<Boolean> reuseProjectDepsCallable = new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return (Boolean)NewFurnaceTestCommandImpl.this.reuseProjectAddons.getValue() == false;
            }
        };
        ((UISelectOne)this.furnaceContainer.setEnabled((Callable)reuseProjectDepsCallable)).setRequired((Callable)reuseProjectDepsCallable);
        this.addonDependencies.setEnabled((Callable)reuseProjectDepsCallable);
    }

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(((Object)((Object)this)).getClass()).name("Addon: New Test").description("Generates a Furnace test case for an addon").category(Categories.create((String[])new String[]{"Forge", "Generate"}));
    }

    public Result execute(UIExecutionContext context) throws Exception {
        UIContext uiContext = context.getUIContext();
        Project project = this.getSelectedProject(uiContext);
        JavaClassSource javaClass = (JavaClassSource)((JavaClassSource)((JavaClassSource)Roaster.create(JavaClassSource.class)).setName((String)this.named.getValue())).setPackage((String)this.packageName.getValue());
        javaClass.addImport("org.jboss.arquillian.container.test.api.Deployment");
        javaClass.addImport("org.jboss.arquillian.junit.Arquillian");
        javaClass.addImport("org.jboss.forge.arquillian.AddonDependency");
        javaClass.addImport("org.jboss.forge.arquillian.AddonDependencies");
        javaClass.addImport("org.jboss.forge.arquillian.archive.AddonArchive");
        javaClass.addImport("org.jboss.shrinkwrap.api.ShrinkWrap");
        javaClass.addImport("org.junit.runner.RunWith");
        javaClass.addImport("org.junit.Assert");
        javaClass.addImport("org.junit.Test");
        javaClass.addAnnotation("RunWith").setLiteralValue("Arquillian.class");
        MethodSource getDeployment = ((MethodSource)((MethodSource)((MethodSource)javaClass.addMethod().setName("getDeployment")).setPublic()).setStatic(true)).setBody("return ShrinkWrap.create(AddonArchive.class).addBeansXML();").setReturnType("AddonArchive");
        getDeployment.addAnnotation("Deployment");
        AnnotationSource addonDependenciesAnn = getDeployment.addAnnotation("AddonDependencies");
        if (!((Boolean)this.reuseProjectAddons.getValue()).booleanValue()) {
            StringBuilder dependenciesAnnotationBody = new StringBuilder();
            AddonId furnaceContainerId = (AddonId)this.furnaceContainer.getValue();
            this.addAddonDependency(project, dependenciesAnnotationBody, furnaceContainerId);
            Iterator it = this.addonDependencies.getValue().iterator();
            if (it.hasNext()) {
                dependenciesAnnotationBody.append(",");
            }
            while (it.hasNext()) {
                AddonId addonId = (AddonId)it.next();
                this.addAddonDependency(project, dependenciesAnnotationBody, addonId);
                if (!it.hasNext()) continue;
                dependenciesAnnotationBody.append(",");
            }
            String annotationBody = dependenciesAnnotationBody.toString();
            if (annotationBody.length() > 0) {
                addonDependenciesAnn.setLiteralValue("{" + annotationBody + "}");
            }
        }
        ((MethodSource)((MethodSource)javaClass.addMethod().setName("testAddon")).setPublic()).setReturnTypeVoid().setBody("Assert.fail(\"Not yet implemented\");").addAnnotation("Test");
        JavaSourceFacet facet = (JavaSourceFacet)project.getFacet(JavaSourceFacet.class);
        JavaResource javaResource = facet.saveTestJavaSource((JavaSource)javaClass);
        uiContext.setSelection((Object)javaResource);
        return Results.success((String)("Test class " + javaClass.getQualifiedName() + " created"));
    }

    private void addAddonDependency(Project project, StringBuilder dependenciesAnnotationBody, AddonId addonId) {
        DependencyInstaller dependencyInstaller = (DependencyInstaller)SimpleContainer.getServices((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), DependencyInstaller.class).get();
        DependencyBuilder dependency = DependencyBuilder.create((String)addonId.getName()).setVersion(addonId.getVersion().toString()).setClassifier("forge-addon").setScopeType("test");
        String name = addonId.getName();
        if (!dependencyInstaller.isInstalled(project, (Dependency)dependency)) {
            dependencyInstaller.install(project, (Dependency)dependency);
        }
        dependenciesAnnotationBody.append("@AddonDependency(name = \"").append(name).append("\")");
    }

    protected boolean isProjectRequired() {
        return true;
    }

    protected ProjectFactory getProjectFactory() {
        return (ProjectFactory)SimpleContainer.getServices((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), ProjectFactory.class).get();
    }
}

