/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.addons.ui;

import java.util.ArrayList;
import java.util.TreeSet;
import org.jboss.forge.addon.addons.facets.AddonTestFacet;
import org.jboss.forge.addon.addons.facets.FurnaceVersionFacet;
import org.jboss.forge.addon.addons.ui.NewFurnaceTestSetupCommand;
import org.jboss.forge.addon.dependencies.Dependency;
import org.jboss.forge.addon.dependencies.builder.DependencyBuilder;
import org.jboss.forge.addon.facets.FacetFactory;
import org.jboss.forge.addon.facets.Faceted;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.ProjectFactory;
import org.jboss.forge.addon.projects.dependencies.DependencyInstaller;
import org.jboss.forge.addon.projects.facets.MetadataFacet;
import org.jboss.forge.addon.projects.ui.AbstractProjectCommand;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.input.InputComponentFactory;
import org.jboss.forge.addon.ui.input.UISelectMany;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.addons.AddonId;
import org.jboss.forge.furnace.container.simple.lifecycle.SimpleContainer;
import org.jboss.forge.furnace.repositories.AddonRepository;

public class NewFurnaceTestSetupCommandImpl
extends AbstractProjectCommand
implements NewFurnaceTestSetupCommand {
    private UISelectMany<AddonId> addonDependencies;

    public void initializeUI(UIBuilder builder) throws Exception {
        InputComponentFactory factory = builder.getInputComponentFactory();
        this.addonDependencies = (UISelectMany)((UISelectMany)factory.createSelectMany("addonDependencies", AddonId.class).setLabel("Dependency addons")).setDescription("Addons this test depends upon");
        TreeSet<AddonId> choices = new TreeSet<AddonId>();
        Furnace furnace = SimpleContainer.getFurnace((ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        for (AddonRepository repository : furnace.getRepositories()) {
            for (AddonId id : repository.listEnabled()) {
                if (!id.getName().contains(":")) continue;
                choices.add(id);
            }
        }
        this.addonDependencies.setValueChoices(choices);
        this.addonDependencies.setDefaultValue(new ArrayList());
        builder.add(this.addonDependencies);
    }

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(((Object)((Object)this)).getClass()).name("Addon: Test Setup").description("Add addon test setup to this project").category(Categories.create((String[])new String[]{"Forge", "Generate"}));
    }

    public Result execute(UIExecutionContext context) throws Exception {
        Furnace furnace = SimpleContainer.getFurnace((ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        FacetFactory facetFactory = (FacetFactory)SimpleContainer.getServices((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), FacetFactory.class).get();
        DependencyInstaller dependencyInstaller = (DependencyInstaller)SimpleContainer.getServices((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), DependencyInstaller.class).get();
        UIContext uiContext = context.getUIContext();
        Project project = this.getSelectedProject(uiContext);
        facetFactory.install((Faceted)project, FurnaceVersionFacet.class);
        ((FurnaceVersionFacet)project.getFacet(FurnaceVersionFacet.class)).setVersion(furnace.getVersion().toString());
        facetFactory.install((Faceted)project, AddonTestFacet.class);
        for (AddonId addonId : this.addonDependencies.getValue()) {
            DependencyBuilder dependency = DependencyBuilder.create((String)addonId.getName()).setVersion(addonId.getVersion().toString()).setScopeType("test");
            if (dependencyInstaller.isInstalled(project, (Dependency)dependency)) continue;
            dependencyInstaller.install(project, (Dependency)dependency);
        }
        return Results.success((String)("Project " + ((MetadataFacet)project.getFacet(MetadataFacet.class)).getProjectName() + " is now configured for testing"));
    }

    protected boolean isProjectRequired() {
        return true;
    }

    protected ProjectFactory getProjectFactory() {
        return (ProjectFactory)SimpleContainer.getServices((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), ProjectFactory.class).get();
    }
}

