/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.dependencies.builder;

import java.util.ArrayList;
import java.util.List;
import org.jboss.forge.addon.dependencies.Coordinate;
import org.jboss.forge.addon.dependencies.Dependency;
import org.jboss.forge.addon.dependencies.builder.CoordinateBuilder;
import org.jboss.forge.addon.resource.FileResource;

public class DependencyBuilder
implements Dependency {
    private CoordinateBuilder coordinate = CoordinateBuilder.create();
    private String scopeType;
    private FileResource<?> artifact;
    private boolean optional;
    private List<Coordinate> exclusions;

    private DependencyBuilder() {
    }

    public static DependencyBuilder create() {
        return new DependencyBuilder();
    }

    public static DependencyBuilder create(Dependency dep) {
        DependencyBuilder builder = new DependencyBuilder();
        builder.setCoordinate(dep.getCoordinate());
        builder.setScopeType(dep.getScopeType());
        return builder;
    }

    public static DependencyBuilder create(String identifier) {
        DependencyBuilder dependencyBuilder = new DependencyBuilder();
        if (identifier != null) {
            String trimmed;
            String[] split = identifier.split(":");
            if (split.length > 0) {
                dependencyBuilder.setGroupId(split[0].trim());
            }
            if (split.length > 1) {
                dependencyBuilder.setArtifactId(split[1].trim());
            }
            if (split.length > 2) {
                dependencyBuilder.setVersion(split[2].trim());
            }
            if (split.length > 3) {
                trimmed = split[3].trim();
                dependencyBuilder.setScopeType(trimmed);
            }
            if (split.length > 4) {
                trimmed = split[4].trim();
                dependencyBuilder.setPackaging(trimmed);
            }
        }
        return dependencyBuilder;
    }

    public DependencyBuilder addExclusion(Coordinate coordinate) {
        if (this.exclusions == null) {
            this.exclusions = new ArrayList<Coordinate>();
        }
        this.exclusions.add(coordinate);
        return this;
    }

    @Override
    public List<Coordinate> getExcludedCoordinates() {
        return this.exclusions;
    }

    public DependencyBuilder setExcludedCoordinates(List<Coordinate> coordinates) {
        this.exclusions = coordinates;
        return this;
    }

    public DependencyBuilder setPackaging(String packaging) {
        this.getCoordinate().setPackaging(packaging);
        return this;
    }

    public DependencyBuilder setArtifactId(String artifactId) {
        this.getCoordinate().setArtifactId(artifactId);
        return this;
    }

    public DependencyBuilder setVersion(String version) {
        this.getCoordinate().setVersion(version);
        return this;
    }

    public DependencyBuilder setGroupId(String groupId) {
        this.getCoordinate().setGroupId(groupId);
        return this;
    }

    public DependencyBuilder setScopeType(String scope) {
        this.scopeType = scope;
        return this;
    }

    public String getGroupId() {
        return this.getCoordinate().getGroupId();
    }

    @Override
    public String getScopeType() {
        return this.scopeType;
    }

    @Override
    public boolean isOptional() {
        return this.optional;
    }

    public DependencyBuilder setOptional(boolean optional) {
        this.optional = optional;
        return this;
    }

    @Override
    public FileResource<?> getArtifact() {
        return this.artifact;
    }

    @Override
    public CoordinateBuilder getCoordinate() {
        return this.coordinate;
    }

    public DependencyBuilder setCoordinate(Coordinate coordinate) {
        this.coordinate = CoordinateBuilder.create(coordinate);
        return this;
    }

    public DependencyBuilder setArtifact(FileResource<?> artifact) {
        this.artifact = artifact;
        return this;
    }

    public DependencyBuilder setClassifier(String classifier) {
        this.getCoordinate().setClassifier(classifier);
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.coordinate != null) {
            builder.append(this.coordinate);
        }
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.coordinate == null ? 0 : this.coordinate.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DependencyBuilder other = (DependencyBuilder)obj;
        return !(this.coordinate == null ? other.coordinate != null : !this.coordinate.equals(other.coordinate));
    }
}

