/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.dependencies.builder;

import java.util.Map;
import org.jboss.forge.addon.dependencies.Coordinate;

public class CoordinateBuilder
implements Coordinate {
    private String groupId;
    private String artifactId;
    private String version;
    private String classifier;
    private String packaging;
    private String systemPath;

    public static CoordinateBuilder create(String coordinates) {
        CoordinateBuilder builder = CoordinateBuilder.create();
        String[] split = coordinates.split("\\:");
        if (split.length == 0) {
            throw new IllegalArgumentException("Malformed coordinate. Should be groupId:artifactId:[packaging]:[classifier]:[version]");
        }
        if (split.length > 0) {
            builder.setGroupId(split[0]);
        }
        if (split.length > 1) {
            builder.setArtifactId(split[1]);
        }
        if (split.length == 3) {
            builder.setVersion(split[2]);
        } else {
            if (split.length > 2) {
                builder.setPackaging(split[2]);
            }
            if (split.length > 3) {
                builder.setClassifier(split[3]);
            }
            if (split.length > 4) {
                builder.setVersion(split[4]);
            }
        }
        return builder;
    }

    public static CoordinateBuilder create(Map<String, String> atts) {
        CoordinateBuilder builder = CoordinateBuilder.create();
        builder.setGroupId(atts.get("groupId"));
        builder.setArtifactId(atts.get("artifactId"));
        builder.setVersion(atts.get("version"));
        builder.setClassifier(atts.get("classifier"));
        builder.setPackaging(atts.get("packaging"));
        return builder;
    }

    public static CoordinateBuilder create(Coordinate c) {
        CoordinateBuilder builder = CoordinateBuilder.create();
        builder.setGroupId(c.getGroupId()).setArtifactId(c.getArtifactId());
        builder.setClassifier(c.getClassifier()).setPackaging(c.getPackaging()).setVersion(c.getVersion());
        return builder;
    }

    public static CoordinateBuilder create() {
        return new CoordinateBuilder();
    }

    private CoordinateBuilder() {
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    public String getArtifactId() {
        return this.artifactId;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public boolean isSnapshot() {
        return this.getVersion() != null && this.getVersion().endsWith("SNAPSHOT");
    }

    public CoordinateBuilder setGroupId(String groupId) {
        this.groupId = groupId;
        return this;
    }

    public CoordinateBuilder setArtifactId(String artifactId) {
        this.artifactId = artifactId;
        return this;
    }

    public CoordinateBuilder setVersion(String version) {
        this.version = version;
        return this;
    }

    @Override
    public String getClassifier() {
        return this.classifier;
    }

    public CoordinateBuilder setClassifier(String classifier) {
        this.classifier = classifier;
        return this;
    }

    @Override
    public String getPackaging() {
        return this.packaging;
    }

    @Override
    public String getSystemPath() {
        return this.systemPath;
    }

    public CoordinateBuilder setPackaging(String packaging) {
        this.packaging = packaging;
        return this;
    }

    public CoordinateBuilder setSystemPath(String systemPath) {
        this.systemPath = systemPath;
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.artifactId == null ? 0 : this.artifactId.hashCode());
        result = 31 * result + (this.classifier == null ? 0 : this.classifier.hashCode());
        result = 31 * result + (this.groupId == null ? 0 : this.groupId.hashCode());
        result = 31 * result + (this.packaging == null ? 0 : this.packaging.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CoordinateBuilder other = (CoordinateBuilder)obj;
        if (this.artifactId == null ? other.artifactId != null : !this.artifactId.equals(other.artifactId)) {
            return false;
        }
        if (this.classifier == null ? other.classifier != null : !this.classifier.equals(other.classifier)) {
            return false;
        }
        if (this.groupId == null ? other.groupId != null : !this.groupId.equals(other.groupId)) {
            return false;
        }
        if (this.packaging == null ? other.packaging != null : !this.packaging.equals(other.packaging)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }

    private String toId() {
        StringBuilder gav = new StringBuilder(this.getGroupId()).append(":").append(this.getArtifactId());
        gav.append(":");
        if (this.getPackaging() != null) {
            gav.append(this.getPackaging());
        }
        gav.append(":");
        if (this.getClassifier() != null) {
            gav.append(this.getClassifier());
        }
        gav.append(":");
        if (this.getVersion() != null) {
            gav.append(this.getVersion());
        }
        return gav.toString();
    }

    public String toString() {
        return this.toId();
    }
}

