/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.devtools.java;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.jboss.forge.addon.facets.constraints.FacetConstraint;
import org.jboss.forge.addon.parser.java.beans.ProjectOperations;
import org.jboss.forge.addon.parser.java.facets.JavaSourceFacet;
import org.jboss.forge.addon.parser.java.resources.JavaResource;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.ProjectFactory;
import org.jboss.forge.addon.projects.facets.ResourcesFacet;
import org.jboss.forge.addon.projects.ui.AbstractProjectCommand;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIContextProvider;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UISelection;
import org.jboss.forge.addon.ui.facets.HintsFacet;
import org.jboss.forge.addon.ui.input.InputComponentFactory;
import org.jboss.forge.addon.ui.input.UIPrompt;
import org.jboss.forge.addon.ui.input.UISelectMany;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.container.simple.lifecycle.SimpleContainer;
import org.jboss.forge.furnace.repositories.AddonRepository;
import org.jboss.forge.roaster.model.source.FieldSource;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.forge.roaster.model.source.JavaSource;
import org.jboss.forge.roaster.model.util.Refactory;

@FacetConstraint(value={JavaSourceFacet.class, ResourcesFacet.class})
public class JavaEqualsHashcodeCommand
extends AbstractProjectCommand {
    private UISelectOne<JavaResource> targetClass;
    private UISelectMany<String> fields;
    private InputComponentFactory inputFactory;
    private ProjectFactory projectFactory;
    private ProjectOperations projectOperations;

    public JavaEqualsHashcodeCommand() {
        Furnace furnace = SimpleContainer.getFurnace((ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        this.inputFactory = (InputComponentFactory)furnace.getAddonRegistry(new AddonRepository[0]).getServices(InputComponentFactory.class).get();
        this.projectFactory = (ProjectFactory)furnace.getAddonRegistry(new AddonRepository[0]).getServices(ProjectFactory.class).get();
        this.projectOperations = (ProjectOperations)furnace.getAddonRegistry(new AddonRepository[0]).getServices(ProjectOperations.class).get();
    }

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(((Object)((Object)this)).getClass()).name("Java: Generate Equals and HashCode").description("Generates equals and hashcode for the given class").category(Categories.create((String[])new String[]{"Java"}));
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        UIContext uiContext = builder.getUIContext();
        Project project = this.getSelectedProject(uiContext);
        this.targetClass = this.inputFactory.createSelectOne("targetClass", JavaResource.class);
        this.targetClass.setDescription("The class where the field will be created");
        this.targetClass.setRequired(true);
        ((HintsFacet)this.targetClass.getFacet(HintsFacet.class)).setInputType("org.jboss.forge.inputType.DROPDOWN");
        UISelection initialSelection = uiContext.getInitialSelection();
        if (initialSelection.get() instanceof JavaResource) {
            this.targetClass.setValue((Object)((JavaResource)initialSelection.get()));
        }
        this.targetClass.setValueChoices((Iterable)this.projectOperations.getProjectClasses(project));
        this.fields = this.inputFactory.createSelectMany("fields", String.class);
        this.fields.setDescription("Fields, which should be used in the hashCode/equals method generation");
        ((UISelectMany)this.fields.setRequired(true)).setRequiredMessage("At least one field should be selected");
        this.fields.setValueChoices((Callable)new Callable<Iterable<String>>(){

            @Override
            public Iterable<String> call() throws Exception {
                ArrayList<String> strings = new ArrayList<String>();
                if (!JavaEqualsHashcodeCommand.this.fields.isEnabled()) {
                    return strings;
                }
                JavaResource javaResource = (JavaResource)JavaEqualsHashcodeCommand.this.targetClass.getValue();
                JavaClassSource targetClass = (JavaClassSource)javaResource.getJavaType();
                List fields = targetClass.getFields();
                for (FieldSource field : fields) {
                    strings.add(field.getName());
                }
                return strings;
            }
        });
        this.fields.setEnabled((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() {
                return JavaEqualsHashcodeCommand.this.targetClass.getValue() != null;
            }
        });
        builder.add(this.targetClass).add(this.fields);
    }

    public Result execute(UIExecutionContext context) throws Exception {
        JavaResource javaResource = (JavaResource)this.targetClass.getValue();
        JavaClassSource targetClass = (JavaClassSource)javaResource.getJavaType();
        ArrayList<FieldSource> selectedFields = new ArrayList<FieldSource>();
        for (String fieldString : this.fields.getValue()) {
            selectedFields.add(targetClass.getField(fieldString));
        }
        UIPrompt prompt = context.getPrompt();
        if (targetClass.hasMethodSignature("equals", new Class[]{Object.class})) {
            if (prompt.promptBoolean("Class already has an equals method. Would you like it to be overwritten?")) {
                Refactory.createEquals((JavaClassSource)targetClass, (FieldSource[])selectedFields.toArray(new FieldSource[selectedFields.size()]));
            }
        } else {
            Refactory.createEquals((JavaClassSource)targetClass, (FieldSource[])selectedFields.toArray(new FieldSource[selectedFields.size()]));
        }
        if (targetClass.hasMethodSignature("hashcode")) {
            if (prompt.promptBoolean("Class already has a hashcode method. Would you like it to be overwritten?")) {
                Refactory.createHashCode((JavaClassSource)targetClass, (FieldSource[])selectedFields.toArray(new FieldSource[selectedFields.size()]));
            }
        } else {
            Refactory.createHashCode((JavaClassSource)targetClass, (FieldSource[])selectedFields.toArray(new FieldSource[selectedFields.size()]));
        }
        this.setCurrentWorkingResource(context, targetClass);
        return Results.success((String)"Command for generation ended successfully");
    }

    private void setCurrentWorkingResource(UIExecutionContext context, JavaClassSource javaClass) throws FileNotFoundException {
        Project selectedProject = this.getSelectedProject((UIContextProvider)context);
        if (selectedProject != null) {
            JavaSourceFacet facet = (JavaSourceFacet)selectedProject.getFacet(JavaSourceFacet.class);
            facet.saveJavaSource((JavaSource)javaClass);
        }
        context.getUIContext().setSelection((Object)javaClass);
    }

    protected boolean isProjectRequired() {
        return true;
    }

    protected ProjectFactory getProjectFactory() {
        return this.projectFactory;
    }
}

