/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.devtools.java;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.util.LinkedHashSet;
import java.util.List;
import org.jboss.forge.addon.facets.constraints.FacetConstraint;
import org.jboss.forge.addon.parser.java.facets.JavaSourceFacet;
import org.jboss.forge.addon.parser.java.resources.JavaResource;
import org.jboss.forge.addon.projects.ProjectFactory;
import org.jboss.forge.addon.projects.facets.ResourcesFacet;
import org.jboss.forge.addon.projects.ui.AbstractProjectCommand;
import org.jboss.forge.addon.resource.FileResource;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIContextProvider;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.facets.HintsFacet;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.input.InputComponentFactory;
import org.jboss.forge.addon.ui.input.UICompleter;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.container.simple.lifecycle.SimpleContainer;
import org.jboss.forge.furnace.repositories.AddonRepository;
import org.jboss.forge.parser.java.InterfaceCapable;
import org.jboss.forge.parser.java.JavaSource;

@FacetConstraint(value={JavaSourceFacet.class, ResourcesFacet.class})
public class RegisterAsServiceCommand
extends AbstractProjectCommand {
    private final InputComponentFactory inputFactory;
    private UIInput<JavaResource> type;
    private UIInput<String> serviceType;
    private final ProjectFactory projectFactory;

    public RegisterAsServiceCommand() {
        Furnace furnace = SimpleContainer.getFurnace((ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        this.inputFactory = (InputComponentFactory)furnace.getAddonRegistry(new AddonRepository[0]).getServices(InputComponentFactory.class).get();
        this.projectFactory = (ProjectFactory)furnace.getAddonRegistry(new AddonRepository[0]).getServices(ProjectFactory.class).get();
    }

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(RegisterAsServiceCommand.class).category(Categories.create((String[])new String[]{"Java", "ServiceLoader"})).description("Register a Java type as a service implementation.").name("Service: Register as ServiceLoader");
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        this.type = this.inputFactory.createInput("type", JavaResource.class);
        ((HintsFacet)this.type.getFacet(HintsFacet.class)).setInputType("org.jboss.forge.inputType.JAVA_CLASS_PICKER");
        this.type.setRequired(true);
        Object selection = builder.getUIContext().getInitialSelection().get();
        if (selection instanceof JavaResource) {
            this.type.setDefaultValue((Object)((JavaResource)selection));
        }
        this.serviceType = this.inputFactory.createInput("serviceInterface", String.class);
        ((HintsFacet)this.serviceType.getFacet(HintsFacet.class)).setInputType("org.jboss.forge.inputType.JAVA_CLASS_PICKER");
        this.serviceType.setRequired(true);
        this.serviceType.setCompleter((UICompleter)new UICompleter<String>(){

            public Iterable<String> getCompletionProposals(UIContext context, InputComponent<?, String> input, String value) {
                LinkedHashSet<String> result = new LinkedHashSet<String>();
                if (RegisterAsServiceCommand.this.type.getValue() != null) {
                    try {
                        JavaSource source = ((JavaResource)RegisterAsServiceCommand.this.type.getValue()).getJavaSource();
                        if (source instanceof InterfaceCapable) {
                            List interfaces = ((InterfaceCapable)source).getInterfaces();
                            for (String type : interfaces) {
                                if (!type.startsWith(value)) continue;
                                result.add(type);
                            }
                        }
                    }
                    catch (FileNotFoundException e) {
                        // empty catch block
                    }
                }
                return result;
            }
        });
        builder.add(this.type).add(this.serviceType);
    }

    public Result execute(UIExecutionContext context) throws Exception {
        String implName = ((JavaResource)((JavaResource)this.type.getValue()).reify(JavaResource.class)).getJavaSource().getQualifiedName();
        String interfaceName = (String)this.serviceType.getValue();
        FileResource registryFile = ((ResourcesFacet)this.getSelectedProject((UIContextProvider)context).getFacet(ResourcesFacet.class)).getResource("META-INF/services/" + interfaceName);
        if (!registryFile.exists()) {
            registryFile.createNewFile();
            registryFile.setContents(implName);
        } else {
            StringBuilder builder = new StringBuilder();
            BufferedReader reader = new BufferedReader(new InputStreamReader(registryFile.getResourceInputStream()));
            boolean found = false;
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (line.matches("\\s*" + interfaceName + "\\s*")) {
                    found = true;
                }
                builder.append(line);
            }
            if (!found) {
                builder.append("\n" + implName);
                registryFile.setContents(builder.toString());
            }
        }
        return Results.success((String)("Type '" + implName + "' is registered as service of type '" + interfaceName + "'"));
    }

    protected boolean isProjectRequired() {
        return true;
    }

    protected ProjectFactory getProjectFactory() {
        return this.projectFactory;
    }
}

