/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.devtools.java;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.jboss.forge.addon.configuration.Configuration;
import org.jboss.forge.addon.parser.java.resources.JavaResource;
import org.jboss.forge.addon.parser.xml.resources.XMLResource;
import org.jboss.forge.addon.resource.FileResource;
import org.jboss.forge.addon.resource.Resource;
import org.jboss.forge.addon.resource.ResourceFactory;
import org.jboss.forge.addon.ui.command.AbstractUICommand;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UISelection;
import org.jboss.forge.addon.ui.input.InputComponentFactory;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.input.UIInputMany;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.container.simple.lifecycle.SimpleContainer;
import org.jboss.forge.furnace.repositories.AddonRepository;
import org.jboss.forge.roaster.model.util.FormatterProfileReader;
import org.jboss.forge.roaster.model.util.Strings;

public class JavaFormatSourcesCommand
extends AbstractUICommand {
    private final InputComponentFactory inputFactory;
    private UIInput<XMLResource> profilepath;
    private UIInputMany<FileResource> sources;
    private UIInput<String> profilename;
    private Configuration userConfig;
    private ResourceFactory resourceFactory;

    public JavaFormatSourcesCommand() {
        Furnace furnace = SimpleContainer.getFurnace((ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        this.inputFactory = (InputComponentFactory)furnace.getAddonRegistry(new AddonRepository[0]).getServices(InputComponentFactory.class).get();
        this.userConfig = (Configuration)furnace.getAddonRegistry(new AddonRepository[0]).getServices(Configuration.class).get();
        this.resourceFactory = (ResourceFactory)furnace.getAddonRegistry(new AddonRepository[0]).getServices(ResourceFactory.class).get();
    }

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(((Object)((Object)this)).getClass()).name("Java: Format Sources").description("command to format a file (or folder recursively) of Java source files").category(Categories.create((String[])new String[]{"Java"}));
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        String path;
        this.sources = this.inputFactory.createInputMany("sources", 's', FileResource.class);
        this.sources.setDescription("The folder or file where the java sources will be formatted");
        this.profilepath = this.inputFactory.createInput("profilepath", 'p', XMLResource.class);
        this.profilepath.setDescription("The eclipse code format profile");
        this.profilename = this.inputFactory.createInput("profilename", 'n', String.class);
        this.profilename.setDescription("The eclipse code format profile name");
        String profileName = this.userConfig.getString("org.jboss.forge.addon.parser.java.formatter_profile_name");
        if (!Strings.isNullOrEmpty((String)profileName)) {
            this.profilename.setDefaultValue((Object)profileName);
        }
        if (!Strings.isNullOrEmpty((String)(path = this.userConfig.getString("org.jboss.forge.addon.parser.java.formatter_profile_path")))) {
            XMLResource resource = (XMLResource)this.resourceFactory.create(XMLResource.class, (Object)new File(path));
            this.profilepath.setDefaultValue((Object)resource);
        }
        builder.add(this.sources).add(this.profilepath).add(this.profilename);
    }

    public Result execute(UIExecutionContext context) throws Exception {
        XMLResource formatProfileLocation = (XMLResource)this.profilepath.getValue();
        Iterable formatSources = this.sources.getValue();
        String formatterName = (String)this.profilename.getValue();
        ArrayList fileResourceList = new ArrayList();
        if (!formatSources.iterator().hasNext()) {
            UISelection us = context.getUIContext().getInitialSelection();
            Resource rs = (Resource)us.get();
            FileResource fr = (FileResource)rs.reify(FileResource.class);
            fileResourceList.add(fr);
        } else {
            for (FileResource fileResource : formatSources) {
                fileResourceList.add(fileResource);
            }
        }
        Properties formatProfile = null;
        if (formatProfileLocation == null || !formatProfileLocation.exists()) {
            formatProfile = null;
        } else {
            try (InputStream is = formatProfileLocation.getResourceInputStream();){
                FormatterProfileReader reader = FormatterProfileReader.fromEclipseXml((InputStream)is);
                formatProfile = reader.getPropertiesFor(formatterName);
            }
        }
        if (formatProfile != null) {
            JavaFormatSourcesCommand.format(fileResourceList, formatProfile);
            return Results.success((String)"Files Formatted Sucessfully");
        }
        return Results.fail((String)"No format profile found to be applied");
    }

    private static void format(List<FileResource<?>> fileResourceList, Properties formatProfile) {
        for (FileResource<?> fileResource : fileResourceList) {
            if (fileResource.isDirectory()) {
                ArrayList newFileResourceList = new ArrayList();
                List resourceList = fileResource.listResources();
                for (Resource resource : resourceList) {
                    newFileResourceList.add((FileResource<?>)resource.reify(FileResource.class));
                }
                JavaFormatSourcesCommand.format(newFileResourceList, formatProfile);
                continue;
            }
            if (!(fileResource instanceof JavaResource)) continue;
            JavaResource file = (JavaResource)fileResource.reify(JavaResource.class);
            file.setContents(fileResource.getResourceInputStream(), formatProfile);
        }
    }
}

