/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.facets;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.inject.Inject;
import org.jboss.forge.addon.facets.Facet;
import org.jboss.forge.addon.facets.FacetFactory;
import org.jboss.forge.addon.facets.FacetNotFoundException;
import org.jboss.forge.addon.facets.Faceted;
import org.jboss.forge.addon.facets.MutableFacet;
import org.jboss.forge.addon.facets.MutableFaceted;
import org.jboss.forge.addon.facets.constraints.FacetInspector;
import org.jboss.forge.addon.facets.constraints.RequiresFacet;
import org.jboss.forge.furnace.addons.AddonRegistry;
import org.jboss.forge.furnace.services.Imported;
import org.jboss.forge.furnace.util.Assert;

public class FacetFactoryImpl
implements FacetFactory {
    @Inject
    private AddonRegistry registry;

    public <FACETEDTYPE extends Faceted<?>, FACETTYPE extends Facet<FACETEDTYPE>> FACETTYPE create(FACETEDTYPE origin, Class<FACETTYPE> type) {
        FACETTYPE instance = this.create(type);
        if (!(instance instanceof MutableFacet)) {
            throw new IllegalArgumentException("Facet type [" + type.getName() + "] does not support setting an origin.");
        }
        ((MutableFacet)instance).setFaceted(origin);
        return instance;
    }

    private <FACETEDTYPE extends Faceted<?>, FACETTYPE extends Facet<FACETEDTYPE>> FACETTYPE create(Class<FACETTYPE> type) {
        Assert.notNull(type, (String)"Facet type must not be null.");
        Imported instance = this.registry.getServices(type);
        if (!instance.isSatisfied() && !instance.isAmbiguous()) {
            throw new FacetNotFoundException("Could not find Facet of type [" + type.getName() + "]");
        }
        return (FACETTYPE)((Facet)instance.get());
    }

    public <FACETEDTYPE extends Faceted<?>, FACETTYPE extends Facet<FACETEDTYPE>> Iterable<FACETTYPE> createFacets(FACETEDTYPE origin, Class<FACETTYPE> type) {
        Iterable<FACETTYPE> facets = this.createFacets(type);
        for (Facet facet : facets) {
            if (facet instanceof MutableFacet) {
                ((MutableFacet)facet).setFaceted(origin);
                continue;
            }
            throw new IllegalArgumentException("Facet type [" + type.getName() + "] does not support setting an origin.");
        }
        return facets;
    }

    private <FACETEDTYPE extends Faceted<?>, FACETTYPE extends Facet<FACETEDTYPE>> Iterable<FACETTYPE> createFacets(Class<FACETTYPE> type) {
        Assert.notNull(type, (String)"Facet type must not be null.");
        Imported instances = this.registry.getServices(type);
        HashSet<Facet> facets = new HashSet<Facet>();
        for (Facet instance : instances) {
            facets.add(instance);
        }
        return facets;
    }

    public <FACETEDTYPE extends Faceted<?>, FACETTYPE extends Facet<FACETEDTYPE>> FACETTYPE install(FACETEDTYPE origin, Class<FACETTYPE> type) throws FacetNotFoundException {
        FACETTYPE facet = this.create(origin, type);
        if (!this.install(origin, facet)) {
            throw new IllegalStateException("Facet type [" + type.getName() + "] could not be installed into [" + origin + "] of type [" + origin.getClass().getName() + "]. You may wish to check for inconsistent origin state as partial installation may have occurred.");
        }
        return facet;
    }

    public <FACETEDTYPE extends Faceted<?>, FACETTYPE extends Facet<FACETEDTYPE>> boolean install(FACETEDTYPE origin, FACETTYPE facet) {
        Assert.notNull(origin, (String)"Origin instance must not be null.");
        Assert.notNull(facet, (String)"Facet instance must not be null.");
        LinkedHashSet<Class<FACETTYPE>> seen = new LinkedHashSet<Class<FACETTYPE>>();
        return this.install(seen, origin, facet);
    }

    private <FACETEDTYPE extends Faceted<?>, FACETTYPE extends Facet<FACETEDTYPE>> boolean install(Set<Class<FACETTYPE>> seen, FACETEDTYPE origin, FACETTYPE facet) {
        if (FacetInspector.hasCircularConstraints(facet.getClass())) {
            throw new IllegalStateException("Circular dependencies detected in @" + RequiresFacet.class.getSimpleName() + " annotation located at [" + facet.getClass().getName() + "]");
        }
        seen.add(facet.getClass());
        FACETEDTYPE faceted = origin;
        Assert.isTrue((boolean)(faceted instanceof MutableFaceted), (String)("The given origin [" + origin + "] is not an instance of [" + MutableFaceted.class.getName() + "], and does not support " + Facet.class.getSimpleName() + " installation."));
        if (facet.getFaceted() == null && facet instanceof MutableFacet) {
            ((MutableFacet)facet).setFaceted(origin);
        }
        Assert.isTrue((boolean)origin.equals(facet.getFaceted()), (String)("The given origin [" + origin + "] is not an instance of [" + MutableFaceted.class.getName() + "], and does not support " + Facet.class.getSimpleName() + " installation."));
        Set requiredFacets = FacetInspector.getRequiredFacets(facet.getClass());
        ArrayList<Class> facetsToInstall = new ArrayList<Class>();
        for (Class requirementType : requiredFacets) {
            boolean isSeen = false;
            for (Class<FACETTYPE> seenType : seen) {
                if (!requirementType.isAssignableFrom(seenType)) continue;
                isSeen = true;
                break;
            }
            if (isSeen || origin.hasFacet(requirementType)) continue;
            facetsToInstall.add(requirementType);
        }
        for (Class requirementType : facetsToInstall) {
            FACETTYPE requirement = this.create(origin, requirementType);
            this.install(seen, origin, requirement);
        }
        boolean result = false;
        if (faceted.hasFacet(facet.getClass())) {
            result = true;
        } else if (FacetInspector.isConstraintSatisfied(faceted, (Set)requiredFacets)) {
            result = ((MutableFaceted)faceted).install(facet);
        }
        return result;
    }

    public <FACETEDTYPE extends Faceted<?>, FACETTYPE extends Facet<FACETEDTYPE>> FACETTYPE register(FACETEDTYPE origin, Class<FACETTYPE> type) throws FacetNotFoundException {
        FACETTYPE facet = this.create(origin, type);
        if (!this.register(origin, facet)) {
            throw new IllegalStateException("Facet type [" + type.getName() + "] could not be registered into [" + origin + "] of type [" + origin.getClass().getName() + "].");
        }
        return facet;
    }

    public <FACETEDTYPE extends Faceted<?>, FACETTYPE extends Facet<FACETEDTYPE>> boolean register(FACETEDTYPE origin, FACETTYPE facet) throws IllegalArgumentException {
        Assert.notNull(origin, (String)"Origin instance must not be null.");
        Assert.notNull(facet, (String)"Facet instance must not be null.");
        LinkedHashSet<Class<FACETTYPE>> seen = new LinkedHashSet<Class<FACETTYPE>>();
        return this.register(seen, origin, facet);
    }

    private <FACETEDTYPE extends Faceted<?>, FACETTYPE extends Facet<FACETEDTYPE>> boolean register(Set<Class<FACETTYPE>> seen, FACETEDTYPE origin, FACETTYPE facet) {
        if (FacetInspector.hasCircularConstraints(facet.getClass())) {
            throw new IllegalStateException("Circular dependencies detected in @" + RequiresFacet.class.getSimpleName() + " annotation located at [" + facet.getClass().getName() + "]");
        }
        seen.add(facet.getClass());
        FACETEDTYPE faceted = origin;
        Assert.isTrue((boolean)(faceted instanceof MutableFaceted), (String)("The given origin [" + origin + "] is not an instance of [" + MutableFaceted.class.getName() + "], and does not support " + Facet.class.getSimpleName() + " installation."));
        if (facet.getFaceted() == null && facet instanceof MutableFacet) {
            ((MutableFacet)facet).setFaceted(origin);
        }
        Assert.isTrue((boolean)origin.equals(facet.getFaceted()), (String)("The given origin [" + origin + "] is not an instance of [" + MutableFaceted.class.getName() + "], and does not support " + Facet.class.getSimpleName() + " installation."));
        Set requiredFacets = FacetInspector.getRequiredFacets(facet.getClass());
        ArrayList<Class> facetsToInstall = new ArrayList<Class>();
        for (Class requirementType : requiredFacets) {
            boolean isSeen = false;
            for (Class<FACETTYPE> seenType : seen) {
                if (!requirementType.isAssignableFrom(seenType)) continue;
                isSeen = true;
                break;
            }
            if (isSeen || origin.hasFacet(requirementType)) continue;
            facetsToInstall.add(requirementType);
        }
        for (Class requirementType : facetsToInstall) {
            FACETTYPE requirement = this.create(origin, requirementType);
            this.register(seen, origin, requirement);
        }
        boolean result = false;
        if (faceted.hasFacet(facet.getClass())) {
            result = true;
        } else if (FacetInspector.isConstraintSatisfied(faceted, (Set)requiredFacets)) {
            result = ((MutableFaceted)faceted).register(facet);
        }
        return result;
    }
}

