/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.gradle.projects;

import com.google.common.base.Strings;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.gradle.jarjar.com.google.common.collect.Maps;
import org.jboss.forge.addon.configuration.Configuration;
import org.jboss.forge.addon.facets.AbstractFacet;
import org.jboss.forge.addon.gradle.parser.GradleSourceUtil;
import org.jboss.forge.addon.gradle.projects.GradleFacet;
import org.jboss.forge.addon.gradle.projects.GradleManager;
import org.jboss.forge.addon.gradle.projects.model.GradleModel;
import org.jboss.forge.addon.gradle.projects.model.GradleModelLoadUtil;
import org.jboss.forge.addon.gradle.projects.model.GradleModelMergeUtil;
import org.jboss.forge.addon.gradle.projects.model.GradleProfile;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.resource.FileResource;
import org.jboss.forge.addon.resource.Resource;
import org.jboss.forge.addon.resource.ResourceFactory;
import org.jboss.forge.addon.resource.ResourceFilter;
import org.jboss.forge.addon.resource.WriteableResource;
import org.jboss.forge.furnace.util.OperatingSystemUtils;

public class GradleFacetImpl
extends AbstractFacet<Project>
implements GradleFacet {
    private static final String INITIAL_BUILD_FILE_CONTENTS = "apply plugin: 'java'\nrepositories {\n    mavenCentral()\n}\n";
    private static final String FORGE_LIBRARY_LOCATION_CONF_KEY = "forgeLibraryLocation";
    @Inject
    private GradleManager manager;
    @Inject
    private ResourceFactory resourceFactory;
    @Inject
    private Configuration configuration;
    private GradleModel model;
    private Map<String, GradleModel> profileModels;

    public boolean install() {
        if (!this.isInstalled()) {
            if (!this.getBuildScriptResource().exists()) {
                this.getBuildScriptResource().createNewFile();
                this.getBuildScriptResource().setContents(INITIAL_BUILD_FILE_CONTENTS);
            }
            if (!this.getSettingsScriptResource().exists()) {
                this.getSettingsScriptResource().createNewFile();
            }
        }
        return this.isInstalled();
    }

    public boolean isInstalled() {
        return this.getBuildScriptResource().exists();
    }

    public boolean executeTask(String task) {
        return this.executeTask(task, "", new String[0]);
    }

    public boolean executeTask(String task, String profile, String ... arguments) {
        return this.manager.runGradleBuild(((Project)this.getFaceted()).getRoot().getFullyQualifiedName(), task, profile, arguments);
    }

    public GradleModel getModel() {
        if (this.model != null) {
            return this.model;
        }
        this.loadModel();
        return this.model;
    }

    public void setModel(GradleModel newModel) {
        String oldSource = this.getBuildScriptResource().getContents();
        String newSource = GradleModelMergeUtil.merge((String)oldSource, (GradleModel)this.model, (GradleModel)newModel);
        this.getBuildScriptResource().setContents(newSource);
        if (!this.model.getName().equals(newModel.getName())) {
            String settingsScript = this.getSettingsScriptResource().getContents();
            settingsScript = GradleSourceUtil.setProjectName((String)settingsScript, (String)this.model.getProjectPath(), (String)newModel.getName());
            this.getSettingsScriptResource().setContents(settingsScript);
        }
        for (GradleProfile profile : newModel.getProfiles()) {
            String oldProfileSource;
            String newProfileSource;
            FileResource<?> profileScriptResource = this.getProfileScriptResource(profile.getName());
            if (!profileScriptResource.exists()) {
                profileScriptResource.createNewFile();
            }
            if ((newProfileSource = GradleModelMergeUtil.merge((String)(oldProfileSource = profileScriptResource.getContents()), (GradleModel)this.profileModels.get(profile.getName()), (GradleModel)profile.getModel())).equals(oldProfileSource)) continue;
            profileScriptResource.setContents(newProfileSource);
        }
        for (Resource resource : ((Project)this.getFaceted()).getRoot().listResources(new ResourceFilter(){

            public boolean accept(Resource<?> resource) {
                return resource.getName().endsWith("-profile.gradle");
            }
        })) {
            boolean hasProfile = false;
            String profileName = resource.getName().substring(0, resource.getName().lastIndexOf("-"));
            for (GradleProfile profile : newModel.getProfiles()) {
                if (!profile.getName().equals(profileName)) continue;
                hasProfile = true;
                break;
            }
            if (hasProfile) continue;
            resource.delete();
        }
        this.model = null;
    }

    public FileResource<?> getBuildScriptResource() {
        return (FileResource)((Project)this.getFaceted()).getRoot().getChild("build.gradle");
    }

    public FileResource<?> getSettingsScriptResource() {
        return (FileResource)this.resourceFactory.create(FileResource.class, (Object)new File(this.getModel().getRootProjectPath(), "settings.gradle"));
    }

    public void installForgeLibrary() {
        String newScript;
        String script;
        if (!this.isForgeLibraryInstalled() && !(script = this.getBuildScriptResource().getContents()).equals(newScript = GradleSourceUtil.checkForIncludeForgeLibraryAndInstall((String)script))) {
            this.getBuildScriptResource().setContents(newScript);
            this.installForgeLibrary(((Project)this.getFaceted()).getRoot());
        }
    }

    public boolean isForgeLibraryInstalled() {
        return this.isProjectForgeLibraryInstalled();
    }

    private void loadModel() {
        if (this.isProjectForgeLibraryInstalled()) {
            this.runGradleNormally();
        } else {
            if (!this.isTemporaryForgeLibraryInstalled()) {
                this.nonIntrusiveForgeLibraryInstall();
            }
            this.runGradleInNonIntrusiveMode();
        }
        String forgeOutput = this.readForgeOutputAndClean();
        String script = this.getBuildScriptResource().getContents();
        Map<String, String> profileScripts = this.getProfileScripts();
        GradleModel loadedModel = GradleModelLoadUtil.load((String)script, profileScripts, (String)forgeOutput);
        this.profileModels = Maps.newHashMap();
        for (GradleProfile profile : loadedModel.getProfiles()) {
            this.profileModels.put(profile.getName(), profile.getModel());
        }
        this.model = loadedModel;
    }

    private FileResource<?> getProfileScriptResource(String name) {
        return (FileResource)this.getBuildScriptResource().getParent().getChild(name + "-profile.gradle");
    }

    private Map<String, String> getProfileScripts() {
        HashMap profileScripts = Maps.newHashMap();
        for (Resource resource : this.getBuildScriptResource().getParent().listResources()) {
            FileResource file = (FileResource)resource;
            if (!file.getName().endsWith("-profile.gradle")) continue;
            String profile = file.getName().substring(0, file.getName().length() - "-profile.gradle".length());
            profileScripts.put(profile, file.getContents());
        }
        return profileScripts;
    }

    private String readForgeOutputAndClean() {
        Resource forgeOutputFile = ((Project)this.getFaceted()).getRoot().getChild("forge-output.xml");
        String forgeOutput = forgeOutputFile.getContents();
        forgeOutputFile.delete();
        return forgeOutput;
    }

    private boolean isProjectForgeLibraryInstalled() {
        return ((Project)this.getFaceted()).getRoot().getChild("forge.gradle").exists() && GradleSourceUtil.checkForIncludeForgeLibrary((String)this.getBuildScriptResource().getContents());
    }

    private boolean isTemporaryForgeLibraryInstalled() {
        String libLocation = this.configuration.getString(FORGE_LIBRARY_LOCATION_CONF_KEY);
        return !Strings.isNullOrEmpty((String)libLocation) && this.resourceFactory.getFileOperations().fileExists(new File(libLocation));
    }

    private Resource<?> installForgeLibrary(Resource<?> resource) {
        WriteableResource forgeLib = (WriteableResource)resource.getChild("forge.gradle");
        forgeLib.setContents(((Object)((Object)this)).getClass().getResourceAsStream("/forge.gradle"));
        return forgeLib;
    }

    private void nonIntrusiveForgeLibraryInstall() {
        File temporaryDir = OperatingSystemUtils.createTempDir();
        Resource<?> forgeLib = this.installForgeLibrary(this.resourceFactory.create((Object)temporaryDir));
        this.configuration.setProperty(FORGE_LIBRARY_LOCATION_CONF_KEY, (Object)forgeLib.getFullyQualifiedName());
    }

    private void runGradleNormally() {
        this.manager.runGradleBuild(((Project)this.getFaceted()).getRoot().getFullyQualifiedName(), "forgeOutput", "", new String[0]);
    }

    private void runGradleInNonIntrusiveMode() {
        this.manager.runGradleBuild(((Project)this.getFaceted()).getRoot().getFullyQualifiedName(), "forgeOutput", "", new String[]{"-I", this.configuration.getString(FORGE_LIBRARY_LOCATION_CONF_KEY)});
    }
}

