/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.gradle.projects;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.jboss.forge.addon.facets.FacetFactory;
import org.jboss.forge.addon.facets.Faceted;
import org.jboss.forge.addon.gradle.projects.GradleFacet;
import org.jboss.forge.addon.gradle.projects.GradleFacetImpl;
import org.jboss.forge.addon.gradle.projects.GradleProject;
import org.jboss.forge.addon.gradle.projects.GradleProjectProvider;
import org.jboss.forge.addon.gradle.projects.facets.GradleDependencyFacet;
import org.jboss.forge.addon.gradle.projects.facets.GradleJavaCompilerFacet;
import org.jboss.forge.addon.gradle.projects.facets.GradleJavaSourceFacet;
import org.jboss.forge.addon.gradle.projects.facets.GradleMetadataFacet;
import org.jboss.forge.addon.gradle.projects.facets.GradlePackagingFacet;
import org.jboss.forge.addon.gradle.projects.facets.GradleResourcesFacet;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.ProvidedProjectFacet;
import org.jboss.forge.addon.projects.facets.DependencyFacet;
import org.jboss.forge.addon.projects.facets.MetadataFacet;
import org.jboss.forge.addon.projects.facets.PackagingFacet;
import org.jboss.forge.addon.resource.Resource;

public class GradleProjectProviderImpl
implements GradleProjectProvider {
    @Inject
    private FacetFactory facetFactory;

    public String getType() {
        return "Gradle";
    }

    public Project createProject(Resource<?> targetDir) {
        GradleProject project = new GradleProject(targetDir);
        this.facetFactory.install((Faceted)project, GradleFacetImpl.class);
        this.facetFactory.install((Faceted)project, GradleMetadataFacet.class);
        this.facetFactory.install((Faceted)project, GradlePackagingFacet.class);
        this.facetFactory.install((Faceted)project, GradleDependencyFacet.class);
        this.facetFactory.install((Faceted)project, GradleResourcesFacet.class);
        this.facetFactory.install((Faceted)project, GradleJavaCompilerFacet.class);
        this.facetFactory.install((Faceted)project, GradleJavaSourceFacet.class);
        return project;
    }

    public boolean containsProject(Resource<?> resource) {
        Resource buildGradle = resource.getChild("build.gradle");
        return buildGradle != null && buildGradle.exists();
    }

    public Set<Class<? extends ProvidedProjectFacet>> getProvidedFacetTypes() {
        HashSet<Class> result = new HashSet<Class>();
        result.add(GradleFacet.class);
        result.add(MetadataFacet.class);
        result.add(DependencyFacet.class);
        result.add(PackagingFacet.class);
        return Collections.unmodifiableSet(result);
    }

    private void addSafe(Set<Class<? extends ProvidedProjectFacet>> result, Callable<Class<? extends ProvidedProjectFacet>> callable) {
        try {
            Class<? extends ProvidedProjectFacet> facetType = callable.call();
            if (facetType != null) {
                result.add(facetType);
            }
        }
        catch (NoClassDefFoundError e) {
        }
        catch (ClassNotFoundException e) {
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public int priority() {
        return 100;
    }
}

