/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.gradle.projects.facets;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.jarjar.com.google.common.collect.Lists;
import org.gradle.jarjar.com.google.common.collect.Sets;
import org.jboss.forge.addon.dependencies.Coordinate;
import org.jboss.forge.addon.dependencies.Dependency;
import org.jboss.forge.addon.dependencies.DependencyQuery;
import org.jboss.forge.addon.dependencies.DependencyRepository;
import org.jboss.forge.addon.dependencies.DependencyResolver;
import org.jboss.forge.addon.dependencies.builder.CoordinateBuilder;
import org.jboss.forge.addon.dependencies.builder.DependencyBuilder;
import org.jboss.forge.addon.dependencies.builder.DependencyQueryBuilder;
import org.jboss.forge.addon.dependencies.util.NonSnapshotDependencyFilter;
import org.jboss.forge.addon.facets.AbstractFacet;
import org.jboss.forge.addon.facets.constraints.FacetConstraint;
import org.jboss.forge.addon.facets.constraints.FacetConstraints;
import org.jboss.forge.addon.gradle.projects.GradleFacet;
import org.jboss.forge.addon.gradle.projects.model.GradleDependency;
import org.jboss.forge.addon.gradle.projects.model.GradleDependencyBuilder;
import org.jboss.forge.addon.gradle.projects.model.GradleDependencyConfiguration;
import org.jboss.forge.addon.gradle.projects.model.GradleModel;
import org.jboss.forge.addon.gradle.projects.model.GradleModelBuilder;
import org.jboss.forge.addon.gradle.projects.model.GradleRepository;
import org.jboss.forge.addon.gradle.projects.model.GradleRepositoryBuilder;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.facets.DependencyFacet;
import org.jboss.forge.furnace.util.Predicate;
import org.jboss.forge.furnace.util.Strings;

@FacetConstraints(value={@FacetConstraint(value={GradleFacet.class})})
public class GradleDependencyFacet
extends AbstractFacet<Project>
implements DependencyFacet {
    @Inject
    private DependencyResolver dependencyResolver;

    public boolean install() {
        return true;
    }

    public boolean isInstalled() {
        return ((Project)this.getFaceted()).hasFacet(GradleFacet.class);
    }

    public void addDirectDependency(Dependency dep) {
        GradleModelBuilder model = GradleModelBuilder.create((GradleModel)this.getGradleFacet().getModel());
        Dependency newDep = null;
        if (dep.getCoordinate().getVersion() == null && this.resolveVersionIn(this.getEffectiveManagedDependencies(), dep) == null) {
            newDep = this.resolveVersionIn(this.getEffectiveImports(), dep);
        }
        if (newDep == null) {
            newDep = dep;
        }
        model.addDependency(this.forgeDepToGradleDep(newDep));
        this.getGradleFacet().setModel((GradleModel)model);
    }

    public void addManagedDependency(Dependency dep) {
        if (!this.hasEffectiveDependency(dep)) {
            this.addDirectManagedDependency(dep);
        }
    }

    public void addDirectManagedDependency(Dependency dep) {
        this.getGradleFacet().installForgeLibrary();
        GradleModelBuilder model = GradleModelBuilder.create((GradleModel)this.getGradleFacet().getModel());
        Dependency newDep = null;
        newDep = this.resolveVersionIn(this.getEffectiveImports(), dep);
        if (newDep == null) {
            newDep = dep;
        }
        model.addManagedDependency(this.forgeDepToGradleDep(newDep));
        if (this.listContainsDep(this.gradleDepsToForgeDeps(model.getDependencies()), newDep)) {
            model.removeDependency(this.forgeDepToGradleDep(newDep));
            model.addDependency(this.forgeDepToGradleDep((Dependency)DependencyBuilder.create((Dependency)newDep).setVersion(null)));
        }
        this.getGradleFacet().setModel((GradleModel)model);
    }

    public void addRepository(String name, String url) {
        GradleModelBuilder model = GradleModelBuilder.create((GradleModel)this.getGradleFacet().getModel());
        model.addRepository((GradleRepository)GradleRepositoryBuilder.create().setName(name).setUrl(url));
        this.getGradleFacet().setModel((GradleModel)model);
    }

    public List<Dependency> getDependencies() {
        return this.gradleDepsToForgeDeps(this.getGradleFacet().getModel().getDependencies());
    }

    public List<Dependency> getDependenciesInScopes(String ... scopes) {
        return this.filterDependenciesFromScopes(this.getDependencies(), scopes);
    }

    public Dependency getDirectDependency(Dependency dependency) {
        return this.findDependency(this.getDependencies(), dependency);
    }

    public List<Dependency> getEffectiveDependencies() {
        return this.resolveDependencies(this.getEvaluatedDependencies(), false);
    }

    public List<Dependency> getEffectiveDependenciesInScopes(String ... scopes) {
        return this.filterDependenciesFromScopes(this.getEffectiveDependencies(), scopes);
    }

    public Dependency getEffectiveDependency(Dependency dependency) {
        return this.findDependency(this.getEffectiveDependencies(), dependency);
    }

    public Dependency getEffectiveManagedDependency(Dependency dependency) {
        return this.findDependency(this.getEffectiveManagedDependencies(), dependency);
    }

    public List<Dependency> getManagedDependencies() {
        return this.gradleDepsToForgeDeps(this.getGradleFacet().getModel().getManagedDependencies());
    }

    public Dependency getDirectManagedDependency(Dependency dependency) {
        return this.findDependency(this.getManagedDependencies(), dependency);
    }

    public List<DependencyRepository> getRepositories() {
        ArrayList repos = Lists.newArrayList();
        for (GradleRepository gradleRepo : this.getGradleFacet().getModel().getEffectiveRepositories()) {
            repos.add(new DependencyRepository(gradleRepo.getName(), gradleRepo.getUrl()));
        }
        return repos;
    }

    public boolean hasDirectDependency(Dependency dependency) {
        return this.listContainsDep(this.getDependencies(), dependency);
    }

    public boolean hasEffectiveDependency(Dependency dependency) {
        return this.listContainsDep(this.getEffectiveDependencies(), dependency);
    }

    public boolean hasEffectiveManagedDependency(Dependency managedDependency) {
        return this.listContainsDep(this.getEffectiveManagedDependencies(), managedDependency);
    }

    public boolean hasDirectManagedDependency(Dependency managedDependency) {
        return this.listContainsDep(this.getManagedDependencies(), managedDependency);
    }

    public boolean hasRepository(String url) {
        for (DependencyRepository repo : this.getRepositories()) {
            if (!repo.getUrl().equals(url)) continue;
            return true;
        }
        return false;
    }

    public void removeDependency(Dependency dependency) {
        GradleModelBuilder model = GradleModelBuilder.create((GradleModel)this.getGradleFacet().getModel());
        model.removeDependency(this.forgeDepToGradleDep(dependency));
        this.getGradleFacet().setModel((GradleModel)model);
    }

    public void removeManagedDependency(Dependency managedDependency) {
        GradleModelBuilder model = GradleModelBuilder.create((GradleModel)this.getGradleFacet().getModel());
        model.removeManagedDependency(this.forgeDepToGradleDep(managedDependency));
        this.getGradleFacet().setModel((GradleModel)model);
    }

    public DependencyRepository removeRepository(String url) {
        DependencyRepository repo = null;
        GradleModelBuilder model = GradleModelBuilder.create((GradleModel)this.getGradleFacet().getModel());
        repo = this.findRepositoryByUrl(this.getRepositories(), url);
        model.removeRepository((GradleRepository)GradleRepositoryBuilder.create().setUrl(url));
        this.getGradleFacet().setModel((GradleModel)model);
        return repo;
    }

    public List<Coordinate> resolveAvailableVersions(Dependency dep) {
        DependencyQueryBuilder query = DependencyQueryBuilder.create((Coordinate)dep.getCoordinate()).setRepositories(this.getRepositories());
        if (dep.getCoordinate().getVersion() != null && !dep.getCoordinate().getVersion().contains("SNAPSHOT")) {
            query.setFilter((Predicate)new NonSnapshotDependencyFilter());
        }
        List versions = this.dependencyResolver.resolveVersions((DependencyQuery)query);
        return versions;
    }

    public List<Coordinate> resolveAvailableVersions(String gavs) {
        return this.resolveAvailableVersions((Dependency)DependencyBuilder.create((String)gavs));
    }

    public List<Coordinate> resolveAvailableVersions(DependencyQuery query) {
        query = DependencyQueryBuilder.create((DependencyQuery)query).setRepositories(this.getRepositories());
        List versions = this.dependencyResolver.resolveVersions(query);
        return versions;
    }

    public Dependency resolveProperties(Dependency dependency) {
        GradleModel model = this.getGradleFacet().getModel();
        Map props = model.getEffectiveProperties();
        DependencyBuilder builder = DependencyBuilder.create((Dependency)dependency);
        builder.setGroupId(this.resolveProperties(props, dependency.getCoordinate().getGroupId()));
        builder.setArtifactId(this.resolveProperties(props, dependency.getCoordinate().getArtifactId()));
        builder.setVersion(this.resolveProperties(props, dependency.getCoordinate().getVersion()));
        builder.setClassifier(this.resolveProperties(props, dependency.getCoordinate().getClassifier()));
        builder.setPackaging(this.resolveProperties(props, dependency.getCoordinate().getPackaging()));
        builder.setScopeType(this.resolveProperties(props, dependency.getScopeType()));
        return builder;
    }

    private Dependency resolveVersionIn(List<Dependency> list, Dependency dep) {
        for (Dependency importedDep : list) {
            if (!dep.getCoordinate().getGroupId().equals(importedDep.getCoordinate().getGroupId()) || !dep.getCoordinate().getArtifactId().equals(importedDep.getCoordinate().getArtifactId())) continue;
            return DependencyBuilder.create((Dependency)dep).setVersion(importedDep.getCoordinate().getVersion());
        }
        return null;
    }

    private List<Dependency> getEffectiveImports() {
        return this.resolveDependencies(this.filterDependenciesFromScopes(this.getEvaluatedManagedDependencies(), "import"), true);
    }

    private List<Dependency> resolveDependencies(List<Dependency> deps, boolean resolveImported) {
        HashMap<String, Dependency> depByString = new HashMap<String, Dependency>();
        for (Dependency dep : deps) {
            depByString.put(dep.toString(), dep);
            if (!resolveImported && dep.getScopeType().equals("import")) continue;
            try {
                Set depDeps = this.dependencyResolver.resolveDependencies((DependencyQuery)DependencyQueryBuilder.create((Coordinate)dep.getCoordinate()).setRepositories(this.getRepositories()));
                for (Dependency depDep : depDeps) {
                    String depDepString = depDep.toString();
                    if (depByString.containsKey(depDepString)) continue;
                    depByString.put(depDepString, depDep);
                }
            }
            catch (RuntimeException ex) {
            }
        }
        return new ArrayList<Dependency>(depByString.values());
    }

    public List<Dependency> getEffectiveManagedDependencies() {
        return this.resolveDependencies(this.getEvaluatedManagedDependencies(), false);
    }

    public List<Dependency> getEvaluatedDependencies() {
        return this.gradleDepsToForgeDeps(this.getGradleFacet().getModel().getEffectiveDependencies());
    }

    public List<Dependency> getEvaluatedManagedDependencies() {
        return this.gradleDepsToForgeDeps(this.getGradleFacet().getModel().getEffectiveManagedDependencies());
    }

    private List<Dependency> gradleDepsToForgeDeps(List<GradleDependency> gradleDeps) {
        ArrayList deps = Lists.newArrayList();
        for (GradleDependency gradleDep : gradleDeps) {
            deps.add(this.gradleDepToForgeDep(gradleDep));
        }
        return deps;
    }

    private Dependency gradleDepToForgeDep(GradleDependency gradleDep) {
        DependencyBuilder forgeDep = DependencyBuilder.create().setScopeType(gradleDep.getConfiguration().toMavenScope()).setGroupId(gradleDep.getGroup()).setArtifactId(gradleDep.getName()).setVersion(gradleDep.getVersion()).setClassifier(gradleDep.getClassifier()).setPackaging(gradleDep.getPackaging()).setExcludedCoordinates(this.gradleExclusionsToForge(gradleDep.getExcludedDependencies()));
        return forgeDep;
    }

    private List<Coordinate> gradleExclusionsToForge(List<GradleDependency> exclusions) {
        ArrayList list = Lists.newArrayList();
        for (GradleDependency dep : exclusions) {
            list.add(CoordinateBuilder.create().setGroupId(dep.getGroup()).setArtifactId(dep.getName()));
        }
        return list;
    }

    private GradleDependency forgeDepToGradleDep(Dependency forgeDep) {
        return GradleDependencyBuilder.create().setConfigurationName(GradleDependencyConfiguration.fromMavenScope((String)forgeDep.getScopeType()).getName()).setGroup(forgeDep.getCoordinate().getGroupId()).setName(forgeDep.getCoordinate().getArtifactId()).setVersion(forgeDep.getCoordinate().getVersion()).setClassifier(forgeDep.getCoordinate().getClassifier()).setPackaging(forgeDep.getCoordinate().getPackaging()).setExcludedDependencies(this.forgeExclusionsToGradle(forgeDep.getExcludedCoordinates()));
    }

    private List<GradleDependency> forgeExclusionsToGradle(List<Coordinate> exclusions) {
        ArrayList list = Lists.newArrayList();
        if (exclusions == null) {
            return list;
        }
        for (Coordinate coord : exclusions) {
            list.add(GradleDependencyBuilder.create().setGroup(coord.getGroupId()).setName(coord.getArtifactId()));
        }
        return list;
    }

    private List<Dependency> filterDependenciesFromScopes(List<Dependency> deps, String ... scopes) {
        ArrayList foundDeps = Lists.newArrayList();
        HashSet scopeSet = Sets.newHashSet((Object[])scopes);
        for (Dependency dep : deps) {
            if (!scopeSet.contains(dep.getScopeType())) continue;
            foundDeps.add(dep);
        }
        return foundDeps;
    }

    private boolean listContainsDep(List<Dependency> deps, Dependency dep) {
        for (Dependency listDep : deps) {
            if (!this.depEquals(listDep, dep)) continue;
            return true;
        }
        return false;
    }

    private Dependency findDependency(List<Dependency> deps, Dependency dep) {
        for (Dependency listDep : deps) {
            if (!this.depEquals(listDep, dep)) continue;
            return listDep;
        }
        return null;
    }

    private boolean depEquals(Dependency original, Dependency incoming) {
        return original.getCoordinate().getGroupId().equals(incoming.getCoordinate().getGroupId()) && original.getCoordinate().getArtifactId().equals(incoming.getCoordinate().getArtifactId()) && (Strings.isNullOrEmpty((String)incoming.getCoordinate().getVersion()) || original.getCoordinate().getVersion().equals(incoming.getCoordinate().getVersion()));
    }

    private DependencyRepository findRepositoryByUrl(List<DependencyRepository> list, String url) {
        for (DependencyRepository repo : list) {
            if (!repo.getUrl().equals(url)) continue;
            return repo;
        }
        return null;
    }

    private String resolveProperties(Map<String, String> properties, String value) {
        if (value != null) {
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                value = value.replaceAll("\\$ext\\." + entry.getKey(), entry.getValue());
                value = value.replaceAll("\\$\\{ext\\." + entry.getKey() + "\\}", entry.getValue());
            }
        }
        return value;
    }

    private GradleFacet getGradleFacet() {
        return (GradleFacet)((Project)this.getFaceted()).getFacet(GradleFacet.class);
    }
}

