/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.gradle.projects.facets;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import org.gradle.jarjar.com.google.common.collect.Lists;
import org.jboss.forge.addon.facets.AbstractFacet;
import org.jboss.forge.addon.facets.constraints.FacetConstraint;
import org.jboss.forge.addon.facets.constraints.FacetConstraints;
import org.jboss.forge.addon.gradle.projects.GradleFacet;
import org.jboss.forge.addon.gradle.projects.facets.GradleResourceUtil;
import org.jboss.forge.addon.gradle.projects.facets.Packages;
import org.jboss.forge.addon.gradle.projects.model.GradleModel;
import org.jboss.forge.addon.gradle.projects.model.GradleSourceDirectory;
import org.jboss.forge.addon.gradle.projects.model.GradleSourceSet;
import org.jboss.forge.addon.parser.java.facets.JavaSourceFacet;
import org.jboss.forge.addon.parser.java.resources.JavaResource;
import org.jboss.forge.addon.parser.java.resources.JavaResourceVisitor;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.resource.DirectoryResource;
import org.jboss.forge.addon.resource.Resource;
import org.jboss.forge.addon.resource.ResourceFilter;
import org.jboss.forge.addon.resource.visit.ResourceVisit;
import org.jboss.forge.addon.resource.visit.ResourceVisitor;
import org.jboss.forge.furnace.util.Strings;
import org.jboss.forge.parser.java.JavaSource;

@FacetConstraints(value={@FacetConstraint(value={GradleFacet.class})})
public class GradleJavaSourceFacet
extends AbstractFacet<Project>
implements JavaSourceFacet {
    public boolean install() {
        if (!this.isInstalled()) {
            for (DirectoryResource folder : this.getSourceDirectories()) {
                folder.mkdirs();
            }
        }
        return this.isInstalled();
    }

    public boolean isInstalled() {
        return this.getSourceDirectory().exists();
    }

    public String calculateName(JavaResource resource) {
        String fullPath = Packages.fromFileSyntax(resource.getFullyQualifiedName());
        String pkg = this.calculatePackage(resource);
        String name = fullPath.substring(fullPath.lastIndexOf(pkg) + pkg.length() + 1);
        name = name.substring(0, name.lastIndexOf(".java"));
        return name;
    }

    public String calculatePackage(JavaResource resource) {
        List<DirectoryResource> folders = this.getSourceDirectories();
        String pkg = null;
        for (DirectoryResource folder : folders) {
            String sourcePrefix = folder.getFullyQualifiedName();
            pkg = resource.getParent().getFullyQualifiedName();
            if (!pkg.startsWith(sourcePrefix)) continue;
            pkg = pkg.substring(sourcePrefix.length() + 1);
            break;
        }
        pkg = Packages.fromFileSyntax(pkg);
        return pkg;
    }

    public String getBasePackage() {
        return Packages.toValidPackageName(((GradleFacet)((Project)this.getFaceted()).getFacet(GradleFacet.class)).getModel().getGroup());
    }

    public DirectoryResource getBasePackageDirectory() {
        return this.getSourceDirectory().getChildDirectory(Packages.toFileSyntax(this.getBasePackage()));
    }

    public List<DirectoryResource> getSourceDirectories() {
        ArrayList resources = Lists.newArrayList();
        GradleModel model = ((GradleFacet)((Project)this.getFaceted()).getFacet(GradleFacet.class)).getModel();
        for (GradleSourceSet sourceSet : model.getEffectiveSourceSets()) {
            for (GradleSourceDirectory sourceDir : sourceSet.getJavaDirectories()) {
                resources.add(this.directoryResourceFromRelativePath(sourceDir.getPath()));
            }
        }
        return resources;
    }

    public DirectoryResource getSourceDirectory() {
        GradleModel model = ((GradleFacet)((Project)this.getFaceted()).getFacet(GradleFacet.class)).getModel();
        GradleSourceDirectory dir = (GradleSourceDirectory)GradleResourceUtil.findSourceSetNamed(model.getEffectiveSourceSets(), "main").getJavaDirectories().get(0);
        return this.directoryResourceFromRelativePath(dir.getPath());
    }

    public DirectoryResource getTestSourceDirectory() {
        GradleModel model = ((GradleFacet)((Project)this.getFaceted()).getFacet(GradleFacet.class)).getModel();
        GradleSourceDirectory dir = (GradleSourceDirectory)GradleResourceUtil.findSourceSetNamed(model.getEffectiveSourceSets(), "test").getJavaDirectories().get(0);
        return this.directoryResourceFromRelativePath(dir.getPath());
    }

    public JavaResource saveJavaSource(JavaSource<?> source) throws FileNotFoundException {
        return this.getJavaResource(Packages.toFileSyntax(source.getQualifiedName()) + ".java").setContents(source);
    }

    public JavaResource saveTestJavaSource(JavaSource<?> source) throws FileNotFoundException {
        return this.getTestJavaResource(Packages.toFileSyntax(source.getQualifiedName()) + ".java").setContents(source);
    }

    public JavaResource getJavaResource(String relativePath) throws FileNotFoundException {
        return (JavaResource)GradleResourceUtil.findFileResource(this.getMainJavaSources(), relativePath).reify(JavaResource.class);
    }

    public JavaResource getJavaResource(JavaSource<?> javaClass) throws FileNotFoundException {
        String pkg = Strings.isNullOrEmpty((String)javaClass.getPackage()) ? "" : javaClass.getPackage() + ".";
        return this.getJavaResource(pkg + javaClass.getName());
    }

    public JavaResource getTestJavaResource(String relativePath) throws FileNotFoundException {
        return (JavaResource)GradleResourceUtil.findFileResource(this.getTestJavaSources(), relativePath).reify(JavaResource.class);
    }

    public JavaResource getTestJavaResource(JavaSource<?> javaClass) throws FileNotFoundException {
        String pkg = Strings.isNullOrEmpty((String)javaClass.getPackage()) ? "" : javaClass.getPackage() + ".";
        return this.getTestJavaResource(pkg + javaClass.getName());
    }

    public void visitJavaSources(JavaResourceVisitor visitor) {
        for (DirectoryResource sourceFolder : this.getMainJavaSources()) {
            this.visitSources((Resource<?>)sourceFolder, visitor);
        }
    }

    public void visitJavaTestSources(JavaResourceVisitor visitor) {
        for (DirectoryResource testSourceFolder : this.getTestJavaSources()) {
            this.visitSources((Resource<?>)testSourceFolder, visitor);
        }
    }

    private void visitSources(Resource<?> searchFolder, JavaResourceVisitor visitor) {
        new ResourceVisit(searchFolder).perform((ResourceVisitor)visitor, new ResourceFilter(){

            public boolean accept(Resource<?> type) {
                return type instanceof DirectoryResource;
            }
        }, new ResourceFilter(){

            public boolean accept(Resource<?> type) {
                return type instanceof JavaResource;
            }
        });
    }

    private List<DirectoryResource> getMainJavaSources() {
        return this.getJavaSourcesFromSourceSet("main");
    }

    private List<DirectoryResource> getTestJavaSources() {
        return this.getJavaSourcesFromSourceSet("test");
    }

    private List<DirectoryResource> getJavaSourcesFromSourceSet(String sourceSetName) {
        ArrayList resources = Lists.newArrayList();
        GradleFacet gradleFacet = (GradleFacet)((Project)this.getFaceted()).getFacet(GradleFacet.class);
        for (GradleSourceDirectory sourceDir : GradleResourceUtil.findSourceSetNamed(gradleFacet.getModel().getEffectiveSourceSets(), sourceSetName).getJavaDirectories()) {
            resources.add(this.directoryResourceFromRelativePath(sourceDir.getPath()));
        }
        return resources;
    }

    private DirectoryResource directoryResourceFromRelativePath(String path) {
        return ((GradleFacet)((Project)this.getFaceted()).getFacet(GradleFacet.class)).getBuildScriptResource().getParent().getChildDirectory(path);
    }
}

