/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.gradle.projects.facets;

import java.io.PrintStream;
import java.util.List;
import org.gradle.jarjar.com.google.common.collect.Lists;
import org.jboss.forge.addon.facets.AbstractFacet;
import org.jboss.forge.addon.facets.constraints.FacetConstraint;
import org.jboss.forge.addon.facets.constraints.FacetConstraints;
import org.jboss.forge.addon.gradle.projects.GradleFacet;
import org.jboss.forge.addon.gradle.projects.model.GradleModel;
import org.jboss.forge.addon.gradle.projects.model.GradleModelBuilder;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.building.BuildException;
import org.jboss.forge.addon.projects.building.ProjectBuilder;
import org.jboss.forge.addon.projects.facets.PackagingFacet;
import org.jboss.forge.addon.resource.Resource;

@FacetConstraints(value={@FacetConstraint(value={GradleFacet.class})})
public class GradlePackagingFacet
extends AbstractFacet<Project>
implements PackagingFacet {
    public boolean install() {
        return true;
    }

    public boolean isInstalled() {
        return true;
    }

    public void setPackagingType(String type) {
        GradleModelBuilder model = GradleModelBuilder.create((GradleModel)this.getGradleFacet().getModel());
        model.setPackaging(type);
        this.getGradleFacet().setModel((GradleModel)model);
    }

    public String getPackagingType() {
        return this.getGradleFacet().getModel().getPackaging();
    }

    public Resource<?> getFinalArtifact() {
        return ((Project)this.getFaceted()).getRoot().getChild(this.getGradleFacet().getModel().getArchivePath());
    }

    public ProjectBuilder createBuilder() {
        return new ProjectBuilder(){
            private List<String> arguments = Lists.newArrayList();
            private boolean runTests = false;

            public ProjectBuilder addArguments(String ... args) {
                for (String arg : args) {
                    this.arguments.add(arg);
                }
                return this;
            }

            public ProjectBuilder runTests(boolean test) {
                this.runTests = test;
                return this;
            }

            public Resource<?> build() throws BuildException {
                if (!this.arguments.contains("build") && !this.arguments.contains("assemble")) {
                    this.arguments.add(this.runTests ? "build" : "assemble");
                }
                GradlePackagingFacet.this.getGradleFacet().executeTask(this.runTests ? "test" : "", "", this.arguments.toArray(new String[this.arguments.size()]));
                return GradlePackagingFacet.this.getFinalArtifact();
            }

            public Resource<?> build(PrintStream out, PrintStream err) throws BuildException {
                return this.build();
            }
        };
    }

    public Resource<?> executeBuild(String ... args) {
        this.getGradleFacet().executeTask("build", "", args);
        return this.getFinalArtifact();
    }

    public String getFinalName() {
        return this.getGradleFacet().getModel().getArchiveName();
    }

    public void setFinalName(String finalName) {
        this.getGradleFacet().installForgeLibrary();
        GradleModelBuilder model = GradleModelBuilder.create((GradleModel)this.getGradleFacet().getModel());
        model.setArchiveName(finalName);
        this.getGradleFacet().setModel((GradleModel)model);
    }

    private GradleFacet getGradleFacet() {
        return (GradleFacet)((Project)this.getFaceted()).getFacet(GradleFacet.class);
    }
}

