/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.gradle.projects.facets;

import java.util.ArrayList;
import java.util.List;
import org.gradle.jarjar.com.google.common.collect.Lists;
import org.jboss.forge.addon.facets.AbstractFacet;
import org.jboss.forge.addon.facets.constraints.FacetConstraint;
import org.jboss.forge.addon.facets.constraints.FacetConstraints;
import org.jboss.forge.addon.gradle.projects.GradleFacet;
import org.jboss.forge.addon.gradle.projects.facets.GradleResourceUtil;
import org.jboss.forge.addon.gradle.projects.model.GradleModel;
import org.jboss.forge.addon.gradle.projects.model.GradleSourceDirectory;
import org.jboss.forge.addon.gradle.projects.model.GradleSourceSet;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.facets.ResourcesFacet;
import org.jboss.forge.addon.resource.DirectoryResource;
import org.jboss.forge.addon.resource.FileResource;
import org.jboss.forge.addon.resource.Resource;
import org.jboss.forge.addon.resource.ResourceFilter;
import org.jboss.forge.addon.resource.visit.ResourceVisit;
import org.jboss.forge.addon.resource.visit.ResourceVisitor;

@FacetConstraints(value={@FacetConstraint(value={GradleFacet.class})})
public class GradleResourcesFacet
extends AbstractFacet<Project>
implements ResourcesFacet {
    public boolean install() {
        return true;
    }

    public boolean isInstalled() {
        return true;
    }

    public List<DirectoryResource> getResourceDirectories() {
        ArrayList resources = Lists.newArrayList();
        GradleModel model = ((GradleFacet)((Project)this.getFaceted()).getFacet(GradleFacet.class)).getModel();
        for (GradleSourceSet sourceSet : model.getEffectiveSourceSets()) {
            for (GradleSourceDirectory sourceDir : sourceSet.getResourceDirectories()) {
                resources.add(this.directoryResourceFromRelativePath(sourceDir.getPath()));
            }
        }
        return resources;
    }

    public DirectoryResource getResourceDirectory() {
        GradleModel model = ((GradleFacet)((Project)this.getFaceted()).getFacet(GradleFacet.class)).getModel();
        GradleSourceDirectory dir = (GradleSourceDirectory)GradleResourceUtil.findSourceSetNamed(model.getEffectiveSourceSets(), "main").getResourceDirectories().get(0);
        return this.directoryResourceFromRelativePath(dir.getPath());
    }

    public DirectoryResource getTestResourceDirectory() {
        GradleModel model = ((GradleFacet)((Project)this.getFaceted()).getFacet(GradleFacet.class)).getModel();
        GradleSourceDirectory dir = (GradleSourceDirectory)GradleResourceUtil.findSourceSetNamed(model.getEffectiveSourceSets(), "test").getResourceDirectories().get(0);
        return this.directoryResourceFromRelativePath(dir.getPath());
    }

    public FileResource<?> createResource(char[] bytes, String relativeFilename) {
        FileResource resource = (FileResource)this.getResourceDirectory().getChild(relativeFilename);
        resource.setContents(bytes);
        return resource;
    }

    public FileResource<?> createTestResource(char[] bytes, String relativeFilename) {
        FileResource resource = (FileResource)this.getTestResourceDirectory().getChild(relativeFilename);
        resource.setContents(bytes);
        return resource;
    }

    public FileResource<?> getResource(String relativePath) {
        return GradleResourceUtil.findFileResource(this.getMainResources(), relativePath);
    }

    public FileResource<?> getTestResource(String relativePath) {
        return GradleResourceUtil.findFileResource(this.getTestResources(), relativePath);
    }

    private List<DirectoryResource> getMainResources() {
        return this.getResourcesFromSourceSet("main");
    }

    private List<DirectoryResource> getTestResources() {
        return this.getResourcesFromSourceSet("test");
    }

    private List<DirectoryResource> getResourcesFromSourceSet(String sourceSetName) {
        ArrayList resources = Lists.newArrayList();
        GradleModel model = ((GradleFacet)((Project)this.getFaceted()).getFacet(GradleFacet.class)).getModel();
        for (GradleSourceDirectory sourceDir : GradleResourceUtil.findSourceSetNamed(model.getEffectiveSourceSets(), sourceSetName).getResourceDirectories()) {
            resources.add(this.directoryResourceFromRelativePath(sourceDir.getPath()));
        }
        return resources;
    }

    private DirectoryResource directoryResourceFromRelativePath(String path) {
        return ((GradleFacet)((Project)this.getFaceted()).getFacet(GradleFacet.class)).getBuildScriptResource().getParent().getChildDirectory(path);
    }

    public void visitResources(ResourceVisitor visitor) {
        new ResourceVisit((Resource)this.getResourceDirectory()).perform(visitor, new ResourceFilter(){

            public boolean accept(Resource<?> resource) {
                return resource instanceof DirectoryResource;
            }
        }, new ResourceFilter(){

            public boolean accept(Resource<?> type) {
                return true;
            }
        });
    }

    public void visitTestResources(ResourceVisitor visitor) {
        new ResourceVisit((Resource)this.getTestResourceDirectory()).perform(visitor, new ResourceFilter(){

            public boolean accept(Resource<?> resource) {
                return resource instanceof DirectoryResource;
            }
        }, new ResourceFilter(){

            public boolean accept(Resource<?> type) {
                return true;
            }
        });
    }
}

