/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.gradle.projects.facets;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.Dependent;
import org.jboss.forge.addon.facets.AbstractFacet;
import org.jboss.forge.addon.facets.constraints.FacetConstraint;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.facets.PackagingFacet;
import org.jboss.forge.addon.projects.facets.WebResourcesFacet;
import org.jboss.forge.addon.resource.DirectoryResource;
import org.jboss.forge.addon.resource.FileResource;
import org.jboss.forge.addon.resource.Resource;
import org.jboss.forge.addon.resource.ResourceFilter;
import org.jboss.forge.addon.resource.visit.ResourceVisit;
import org.jboss.forge.addon.resource.visit.ResourceVisitor;

@Dependent
@FacetConstraint(value={PackagingFacet.class})
public class GradleWebResourcesFacet
extends AbstractFacet<Project>
implements WebResourcesFacet {
    public DirectoryResource getWebRootDirectory() {
        Project project = (Project)this.getFaceted();
        String webappFolderName = "src" + File.separator + "main" + File.separator + "webapp";
        DirectoryResource projectRoot = project.getRootDirectory();
        return projectRoot.getChildDirectory(webappFolderName);
    }

    public List<DirectoryResource> getWebRootDirectories() {
        ArrayList<DirectoryResource> result = new ArrayList<DirectoryResource>();
        result.add(this.getWebRootDirectory());
        return result;
    }

    public boolean isInstalled() {
        Project project = (Project)this.getFaceted();
        String packagingType = ((PackagingFacet)project.getFacet(PackagingFacet.class)).getPackagingType();
        return packagingType.equals("war");
    }

    public boolean install() {
        if (!this.isInstalled()) {
            ((PackagingFacet)((Project)this.getFaceted()).getFacet(PackagingFacet.class)).setPackagingType("war");
            for (DirectoryResource folder : this.getWebRootDirectories()) {
                folder.mkdirs();
            }
        }
        return true;
    }

    public FileResource<?> getWebResource(String relativePath) {
        return (FileResource)this.getWebRootDirectory().getChild(relativePath);
    }

    public FileResource<?> createWebResource(char[] data, String relativePath) {
        FileResource file = (FileResource)this.getWebRootDirectory().getChild(relativePath);
        file.setContents(data);
        return file;
    }

    public FileResource<?> createWebResource(String data, String relativePath) {
        return this.createWebResource(data.toCharArray(), relativePath);
    }

    public void visitWebResources(ResourceVisitor visitor) {
        for (DirectoryResource root : this.getWebRootDirectories()) {
            ResourceVisit visit = new ResourceVisit((Resource)root);
            visit.perform(visitor, new ResourceFilter(){

                public boolean accept(Resource<?> resource) {
                    return resource instanceof DirectoryResource;
                }
            }, new ResourceFilter(){

                public boolean accept(Resource<?> type) {
                    return true;
                }
            });
            if (!visit.isTerminated()) continue;
            break;
        }
    }
}

