/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.javaee.rest.config;

import java.util.Iterator;
import java.util.List;
import org.jboss.forge.addon.javaee.rest.config.RestConfigurationStrategy;
import org.jboss.forge.addon.javaee.servlet.ServletFacet_3_0;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.furnace.util.Assert;
import org.jboss.shrinkwrap.descriptor.api.webapp30.WebAppDescriptor;
import org.jboss.shrinkwrap.descriptor.api.webcommon30.ServletMappingType;

public class RestWebXmlConfigurationStrategy
implements RestConfigurationStrategy {
    public static final String JAXRS_SERVLET = "javax.ws.rs.core.Application";
    private final String path;

    public RestWebXmlConfigurationStrategy(String path) {
        Assert.notNull((Object)path, (String)"Path cannot be null");
        this.path = path;
    }

    @Override
    public String getApplicationPath() {
        return this.path;
    }

    @Override
    public void install(Project project) {
        if (!this.installedInWebXML(project)) {
            ServletFacet_3_0 servlet = (ServletFacet_3_0)project.getFacet(ServletFacet_3_0.class);
            WebAppDescriptor config = (WebAppDescriptor)servlet.getConfig();
            config.createServlet().servletName(JAXRS_SERVLET).loadOnStartup(Integer.valueOf(1));
            String urlPattern = this.path;
            if (urlPattern.endsWith("/")) {
                urlPattern = urlPattern.substring(0, urlPattern.length() - 1);
            }
            ((ServletMappingType)config.createServletMapping().servletName(JAXRS_SERVLET)).urlPattern(new String[]{urlPattern});
            servlet.saveConfig(config);
        }
    }

    private boolean installedInWebXML(Project project) {
        return RestWebXmlConfigurationStrategy.getServletPath(project) != null;
    }

    static String getServletPath(Project project) {
        String servletPath = null;
        if (project.hasFacet(ServletFacet_3_0.class)) {
            ServletFacet_3_0 servlet = (ServletFacet_3_0)project.getFacet(ServletFacet_3_0.class);
            WebAppDescriptor config = (WebAppDescriptor)servlet.getConfig();
            List allServletMapping = config.getAllServletMapping();
            for (ServletMappingType servletMappingType : allServletMapping) {
                if (!JAXRS_SERVLET.equals(servletMappingType.getServletName())) continue;
                List allUrlPattern = servletMappingType.getAllUrlPattern();
                Iterator i$ = allUrlPattern.iterator();
                while (i$.hasNext()) {
                    String urlPattern;
                    servletPath = urlPattern = (String)i$.next();
                }
            }
        }
        return servletPath;
    }

    @Override
    public void uninstall(Project project) {
    }
}

