/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.javaee;

import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.jboss.forge.addon.dependencies.Dependency;
import org.jboss.forge.addon.dependencies.builder.DependencyBuilder;
import org.jboss.forge.addon.facets.AbstractFacet;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.ProjectFacet;
import org.jboss.forge.addon.projects.dependencies.DependencyInstaller;
import org.jboss.forge.addon.projects.facets.DependencyFacet;

public abstract class AbstractJavaEEFacet
extends AbstractFacet<Project>
implements ProjectFacet {
    protected static final Dependency JAVAEE6 = DependencyBuilder.create((String)"org.jboss.spec:jboss-javaee-6.0").setScopeType("import").setPackaging("pom").setVersion("3.0.2.Final");
    private final DependencyInstaller installer;

    @Inject
    public AbstractJavaEEFacet(DependencyInstaller installer) {
        this.installer = installer;
    }

    protected abstract Map<Dependency, List<Dependency>> getRequiredDependencyOptions();

    public boolean install() {
        DependencyFacet deps = (DependencyFacet)((Project)this.origin).getFacet(DependencyFacet.class);
        for (Map.Entry<Dependency, List<Dependency>> group : this.getRequiredDependencyOptions().entrySet()) {
            boolean satisfied = false;
            for (Dependency dependency : group.getValue()) {
                if (!deps.hasEffectiveDependency(dependency)) continue;
                satisfied = true;
                break;
            }
            if (satisfied) continue;
            this.installer.installManaged((Project)this.origin, JAVAEE6);
            this.installer.install((Project)this.origin, group.getKey());
        }
        return true;
    }

    public boolean isInstalled() {
        return this.dependencyRequirementsMet();
    }

    protected boolean dependencyRequirementsMet() {
        DependencyFacet deps = (DependencyFacet)((Project)this.origin).getFacet(DependencyFacet.class);
        for (Map.Entry<Dependency, List<Dependency>> group : this.getRequiredDependencyOptions().entrySet()) {
            boolean satisfied = false;
            for (Dependency dependency : group.getValue()) {
                if (!deps.hasEffectiveDependency(dependency)) continue;
                satisfied = true;
                break;
            }
            if (satisfied) continue;
            return false;
        }
        return true;
    }

    protected DependencyInstaller getInstaller() {
        return this.installer;
    }
}

