/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.javaee.jpa;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.FetchType;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import org.jboss.forge.addon.javaee.facets.PersistenceFacet;
import org.jboss.forge.addon.parser.java.facets.JavaSourceFacet;
import org.jboss.forge.addon.parser.java.resources.JavaResource;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.resource.Resource;
import org.jboss.forge.furnace.util.Strings;
import org.jboss.forge.parser.java.Annotation;
import org.jboss.forge.parser.java.Field;
import org.jboss.forge.parser.java.JavaClass;
import org.jboss.forge.parser.java.JavaSource;
import org.jboss.forge.parser.java.util.Refactory;
import org.jboss.forge.parser.java.util.Types;

public class FieldOperations {
    public Field<JavaClass> addFieldTo(JavaClass targetEntity, String fieldType, String fieldName, String ... annotations) throws FileNotFoundException {
        if (targetEntity.hasField(fieldName)) {
            throw new IllegalStateException("Entity already has a field named [" + fieldName + "]");
        }
        Field field = targetEntity.addField();
        ((Field)((Field)field.setName(fieldName)).setPrivate()).setType(fieldType);
        for (String annotation : annotations) {
            field.addAnnotation(annotation);
        }
        String fieldTypeForImport = Types.stripArray((String)fieldType);
        if (!fieldTypeForImport.startsWith("java.lang.") && fieldTypeForImport.contains(".") && !fieldTypeForImport.equals(targetEntity.getCanonicalName())) {
            targetEntity.addImport(fieldTypeForImport);
        }
        Refactory.createGetterAndSetter((JavaClass)targetEntity, (Field)field);
        this.updateToString(targetEntity);
        return field;
    }

    public void newOneToOneRelationship(Project project, JavaResource resource, String fieldName, String fieldType, String inverseFieldName, FetchType fetchType, boolean required, Iterable<CascadeType> cascadeTypes) throws FileNotFoundException {
        JavaSourceFacet java = (JavaSourceFacet)project.getFacet(JavaSourceFacet.class);
        JavaClass entityClass = this.getJavaClassFrom((Resource<?>)resource);
        JavaClass fieldEntityClass = this.areTypesSame(fieldType, entityClass.getCanonicalName()) ? entityClass : this.findEntity(project, fieldType);
        Field<JavaClass> localField = this.addFieldTo(entityClass, fieldEntityClass.getName(), fieldName, OneToOne.class.getName());
        Annotation annotation = localField.getAnnotation(OneToOne.class);
        if (inverseFieldName != null && !inverseFieldName.isEmpty()) {
            Field<JavaClass> inverseField = this.addFieldTo(fieldEntityClass, entityClass.getName(), inverseFieldName, OneToOne.class.getName());
            inverseField.getAnnotation(OneToOne.class).setStringValue("mappedBy", localField.getName());
            java.saveJavaSource((JavaSource)fieldEntityClass);
        }
        if (fetchType != null && fetchType != FetchType.EAGER) {
            annotation.setEnumValue("fetch", (Enum)fetchType);
        }
        if (required) {
            annotation.setLiteralValue("optional", "false");
        }
        this.addCascade(cascadeTypes, (Annotation<JavaClass>)annotation);
    }

    private void addCascade(Iterable<CascadeType> cascadeTypes, Annotation<JavaClass> annotation) {
        if (cascadeTypes != null) {
            ArrayList<CascadeType> cascades = new ArrayList<CascadeType>();
            for (CascadeType cascade : cascadeTypes) {
                cascades.add(cascade);
            }
            if (!cascades.isEmpty()) {
                if (cascades.containsAll(EnumSet.range(CascadeType.PERSIST, CascadeType.DETACH))) {
                    cascades.clear();
                    cascades.add(CascadeType.ALL);
                }
                annotation.setEnumArrayValue("cascade", (Enum[])cascades.toArray(new CascadeType[cascades.size()]));
            }
        }
    }

    public void newManyToOneRelationship(Project project, JavaResource resource, String fieldName, String fieldType, String inverseFieldName, FetchType fetchType, boolean required, Iterable<CascadeType> cascadeTypes) throws FileNotFoundException {
        JavaClass one;
        JavaSourceFacet java = (JavaSourceFacet)project.getFacet(JavaSourceFacet.class);
        JavaClass many = this.getJavaClassFrom((Resource<?>)resource);
        if (this.areTypesSame(fieldType, many.getCanonicalName())) {
            one = many;
        } else {
            one = this.findEntity(project, fieldType);
            many.addImport((JavaSource)one);
        }
        if (many.hasField(fieldName)) {
            throw new IllegalStateException("Entity [" + many.getCanonicalName() + "] already has a field named [" + fieldName + "]");
        }
        if (!Strings.isNullOrEmpty((String)inverseFieldName) && one.hasField(inverseFieldName)) {
            throw new IllegalStateException("Entity [" + one.getCanonicalName() + "] already has a field named [" + inverseFieldName + "]");
        }
        Field manyField = many.addField("private " + one.getName() + " " + fieldName + ";");
        Annotation manyAnnotation = manyField.addAnnotation(ManyToOne.class);
        Refactory.createGetterAndSetter((JavaClass)many, (Field)manyField);
        if (!Strings.isNullOrEmpty((String)inverseFieldName)) {
            one.addImport(Set.class);
            one.addImport(HashSet.class);
            if (!one.getCanonicalName().equals(many.getCanonicalName())) {
                one.addImport(many.getQualifiedName());
            }
            Field oneField = one.addField("private Set<" + many.getName() + "> " + inverseFieldName + "= new HashSet<" + many.getName() + ">();");
            Annotation oneAnnotation = oneField.addAnnotation(OneToMany.class).setStringValue("mappedBy", fieldName);
            oneAnnotation.setLiteralValue("cascade", "CascadeType.ALL");
            ((JavaClass)oneAnnotation.getOrigin()).addImport(CascadeType.class);
            Refactory.createGetterAndSetter((JavaClass)one, (Field)oneField);
            java.saveJavaSource((JavaSource)one);
        }
        if (fetchType != null && fetchType != FetchType.EAGER) {
            manyAnnotation.setEnumValue("fetch", (Enum)fetchType);
        }
        if (required) {
            manyAnnotation.setLiteralValue("optional", "false");
        }
        this.addCascade(cascadeTypes, (Annotation<JavaClass>)manyAnnotation);
        java.saveJavaSource((JavaSource)many);
    }

    public void newOneToManyRelationship(Project project, JavaResource resource, String fieldName, String fieldType, String inverseFieldName, FetchType fetchType, boolean required, Iterable<CascadeType> cascadeTypes) throws FileNotFoundException {
        JavaClass many;
        JavaSourceFacet java = (JavaSourceFacet)project.getFacet(JavaSourceFacet.class);
        JavaClass one = this.getJavaClassFrom((Resource<?>)resource);
        if (this.areTypesSame(fieldType, one.getCanonicalName())) {
            many = one;
        } else {
            many = this.findEntity(project, fieldType);
            one.addImport(many.getQualifiedName());
        }
        if (one.hasField(fieldName)) {
            throw new IllegalStateException("Entity [" + one.getCanonicalName() + "] already has a field named [" + fieldName + "]");
        }
        if (!Strings.isNullOrEmpty((String)inverseFieldName) && many.hasField(inverseFieldName)) {
            throw new IllegalStateException("Entity [" + many.getCanonicalName() + "] already has a field named [" + inverseFieldName + "]");
        }
        one.addImport(Set.class);
        one.addImport(HashSet.class);
        Field oneField = one.addField("private Set<" + many.getName() + "> " + fieldName + "= new HashSet<" + many.getName() + ">();");
        Annotation annotation = oneField.addAnnotation(OneToMany.class);
        Refactory.createGetterAndSetter((JavaClass)one, (Field)oneField);
        if (!Strings.isNullOrEmpty((String)inverseFieldName)) {
            annotation.setStringValue("mappedBy", inverseFieldName);
            annotation.setLiteralValue("cascade", "CascadeType.ALL");
            ((JavaClass)annotation.getOrigin()).addImport(CascadeType.class);
            annotation.setLiteralValue("orphanRemoval", "true");
            if (!many.getCanonicalName().equals(one.getCanonicalName())) {
                many.addImport((JavaSource)one);
            }
            Field manyField = many.addField("private " + one.getName() + " " + inverseFieldName + ";");
            manyField.addAnnotation(ManyToOne.class);
            Refactory.createGetterAndSetter((JavaClass)many, (Field)manyField);
            java.saveJavaSource((JavaSource)many);
        }
        if (fetchType != null && fetchType != FetchType.LAZY) {
            annotation.setEnumValue("fetch", (Enum)fetchType);
        }
        this.addCascade(cascadeTypes, (Annotation<JavaClass>)annotation);
        java.saveJavaSource((JavaSource)one);
    }

    public void newManyToManyRelationship(Project project, JavaResource resource, String fieldName, String fieldType, String inverseFieldName, FetchType fetchType, boolean required, Iterable<CascadeType> cascadeTypes) throws FileNotFoundException {
        JavaClass otherEntity;
        JavaSourceFacet java = (JavaSourceFacet)project.getFacet(JavaSourceFacet.class);
        JavaClass entity = this.getJavaClassFrom((Resource<?>)resource);
        if (this.areTypesSame(fieldType, entity.getCanonicalName())) {
            otherEntity = entity;
        } else {
            otherEntity = this.findEntity(project, fieldType);
            entity.addImport(otherEntity.getQualifiedName());
        }
        if (entity.hasField(fieldName)) {
            throw new IllegalStateException("Entity [" + entity.getCanonicalName() + "] already has a field named [" + fieldName + "]");
        }
        if (!Strings.isNullOrEmpty((String)inverseFieldName) && otherEntity.hasField(inverseFieldName)) {
            throw new IllegalStateException("Entity [" + otherEntity.getCanonicalName() + "] already has a field named [" + inverseFieldName + "]");
        }
        entity.addImport(Set.class);
        entity.addImport(HashSet.class);
        Field field = entity.addField("private Set<" + otherEntity.getName() + "> " + fieldName + "= new HashSet<" + otherEntity.getName() + ">();");
        Annotation annotation = field.addAnnotation(ManyToMany.class);
        Refactory.createGetterAndSetter((JavaClass)entity, (Field)field);
        if (!Strings.isNullOrEmpty((String)inverseFieldName)) {
            annotation.setStringValue("mappedBy", inverseFieldName);
            otherEntity.addImport(Set.class);
            otherEntity.addImport(HashSet.class);
            if (!otherEntity.getCanonicalName().equals(entity.getCanonicalName())) {
                otherEntity.addImport(entity.getQualifiedName());
            }
            Field otherField = otherEntity.addField("private Set<" + entity.getName() + "> " + inverseFieldName + "= new HashSet<" + entity.getName() + ">();");
            otherField.addAnnotation(ManyToMany.class);
            Refactory.createGetterAndSetter((JavaClass)otherEntity, (Field)otherField);
            java.saveJavaSource((JavaSource)otherEntity);
        }
        if (fetchType != null && fetchType != FetchType.LAZY) {
            annotation.setEnumValue("fetch", (Enum)fetchType);
        }
        this.addCascade(cascadeTypes, (Annotation<JavaClass>)annotation);
        java.saveJavaSource((JavaSource)entity);
    }

    private void updateToString(JavaClass targetEntity) {
        if (targetEntity.hasMethodSignature("toString")) {
            targetEntity.removeMethod(targetEntity.getMethod("toString"));
        }
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Field f : targetEntity.getFields()) {
            if ("id".equals(f.getName()) || "version".equals(f.getName()) || !f.getTypeInspector().isPrimitive() && !Types.isJavaLang((String)f.getType())) continue;
            fields.add(f);
        }
        if (!fields.isEmpty()) {
            Refactory.createToStringFromFields((JavaClass)targetEntity, fields);
        }
    }

    private JavaClass findEntity(Project project, String entity) throws FileNotFoundException {
        JavaClass result = null;
        PersistenceFacet scaffold = (PersistenceFacet)project.getFacet(PersistenceFacet.class);
        JavaSourceFacet java = (JavaSourceFacet)project.getFacet(JavaSourceFacet.class);
        if (entity != null && (result = this.getJavaClassFrom((Resource<?>)java.getJavaResource(entity))) == null) {
            result = this.getJavaClassFrom((Resource<?>)java.getJavaResource(scaffold.getEntityPackage() + "." + entity));
        }
        if (result == null) {
            throw new FileNotFoundException("Could not locate JavaClass on which to operate.");
        }
        return result;
    }

    private JavaClass getJavaClassFrom(Resource<?> resource) throws FileNotFoundException {
        JavaSource source = ((JavaResource)resource).getJavaSource();
        if (!source.isClass()) {
            throw new IllegalStateException("Current resource is not a JavaClass!");
        }
        return (JavaClass)source;
    }

    private boolean areTypesSame(String from, String to) {
        String fromCompare = from.endsWith(".java") ? from.substring(0, from.length() - 5) : from;
        String toCompare = to.endsWith(".java") ? to.substring(0, to.length() - 5) : to;
        return fromCompare.equals(toCompare);
    }
}

