/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.javaee.jpa;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.persistence.Entity;
import org.jboss.forge.addon.dependencies.Dependency;
import org.jboss.forge.addon.dependencies.builder.DependencyBuilder;
import org.jboss.forge.addon.javaee.AbstractJavaEEFacet;
import org.jboss.forge.addon.javaee.facets.PersistenceFacet;
import org.jboss.forge.addon.parser.java.facets.JavaSourceFacet;
import org.jboss.forge.addon.parser.java.resources.JavaResource;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.dependencies.DependencyInstaller;
import org.jboss.forge.addon.projects.facets.ResourcesFacet;
import org.jboss.forge.addon.resource.DirectoryResource;
import org.jboss.forge.addon.resource.FileResource;
import org.jboss.forge.addon.resource.Resource;
import org.jboss.forge.parser.java.JavaClass;
import org.jboss.forge.parser.java.JavaSource;
import org.jboss.shrinkwrap.descriptor.api.DescriptorImporter;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.persistence20.PersistenceDescriptor;

public class PersistenceFacetImpl
extends AbstractJavaEEFacet
implements PersistenceFacet {
    public static final String DEFAULT_ENTITY_PACKAGE = "model";
    private final Dependency JAVAX_PERSISTENCE = DependencyBuilder.create((String)"org.hibernate.javax.persistence:hibernate-jpa-2.0-api");

    @Inject
    public PersistenceFacetImpl(DependencyInstaller installer) {
        super(installer);
    }

    @Override
    protected Map<Dependency, List<Dependency>> getRequiredDependencyOptions() {
        return Collections.singletonMap(this.JAVAX_PERSISTENCE, Arrays.asList(this.JAVAX_PERSISTENCE));
    }

    @Override
    public boolean install() {
        FileResource<?> descriptor;
        if (!this.isInstalled() && !(descriptor = this.getConfigFile()).exists()) {
            this.createDefaultConfig(descriptor);
        }
        return super.install();
    }

    @Override
    public boolean isInstalled() {
        return super.isInstalled() && this.getConfigFile().exists();
    }

    public String getEntityPackage() {
        JavaSourceFacet sourceFacet = (JavaSourceFacet)((Project)this.getFaceted()).getFacet(JavaSourceFacet.class);
        return sourceFacet.getBasePackage() + "." + DEFAULT_ENTITY_PACKAGE;
    }

    public DirectoryResource getEntityPackageDir() {
        JavaSourceFacet sourceFacet = (JavaSourceFacet)((Project)this.getFaceted()).getFacet(JavaSourceFacet.class);
        DirectoryResource entityRoot = sourceFacet.getBasePackageResource().getChildDirectory(DEFAULT_ENTITY_PACKAGE);
        if (!entityRoot.exists()) {
            entityRoot.mkdirs();
        }
        return entityRoot;
    }

    public PersistenceDescriptor getConfig() {
        DescriptorImporter importer = Descriptors.importAs(PersistenceDescriptor.class);
        FileResource<?> configFile = this.getConfigFile();
        if (!configFile.exists()) {
            this.createDefaultConfig(configFile);
        }
        PersistenceDescriptor descriptor = (PersistenceDescriptor)importer.fromStream(configFile.getResourceInputStream());
        return descriptor;
    }

    private void createDefaultConfig(FileResource<?> descriptor) {
        PersistenceDescriptor descriptorContents = ((PersistenceDescriptor)Descriptors.create(PersistenceDescriptor.class)).version("2.0");
        descriptor.setContents(descriptorContents.exportAsString());
    }

    public void saveConfig(PersistenceDescriptor descriptor) {
        String output = descriptor.exportAsString();
        this.getConfigFile().setContents(output);
    }

    public FileResource<?> getConfigFile() {
        ResourcesFacet resources = (ResourcesFacet)((Project)this.getFaceted()).getFacet(ResourcesFacet.class);
        return (FileResource)resources.getResourceFolder().getChild("META-INF" + File.separator + "persistence.xml");
    }

    public List<JavaClass> getAllEntities() {
        DirectoryResource packageFile = this.getEntityPackageDir();
        return this.findEntitiesInFolder(packageFile);
    }

    private List<JavaClass> findEntitiesInFolder(DirectoryResource packageFile) {
        ArrayList<JavaClass> result = new ArrayList<JavaClass>();
        if (packageFile.exists()) {
            for (Resource source : packageFile.listResources()) {
                if (!(source instanceof JavaResource)) continue;
                try {
                    JavaSource javaClass = ((JavaResource)source).getJavaSource();
                    if (!javaClass.hasAnnotation(Entity.class) || !javaClass.isClass()) continue;
                    result.add((JavaClass)javaClass);
                }
                catch (FileNotFoundException e) {
                    throw new IllegalStateException(e);
                }
            }
            for (Resource source : packageFile.listResources()) {
                if (!(source instanceof DirectoryResource)) continue;
                List<JavaClass> subResults = this.findEntitiesInFolder((DirectoryResource)source);
                result.addAll(subResults);
            }
        }
        return result;
    }
}

