/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.javaee.jpa.ui;

import javax.inject.Inject;
import javax.persistence.GenerationType;
import org.jboss.forge.addon.javaee.jpa.PersistenceOperations;
import org.jboss.forge.addon.javaee.ui.AbstractProjectUICommand;
import org.jboss.forge.addon.parser.java.facets.JavaSourceFacet;
import org.jboss.forge.addon.parser.java.resources.JavaResource;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.resource.DirectoryResource;
import org.jboss.forge.addon.resource.FileResource;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UISelection;
import org.jboss.forge.addon.ui.hints.InputType;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;

public class NewEntityCommand
extends AbstractProjectUICommand {
    @Inject
    @WithAttributes(label="Entity name", required=true)
    private UIInput<String> named;
    @Inject
    @WithAttributes(label="Target package", type=InputType.JAVA_PACKAGE_PICKER)
    private UIInput<String> targetPackage;
    @Inject
    @WithAttributes(label="ID Column Generation Strategy", required=true)
    private UISelectOne<GenerationType> idStrategy;
    @Inject
    @WithAttributes(label="Target Directory", required=true)
    private UIInput<DirectoryResource> targetLocation;
    @Inject
    private PersistenceOperations persistenceOperations;

    @Override
    public Metadata getMetadata() {
        Metadata metadata = super.getMetadata();
        return metadata.name("JPA: New Entity").description("Create a new JPA Entity").category(Categories.create((String[])new String[]{metadata.getCategory().getName(), "JPA"}));
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        this.idStrategy.setDefaultValue((Object)GenerationType.AUTO);
        Project project = this.getSelectedProject(builder.getUIContext());
        if (project == null) {
            UISelection currentSelection = builder.getUIContext().getInitialSelection();
            if (!currentSelection.isEmpty()) {
                FileResource resource = (FileResource)currentSelection.get();
                if (resource instanceof DirectoryResource) {
                    this.targetLocation.setDefaultValue((Object)((DirectoryResource)resource));
                } else {
                    this.targetLocation.setDefaultValue((Object)resource.getParent());
                }
            }
        } else {
            JavaSourceFacet facet = (JavaSourceFacet)project.getFacet(JavaSourceFacet.class);
            ((UIInput)this.targetLocation.setDefaultValue((Object)facet.getSourceFolder())).setEnabled(false);
        }
        builder.add(this.targetLocation);
        builder.add(this.targetPackage).add(this.named).add(this.idStrategy);
    }

    public Result execute(UIContext context) throws Exception {
        String entityName = (String)this.named.getValue();
        String entityPackage = (String)this.targetPackage.getValue();
        GenerationType idStrategyChosen = (GenerationType)this.idStrategy.getValue();
        DirectoryResource targetDir = (DirectoryResource)this.targetLocation.getValue();
        Project project = this.getSelectedProject(context);
        JavaResource javaResource = project == null ? this.persistenceOperations.newEntity(targetDir, entityName, entityPackage, idStrategyChosen) : this.persistenceOperations.newEntity(project, entityName, entityPackage, idStrategyChosen);
        context.setSelection((Object)javaResource);
        return Results.success((String)("Entity " + javaResource + " created"));
    }
}

