/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.javaee.jpa.ui.setup;

import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.jboss.forge.addon.javaee.facets.PersistenceFacet;
import org.jboss.forge.addon.javaee.jpa.DatabaseType;
import org.jboss.forge.addon.javaee.jpa.JPADataSource;
import org.jboss.forge.addon.javaee.jpa.PersistenceContainer;
import org.jboss.forge.addon.javaee.jpa.PersistenceOperations;
import org.jboss.forge.addon.javaee.jpa.PersistenceProvider;
import org.jboss.forge.addon.javaee.jpa.containers.JavaEEDefaultContainer;
import org.jboss.forge.addon.javaee.ui.AbstractProjectUICommand;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.resource.FileResource;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIValidationContext;
import org.jboss.forge.addon.ui.hints.InputType;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.NavigationResult;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.addon.ui.wizard.UIWizardStep;
import org.jboss.shrinkwrap.descriptor.api.persistence20.PersistenceDescriptor;
import org.jboss.shrinkwrap.descriptor.api.persistence20.PersistenceUnit;

public class PersistenceSetupConnectionStep
extends AbstractProjectUICommand
implements UIWizardStep {
    @Inject
    @WithAttributes(label="Database Type", required=true)
    private UISelectOne<DatabaseType> dbType;
    @Inject
    @WithAttributes(label="DataSource Name", required=true)
    private UIInput<String> dataSourceName;
    @Inject
    @WithAttributes(label="JDBC Driver", required=true)
    private UIInput<String> jdbcDriver;
    @Inject
    @WithAttributes(label="Database URL", required=true)
    private UIInput<String> databaseURL;
    @Inject
    @WithAttributes(label="Username", required=true)
    private UIInput<String> username;
    @Inject
    @WithAttributes(label="Password", required=true, type=InputType.SECRET)
    private UIInput<String> password;
    @Inject
    @WithAttributes(label="Persistence Unit Name", required=true)
    private UIInput<String> persistenceUnitName;
    @Inject
    private PersistenceOperations persistenceOperations;

    public NavigationResult next(UIContext context) throws Exception {
        return null;
    }

    @Override
    public Metadata getMetadata() {
        return super.getMetadata().name("JPA: Connection Settings").description("Configure your connection settings");
    }

    public boolean isEnabled(UIContext context) {
        return true;
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        UIContext uiContext = builder.getUIContext();
        PersistenceContainer pc = (PersistenceContainer)uiContext.getAttribute(PersistenceContainer.class);
        this.initDBType(uiContext);
        this.initDatasourceName(uiContext);
        builder.add((InputComponent)this.persistenceUnitName.setDefaultValue((Object)"forge-default"));
        builder.add(this.dbType);
        if (pc.isJTASupported()) {
            builder.add(this.dataSourceName);
        } else {
            builder.add(this.jdbcDriver).add(this.databaseURL).add(this.username).add(this.password);
        }
    }

    private void initDatasourceName(final UIContext uiContext) {
        this.dataSourceName.setDefaultValue((Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                PersistenceContainer pc = (PersistenceContainer)uiContext.getAttribute(PersistenceContainer.class);
                if (pc instanceof JavaEEDefaultContainer) {
                    return ((JavaEEDefaultContainer)pc).getDefaultDataSource();
                }
                return null;
            }
        });
    }

    private void initDBType(final UIContext uiContext) {
        this.dbType.setDefaultValue((Callable)new Callable<DatabaseType>(){

            @Override
            public DatabaseType call() throws Exception {
                DatabaseType type = DatabaseType.DEFAULT;
                PersistenceContainer pc = (PersistenceContainer)uiContext.getAttribute(PersistenceContainer.class);
                if (pc instanceof JavaEEDefaultContainer) {
                    type = ((JavaEEDefaultContainer)pc).getDefaultDatabaseType();
                }
                return type;
            }
        });
    }

    private JPADataSource getDataSource(UIContext context) {
        JPADataSource dataSource = new JPADataSource();
        dataSource.setDatabase((DatabaseType)this.dbType.getValue());
        dataSource.setJndiDataSource((String)this.dataSourceName.getValue());
        dataSource.setDatabaseURL((String)this.databaseURL.getValue());
        dataSource.setUsername((String)this.username.getValue());
        dataSource.setPassword((String)this.password.getValue());
        dataSource.setProvider((PersistenceProvider)context.getAttribute(PersistenceProvider.class));
        dataSource.setContainer((PersistenceContainer)context.getAttribute(PersistenceContainer.class));
        return dataSource;
    }

    public void validate(UIValidationContext validator) {
        UIContext uiContext = validator.getUIContext();
        JPADataSource ds = this.getDataSource(uiContext);
        try {
            ds.validate();
        }
        catch (Exception e) {
            validator.addValidationError(null, e.getMessage());
        }
        Project project = this.getSelectedProject(uiContext);
        if (project.hasFacet(PersistenceFacet.class)) {
            PersistenceDescriptor config = ((PersistenceFacet)project.getFacet(PersistenceFacet.class)).getConfig();
            for (PersistenceUnit persistenceUnit : config.getAllPersistenceUnit()) {
                if (!((String)this.persistenceUnitName.getValue()).equals(persistenceUnit.getName())) continue;
                validator.addValidationError(this.persistenceUnitName, "Persistence unit name already exists in persistence descriptor.");
                break;
            }
        }
    }

    public Result execute(UIContext context) throws Exception {
        Project project = this.getSelectedProject(context);
        JPADataSource dataSource = this.getDataSource(context);
        Boolean configureMetadata = (Boolean)context.getAttribute((Object)"ConfigureMetadata");
        String puName = (String)this.persistenceUnitName.getValue();
        FileResource<?> configFile = this.persistenceOperations.setup(puName, project, dataSource, configureMetadata);
        context.setSelection(configFile);
        return Results.success((String)"Persistence (JPA) is installed.");
    }

    public UISelectOne<DatabaseType> getDbType() {
        return this.dbType;
    }

    public UIInput<String> getDataSourceName() {
        return this.dataSourceName;
    }

    public UIInput<String> getJdbcDriver() {
        return this.jdbcDriver;
    }

    public UIInput<String> getDatabaseURL() {
        return this.databaseURL;
    }

    public UIInput<String> getUsername() {
        return this.username;
    }

    public UIInput<String> getPassword() {
        return this.password;
    }
}

