/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.javaee.jpa.ui.setup;

import javax.inject.Inject;
import org.jboss.forge.addon.convert.Converter;
import org.jboss.forge.addon.javaee.jpa.PersistenceContainer;
import org.jboss.forge.addon.javaee.jpa.PersistenceProvider;
import org.jboss.forge.addon.javaee.jpa.containers.JBossEAP6Container;
import org.jboss.forge.addon.javaee.jpa.providers.HibernateProvider;
import org.jboss.forge.addon.javaee.jpa.ui.setup.PersistenceSetupConnectionStep;
import org.jboss.forge.addon.javaee.ui.AbstractProjectUICommand;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIValidationContext;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.NavigationResult;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.addon.ui.wizard.UIWizard;

public class PersistenceSetupWizard
extends AbstractProjectUICommand
implements UIWizard {
    @Inject
    @WithAttributes(label="Container", required=true)
    private UISelectOne<PersistenceContainer> containers;
    @Inject
    @WithAttributes(label="Provider", required=true)
    private UISelectOne<PersistenceProvider> providers;
    @Inject
    @WithAttributes(label="Install a JPA 2 metamodel generator?")
    private UIInput<Boolean> configureMetadata;
    @Inject
    private JBossEAP6Container defaultContainer;
    @Inject
    private HibernateProvider defaultProvider;

    @Override
    public Metadata getMetadata() {
        Metadata metadata = super.getMetadata();
        return metadata.name("JPA: Setup").description("Setup JPA in your project").category(Categories.create((String[])new String[]{metadata.getCategory().getName(), "JPA"}));
    }

    public boolean isEnabled(UIContext context) {
        return this.getSelectedProject(context) != null;
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        this.initContainers();
        this.initProviders();
        this.initConfigureMetadata();
        builder.add(this.containers).add(this.providers).add(this.configureMetadata);
    }

    private void initContainers() {
        this.containers.setItemLabelConverter((Converter)new Converter<PersistenceContainer, String>(){

            public String convert(PersistenceContainer source) {
                return source != null ? source.getName() : null;
            }
        });
        this.containers.setDefaultValue((Object)this.defaultContainer);
    }

    private void initProviders() {
        this.providers.setItemLabelConverter((Converter)new Converter<PersistenceProvider, String>(){

            public String convert(PersistenceProvider source) {
                return source != null ? source.getName() : null;
            }
        });
        this.providers.setDefaultValue((Object)this.defaultProvider);
    }

    private void initConfigureMetadata() {
        this.configureMetadata.setDefaultValue((Object)Boolean.FALSE);
    }

    public void validate(UIValidationContext validator) {
    }

    public Result execute(UIContext context) throws Exception {
        this.applyUIValues(context);
        return Results.success();
    }

    public NavigationResult next(UIContext context) throws Exception {
        this.applyUIValues(context);
        return Results.navigateTo(PersistenceSetupConnectionStep.class);
    }

    private void applyUIValues(UIContext context) {
        context.setAttribute(PersistenceProvider.class, this.providers.getValue());
        context.setAttribute(PersistenceContainer.class, this.containers.getValue());
        context.setAttribute((Object)"ConfigureMetadata", this.configureMetadata.getValue());
    }

    public UISelectOne<PersistenceContainer> getContainers() {
        return this.containers;
    }

    public UISelectOne<PersistenceProvider> getProviders() {
        return this.providers;
    }

    public UIInput<Boolean> getConfigureMetadata() {
        return this.configureMetadata;
    }
}

