/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.javaee.servlet;

import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.jboss.forge.addon.dependencies.Dependency;
import org.jboss.forge.addon.dependencies.builder.DependencyBuilder;
import org.jboss.forge.addon.facets.FacetFactory;
import org.jboss.forge.addon.facets.Faceted;
import org.jboss.forge.addon.javaee.AbstractJavaEEFacet;
import org.jboss.forge.addon.javaee.facets.ServletFacet;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.dependencies.DependencyInstaller;
import org.jboss.forge.addon.projects.facets.MetadataFacet;
import org.jboss.forge.addon.projects.facets.WebResourcesFacet;
import org.jboss.forge.addon.resource.DirectoryResource;
import org.jboss.forge.addon.resource.FileResource;
import org.jboss.forge.addon.resource.Resource;
import org.jboss.forge.addon.resource.ResourceFilter;
import org.jboss.forge.furnace.util.Streams;
import org.jboss.shrinkwrap.descriptor.api.DescriptorImporter;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.webapp30.WebAppDescriptor;

public class ServletFacetImpl
extends AbstractJavaEEFacet
implements ServletFacet {
    private static final Dependency JAVAX_SERVLET_API = DependencyBuilder.create((String)"org.jboss.spec.javax.servlet:jboss-servlet-api_3.0_spec");
    @Inject
    private FacetFactory facetFactory;

    @Inject
    public ServletFacetImpl(DependencyInstaller installer) {
        super(installer);
    }

    @Override
    protected Map<Dependency, List<Dependency>> getRequiredDependencyOptions() {
        LinkedHashMap<Dependency, List<Dependency>> map = new LinkedHashMap<Dependency, List<Dependency>>();
        map.put(JAVAX_SERVLET_API, Arrays.asList(JAVAX_SERVLET_API));
        return map;
    }

    @Override
    public boolean isInstalled() {
        Project project = (Project)this.getFaceted();
        if (!project.hasFacet(WebResourcesFacet.class)) {
            return false;
        }
        DirectoryResource webRoot = ((WebResourcesFacet)project.getFacet(WebResourcesFacet.class)).getWebRootDirectory();
        return webRoot.exists();
    }

    @Override
    public boolean install() {
        Project project;
        WebResourcesFacet webFacet;
        DirectoryResource webRoot;
        if (!this.isInstalled() && !(webRoot = (webFacet = (WebResourcesFacet)this.facetFactory.install((Faceted)(project = (Project)this.getFaceted()), WebResourcesFacet.class)).getWebRootDirectory()).exists()) {
            webRoot.mkdirs();
        }
        return super.install();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebAppDescriptor getConfig() {
        DescriptorImporter importer = Descriptors.importAs(WebAppDescriptor.class);
        FileResource<?> configFile = this.getConfigFile();
        InputStream inputStream = configFile.getResourceInputStream();
        try {
            WebAppDescriptor descriptor;
            WebAppDescriptor webAppDescriptor = descriptor = (WebAppDescriptor)importer.fromStream(inputStream);
            return webAppDescriptor;
        }
        finally {
            Streams.closeQuietly((Closeable)inputStream);
        }
    }

    public void saveConfig(WebAppDescriptor descriptor) {
        String output = descriptor.exportAsString();
        FileResource<?> configFile = this.getConfigFile();
        configFile.setContents(output);
    }

    public FileResource<?> getConfigFile() {
        Project project = (Project)this.getFaceted();
        DirectoryResource webRoot = ((WebResourcesFacet)project.getFacet(WebResourcesFacet.class)).getWebRootDirectory();
        FileResource child = (FileResource)webRoot.getChild("WEB-INF" + File.separator + "web.xml");
        if (!child.exists()) {
            String projectName = ((MetadataFacet)project.getFacet(MetadataFacet.class)).getProjectName();
            WebAppDescriptor unit = (WebAppDescriptor)((WebAppDescriptor)Descriptors.create(WebAppDescriptor.class)).displayName(new String[]{projectName}).createSessionConfig().sessionTimeout(Integer.valueOf(30)).up();
            unit.createMimeMapping().extension("ico").mimeType("image/x-icon");
            child.setContents(unit.exportAsString());
        }
        return child;
    }

    public List<Resource<?>> getResources() {
        DirectoryResource webRoot = ((WebResourcesFacet)((Project)this.getFaceted()).getFacet(WebResourcesFacet.class)).getWebRootDirectory();
        return this.listChildrenRecursively(webRoot);
    }

    private List<Resource<?>> listChildrenRecursively(DirectoryResource webRoot) {
        return this.listChildrenRecursively(webRoot, new ResourceFilter(){

            public boolean accept(Resource<?> resource) {
                return true;
            }
        });
    }

    public List<Resource<?>> getResources(ResourceFilter filter) {
        DirectoryResource webRoot = ((WebResourcesFacet)((Project)this.getFaceted()).getFacet(WebResourcesFacet.class)).getWebRootDirectory();
        return this.listChildrenRecursively(webRoot, filter);
    }

    private List<Resource<?>> listChildrenRecursively(DirectoryResource current, ResourceFilter filter) {
        ArrayList result = new ArrayList();
        List list = current.listResources();
        if (list != null) {
            for (Resource file : list) {
                if (file instanceof DirectoryResource) {
                    result.addAll(this.listChildrenRecursively((DirectoryResource)file, filter));
                }
                if (!filter.accept(file)) continue;
                result.add(file);
            }
        }
        return result;
    }
}

