/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.javaee.faces;

import java.io.FileNotFoundException;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.ValidatorException;
import javax.inject.Inject;
import org.jboss.forge.addon.parser.java.JavaSourceFactory;
import org.jboss.forge.addon.parser.java.facets.JavaSourceFacet;
import org.jboss.forge.addon.parser.java.resources.JavaResource;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.resource.DirectoryResource;
import org.jboss.forge.parser.java.JavaClass;
import org.jboss.forge.parser.java.JavaSource;
import org.jboss.forge.parser.java.Method;

public class FacesOperations {
    @Inject
    private JavaSourceFactory javaSourceFactory;

    public JavaResource newConverter(Project project, String converterName, String converterPackage) throws FileNotFoundException {
        JavaSourceFacet java = (JavaSourceFacet)project.getFacet(JavaSourceFacet.class);
        JavaClass javaClass = this.createConverter(converterName, converterPackage);
        return java.saveJavaSource((JavaSource)javaClass);
    }

    public JavaResource newConverter(DirectoryResource target, String converterName, String converterPackage) {
        JavaClass javaClass = this.createConverter(converterName, converterPackage);
        JavaResource javaResource = this.getJavaResource(target, javaClass.getName());
        javaResource.setContents((JavaSource)javaClass);
        return javaResource;
    }

    private JavaClass createConverter(String converterName, String converterPackage) {
        JavaClass source = (JavaClass)this.javaSourceFactory.parse(JavaClass.class, this.getClass().getResourceAsStream("Converter.jv"));
        source.setName(converterName);
        source.setPackage(converterPackage);
        return source;
    }

    public JavaResource newValidator(Project project, String validatorName, String validatorPackage) throws FileNotFoundException {
        JavaSourceFacet java = (JavaSourceFacet)project.getFacet(JavaSourceFacet.class);
        JavaClass javaClass = this.createValidator(validatorName, validatorPackage);
        return java.saveJavaSource((JavaSource)javaClass);
    }

    public JavaResource newValidator(DirectoryResource target, String converterName, String converterPackage) {
        JavaClass javaClass = this.createValidator(converterName, converterPackage);
        JavaResource javaResource = this.getJavaResource(target, javaClass.getName());
        javaResource.setContents((JavaSource)javaClass);
        return javaResource;
    }

    private JavaClass createValidator(String converterName, String converterPackage) {
        JavaClass source = (JavaClass)this.javaSourceFactory.parse(JavaClass.class, this.getClass().getResourceAsStream("Validator.jv"));
        source.setName(converterName);
        source.setPackage(converterPackage);
        return source;
    }

    private JavaResource getJavaResource(DirectoryResource sourceDir, String relativePath) {
        String path = relativePath.trim().endsWith(".java") ? relativePath.substring(0, relativePath.lastIndexOf(".java")) : relativePath;
        path = path.replace(".", "/") + ".java";
        JavaResource target = (JavaResource)sourceDir.getChildOfType(JavaResource.class, path);
        return target;
    }

    public Method<JavaClass> addValidatorMethod(JavaResource target, String name) throws FileNotFoundException {
        JavaClass source = (JavaClass)target.getJavaSource();
        Method method = ((Method)source.addMethod().setName(name)).setParameters("final FacesContext context, final UIComponent component, final Object value").setBody("throw new ValidatorException(new FacesMessage(\"Validator not yet implemented.\"));").addThrows(ValidatorException.class);
        ((JavaClass)method.getOrigin()).addImport(ValidatorException.class);
        ((JavaClass)method.getOrigin()).addImport(FacesMessage.class);
        ((JavaClass)method.getOrigin()).addImport(FacesContext.class);
        ((JavaClass)method.getOrigin()).addImport(UIComponent.class);
        target.setContents((JavaSource)source);
        return method;
    }
}

