/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.javaee.faces.ui;

import java.io.FileNotFoundException;
import javax.inject.Inject;
import javax.persistence.Entity;
import org.jboss.forge.addon.javaee.faces.FacesOperations;
import org.jboss.forge.addon.javaee.ui.AbstractJavaEECommand;
import org.jboss.forge.addon.parser.java.facets.JavaSourceFacet;
import org.jboss.forge.addon.parser.java.resources.JavaResource;
import org.jboss.forge.addon.parser.java.resources.JavaResourceVisitor;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.facets.MetadataFacet;
import org.jboss.forge.addon.resource.DirectoryResource;
import org.jboss.forge.addon.resource.FileResource;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UISelection;
import org.jboss.forge.addon.ui.hints.InputType;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.metadata.UICategory;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.parser.java.JavaSource;

public class NewConverterCommand
extends AbstractJavaEECommand {
    @Inject
    @WithAttributes(label="Converter name", required=true)
    private UIInput<String> named;
    @Inject
    @WithAttributes(label="Target package", type=InputType.JAVA_PACKAGE_PICKER)
    private UIInput<String> targetPackage;
    @Inject
    @WithAttributes(label="Target Directory", required=true)
    private UIInput<DirectoryResource> targetLocation;
    @Inject
    private FacesOperations facesOperations;

    public Metadata getMetadata(UIContext context) {
        return Metadata.from((UICommandMetadata)super.getMetadata(context), ((Object)((Object)this)).getClass()).name("Faces: New Converter").description("Create a new JSF Converter Type").category(Categories.create((UICategory)super.getMetadata(context).getCategory(), (String[])new String[]{"JSF"}));
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        Project project = this.getSelectedProject(builder.getUIContext());
        if (project == null) {
            UISelection currentSelection = builder.getUIContext().getInitialSelection();
            if (!currentSelection.isEmpty()) {
                FileResource resource = (FileResource)currentSelection.get();
                if (resource instanceof DirectoryResource) {
                    this.targetLocation.setDefaultValue((Object)((DirectoryResource)resource));
                } else {
                    this.targetLocation.setDefaultValue((Object)resource.getParent());
                }
            }
        } else if (project.hasFacet(JavaSourceFacet.class)) {
            JavaSourceFacet facet = (JavaSourceFacet)project.getFacet(JavaSourceFacet.class);
            ((UIInput)this.targetLocation.setDefaultValue((Object)facet.getSourceFolder())).setEnabled(false);
            this.targetPackage.setValue((Object)this.calculateConverterPackage(project));
        }
        builder.add(this.targetLocation);
        builder.add(this.targetPackage).add(this.named);
    }

    private String calculateConverterPackage(Project project) {
        final String[] value = new String[1];
        ((JavaSourceFacet)project.getFacet(JavaSourceFacet.class)).visitJavaSources(new JavaResourceVisitor(){

            public void visit(JavaResource javaResource) {
                try {
                    JavaSource javaSource = javaResource.getJavaSource();
                    if (javaSource.hasAnnotation(Entity.class)) {
                        value[0] = javaSource.getPackage();
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
        });
        if (value[0] == null) {
            value[0] = ((MetadataFacet)project.getFacet(MetadataFacet.class)).getTopLevelPackage() + ".convert";
        }
        return value[0];
    }

    public Result execute(UIContext context) throws Exception {
        String entityName = (String)this.named.getValue();
        String entityPackage = (String)this.targetPackage.getValue();
        DirectoryResource targetDir = (DirectoryResource)this.targetLocation.getValue();
        Project project = this.getSelectedProject(context);
        JavaResource javaResource = project == null ? this.facesOperations.newConverter(targetDir, entityName, entityPackage) : this.facesOperations.newConverter(project, entityName, entityPackage);
        context.setSelection((Object)javaResource);
        return Results.success((String)("Converter " + javaResource + " created"));
    }

    protected boolean isProjectRequired() {
        return false;
    }
}

