/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.javaee.jpa;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Entity;
import org.jboss.forge.addon.javaee.AbstractJavaEEFacet;
import org.jboss.forge.addon.javaee.jpa.JPAFacet;
import org.jboss.forge.addon.parser.java.facets.JavaSourceFacet;
import org.jboss.forge.addon.parser.java.resources.JavaResource;
import org.jboss.forge.addon.parser.java.resources.JavaResourceVisitor;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.dependencies.DependencyInstaller;
import org.jboss.forge.addon.projects.facets.ResourcesFacet;
import org.jboss.forge.addon.resource.DirectoryResource;
import org.jboss.forge.addon.resource.FileResource;
import org.jboss.forge.parser.java.JavaClass;
import org.jboss.forge.parser.java.JavaSource;
import org.jboss.shrinkwrap.descriptor.api.persistence.PersistenceCommonDescriptor;

public abstract class AbstractJPAFacetImpl<DESCRIPTOR extends PersistenceCommonDescriptor>
extends AbstractJavaEEFacet
implements JPAFacet<DESCRIPTOR> {
    public static final String DEFAULT_ENTITY_PACKAGE = "model";

    public AbstractJPAFacetImpl(DependencyInstaller installer) {
        super(installer);
    }

    @Override
    public boolean install() {
        FileResource<?> descriptor;
        if (!this.isInstalled() && !(descriptor = this.getConfigFile()).exists()) {
            this.createDefaultConfig(descriptor);
        }
        return super.install();
    }

    @Override
    public boolean isInstalled() {
        return super.isInstalled() && this.getConfigFile().exists();
    }

    public String getEntityPackage() {
        JavaSourceFacet sourceFacet = (JavaSourceFacet)((Project)this.getFaceted()).getFacet(JavaSourceFacet.class);
        return sourceFacet.getBasePackage() + "." + DEFAULT_ENTITY_PACKAGE;
    }

    public DirectoryResource getEntityPackageDir() {
        JavaSourceFacet sourceFacet = (JavaSourceFacet)((Project)this.getFaceted()).getFacet(JavaSourceFacet.class);
        DirectoryResource entityRoot = sourceFacet.getBasePackageResource().getChildDirectory(DEFAULT_ENTITY_PACKAGE);
        if (!entityRoot.exists()) {
            entityRoot.mkdirs();
        }
        return entityRoot;
    }

    public FileResource<?> getConfigFile() {
        ResourcesFacet resources = (ResourcesFacet)((Project)this.getFaceted()).getFacet(ResourcesFacet.class);
        return (FileResource)resources.getResourceFolder().getChild("META-INF" + File.separator + "persistence.xml");
    }

    public List<JavaClass> getAllEntities() {
        final ArrayList<JavaClass> result = new ArrayList<JavaClass>();
        JavaSourceFacet javaSourceFacet = (JavaSourceFacet)((Project)this.getFaceted()).getFacet(JavaSourceFacet.class);
        javaSourceFacet.visitJavaSources(new JavaResourceVisitor(){

            public void visit(JavaResource resource) {
                try {
                    JavaSource javaClass = resource.getJavaSource();
                    if (javaClass.hasAnnotation(Entity.class) && javaClass.isClass()) {
                        result.add((JavaClass)javaClass);
                    }
                }
                catch (FileNotFoundException e) {
                    throw new IllegalStateException(e);
                }
            }
        });
        return result;
    }

    protected abstract void createDefaultConfig(FileResource<?> var1);
}

