/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.javaee.jpa;

import java.io.FileNotFoundException;
import java.io.Serializable;
import javax.inject.Inject;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Version;
import org.jboss.forge.addon.facets.Facet;
import org.jboss.forge.addon.facets.FacetFactory;
import org.jboss.forge.addon.facets.Faceted;
import org.jboss.forge.addon.javaee.jpa.JPADataSource;
import org.jboss.forge.addon.javaee.jpa.JPAFacet;
import org.jboss.forge.addon.javaee.jpa.PersistenceContainer;
import org.jboss.forge.addon.javaee.jpa.PersistenceMetaModelFacet;
import org.jboss.forge.addon.javaee.jpa.PersistenceProvider;
import org.jboss.forge.addon.parser.java.JavaSourceFactory;
import org.jboss.forge.addon.parser.java.facets.JavaSourceFacet;
import org.jboss.forge.addon.parser.java.resources.JavaResource;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.resource.DirectoryResource;
import org.jboss.forge.addon.resource.FileResource;
import org.jboss.forge.parser.java.Field;
import org.jboss.forge.parser.java.JavaClass;
import org.jboss.forge.parser.java.JavaSource;
import org.jboss.forge.parser.java.util.Refactory;
import org.jboss.shrinkwrap.descriptor.api.persistence.PersistenceCommonDescriptor;
import org.jboss.shrinkwrap.descriptor.api.persistence.PersistenceUnitCommon;

public class PersistenceOperations {
    public static final String DEFAULT_UNIT_NAME = "forge-default";
    public static final String DEFAULT_UNIT_DESC = "Forge Persistence Unit";
    @Inject
    private FacetFactory facetFactory;
    @Inject
    private JavaSourceFactory javaSourceFactory;

    public FileResource<?> setup(String unitName, Project project, JPADataSource dataSource, boolean configureMetadata) {
        FileResource result = null;
        if (project != null) {
            JPAFacet facet = (JPAFacet)project.getFacet(JPAFacet.class);
            PersistenceContainer container = dataSource.getContainer();
            PersistenceProvider provider = dataSource.getProvider();
            PersistenceCommonDescriptor config = (PersistenceCommonDescriptor)facet.getConfig();
            PersistenceUnitCommon unit = config.createPersistenceUnit();
            unit.name(unitName).description(DEFAULT_UNIT_DESC);
            unit.transactionType(container.isJTASupported() ? "JTA" : "RESOURCE_LOCAL");
            if (provider.getProvider() != null) {
                unit.provider(provider.getProvider());
            }
            container.setupConnection(unit, dataSource);
            provider.configure(unit, dataSource);
            facet.saveConfig((Object)config);
            result = facet.getConfigFile();
            if (configureMetadata) {
                Iterable facets = this.facetFactory.createFacets((Faceted)project, PersistenceMetaModelFacet.class);
                for (PersistenceMetaModelFacet metaModelFacet : facets) {
                    metaModelFacet.setMetaModelProvider(provider.getMetaModelProvider());
                    if (!this.facetFactory.install((Faceted)project, (Facet)metaModelFacet)) continue;
                    break;
                }
            }
        }
        return result;
    }

    public JavaResource newEntity(Project project, String entityName, String entityPackage, GenerationType idStrategy) throws FileNotFoundException {
        JavaSourceFacet java = (JavaSourceFacet)project.getFacet(JavaSourceFacet.class);
        JavaClass javaClass = this.createJavaClass(entityName, entityPackage, idStrategy);
        return java.saveJavaSource((JavaSource)javaClass);
    }

    public JavaResource newEntity(DirectoryResource target, String entityName, String entityPackage, GenerationType idStrategy) {
        JavaClass javaClass = this.createJavaClass(entityName, entityPackage, idStrategy);
        JavaResource javaResource = this.getJavaResource(target, javaClass.getName());
        javaResource.setContents((JavaSource)javaClass);
        return javaResource;
    }

    private JavaClass createJavaClass(String entityName, String entityPackage, GenerationType idStrategy) {
        JavaClass javaClass = (JavaClass)((JavaClass)((JavaClass)((JavaClass)((JavaClass)this.javaSourceFactory.create(JavaClass.class)).setName(entityName)).setPublic()).addAnnotation(Entity.class).getOrigin()).addInterface(Serializable.class);
        if (entityPackage != null && !entityPackage.isEmpty()) {
            javaClass.setPackage(entityPackage);
        }
        Field id = javaClass.addField("private Long id = null;");
        id.addAnnotation(Id.class);
        id.addAnnotation(GeneratedValue.class).setEnumValue("strategy", (Enum)idStrategy);
        id.addAnnotation(Column.class).setStringValue("name", "id").setLiteralValue("updatable", "false").setLiteralValue("nullable", "false");
        Field version = javaClass.addField("private int version = 0;");
        version.addAnnotation(Version.class);
        version.addAnnotation(Column.class).setStringValue("name", "version");
        Refactory.createGetterAndSetter((JavaClass)javaClass, (Field)id);
        Refactory.createGetterAndSetter((JavaClass)javaClass, (Field)version);
        Refactory.createToStringFromFields((JavaClass)javaClass, (Field[])new Field[]{id});
        Refactory.createHashCodeAndEquals((JavaClass)javaClass, (Field[])new Field[]{id});
        return javaClass;
    }

    private JavaResource getJavaResource(DirectoryResource sourceDir, String relativePath) {
        String path = relativePath.trim().endsWith(".java") ? relativePath.substring(0, relativePath.lastIndexOf(".java")) : relativePath;
        path = path.replace(".", "/") + ".java";
        JavaResource target = (JavaResource)sourceDir.getChildOfType(JavaResource.class, path);
        return target;
    }
}

