/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.javaee.jpa.ui;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Lob;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.jboss.forge.addon.convert.Converter;
import org.jboss.forge.addon.javaee.jpa.FieldOperations;
import org.jboss.forge.addon.javaee.jpa.ui.NewFieldRelationshipWizardStep;
import org.jboss.forge.addon.javaee.jpa.ui.RelationshipType;
import org.jboss.forge.addon.javaee.ui.AbstractJavaEECommand;
import org.jboss.forge.addon.parser.java.facets.JavaSourceFacet;
import org.jboss.forge.addon.parser.java.resources.JavaResource;
import org.jboss.forge.addon.parser.java.resources.JavaResourceVisitor;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UISelection;
import org.jboss.forge.addon.ui.context.UIValidationContext;
import org.jboss.forge.addon.ui.hints.InputType;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.NavigationResult;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.addon.ui.wizard.UIWizard;
import org.jboss.forge.parser.java.Field;
import org.jboss.forge.parser.java.JavaClass;
import org.jboss.forge.parser.java.JavaSource;
import org.jboss.forge.parser.java.util.Types;

public class NewFieldWizard
extends AbstractJavaEECommand
implements UIWizard {
    @Inject
    @WithAttributes(label="Entity", description="The entity which the field will be created", required=true, type=InputType.DROPDOWN)
    private UISelectOne<JavaResource> entity;
    @Inject
    @WithAttributes(label="Field Name", description="The field name to be created in the target entity", required=true)
    private UIInput<String> fieldName;
    @Inject
    @WithAttributes(label="Type", description="The type intended to be used for this field", type=InputType.JAVA_CLASS_PICKER, required=true)
    private UIInput<String> typeName;
    @Inject
    @WithAttributes(label="Relationship", description="The type of the relationship", type=InputType.RADIO)
    private UISelectOne<RelationshipType> relationshipType;
    @Inject
    @WithAttributes(label="Use Primitive Version?", description="For this field type, use the primitive version", defaultValue="false")
    private UIInput<Boolean> primitive;
    @Inject
    @WithAttributes(label="Is LOB?", description="If the relationship is a LOB, in this case, it will ignore the value in the Type field", defaultValue="false")
    private UIInput<Boolean> lob;
    @Inject
    @WithAttributes(label="Length", defaultValue="255", description="The column length. (Applies only if a string-valued column is used.)")
    private UIInput<Integer> length;
    @Inject
    @WithAttributes(label="Temporal Type", defaultValue="DATE", description="Adds @Temporal only if field is java.util.Date or java.util.Calendar", type=InputType.RADIO, enabled=false)
    private UISelectOne<TemporalType> temporalType;
    @Inject
    private FieldOperations fieldOperations;

    public Metadata getMetadata(UIContext context) {
        return Metadata.from((UICommandMetadata)super.getMetadata(context), ((Object)((Object)this)).getClass()).name("JPA: New Field").description("Create a new field").category(Categories.create((String[])new String[]{super.getMetadata(context).getCategory().getName(), "JPA"}));
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        this.setupEntities(builder.getUIContext());
        this.setupRelationshipType();
        this.lob.setEnabled((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return (Boolean)NewFieldWizard.this.primitive.getValue() == false && NewFieldWizard.this.relationshipType.getValue() == RelationshipType.BASIC;
            }
        });
        this.primitive.setEnabled((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return NewFieldWizard.this.relationshipType.getValue() == RelationshipType.BASIC;
            }
        });
        this.typeName.setEnabled((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return (Boolean)NewFieldWizard.this.lob.getValue() == false;
            }
        });
        this.length.setEnabled((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return (Boolean)NewFieldWizard.this.lob.getValue() == false;
            }
        });
        this.temporalType.setEnabled((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                String typeValue = (String)NewFieldWizard.this.typeName.getValue();
                return Date.class.getName().equals(typeValue) || Calendar.class.getName().equals(typeValue);
            }
        });
        builder.add(this.entity).add(this.fieldName).add(this.typeName).add(this.temporalType).add(this.length).add(this.relationshipType).add(this.lob).add(this.primitive);
    }

    private void setupEntities(UIContext context) {
        UISelection selection = context.getInitialSelection();
        Project project = this.getSelectedProject(context);
        final ArrayList entities = new ArrayList();
        if (project != null) {
            ((JavaSourceFacet)project.getFacet(JavaSourceFacet.class)).visitJavaSources(new JavaResourceVisitor(){

                public void visit(JavaResource resource) {
                    try {
                        if (resource.getJavaSource().hasAnnotation(Entity.class)) {
                            entities.add(resource);
                        }
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        // empty catch block
                    }
                }
            });
        }
        this.entity.setValueChoices(entities);
        int idx = -1;
        if (!selection.isEmpty()) {
            idx = entities.indexOf(selection.get());
        }
        if (idx == -1) {
            idx = entities.size() - 1;
        }
        if (idx != -1) {
            this.entity.setDefaultValue(entities.get(idx));
        }
    }

    private void setupRelationshipType() {
        this.relationshipType.setItemLabelConverter((Converter)new Converter<RelationshipType, String>(){

            public String convert(RelationshipType source) {
                return source == null ? null : source.getDescription();
            }
        });
        this.relationshipType.setDefaultValue((Object)RelationshipType.BASIC);
    }

    public Result execute(UIContext context) throws Exception {
        JavaResource javaResource = (JavaResource)this.entity.getValue();
        String fieldNameStr = (String)this.fieldName.getValue();
        JavaClass targetEntity = (JavaClass)javaResource.getJavaSource();
        RelationshipType value = (RelationshipType)((Object)this.relationshipType.getValue());
        if (value == RelationshipType.BASIC) {
            Project selectedProject;
            Field<JavaClass> field;
            String fieldType;
            if (((Boolean)this.primitive.getValue()).booleanValue()) {
                fieldType = this.getPrimitiveTypeFor((String)this.typeName.getValue());
                field = this.fieldOperations.addFieldTo(targetEntity, fieldType, fieldNameStr, Column.class.getCanonicalName());
            } else if (((Boolean)this.lob.getValue()).booleanValue()) {
                fieldType = byte[].class.getName();
                field = this.fieldOperations.addFieldTo(targetEntity, fieldType, fieldNameStr, Lob.class.getName());
                field.addAnnotation(Column.class).setLiteralValue("length", String.valueOf(Integer.MAX_VALUE));
            } else {
                fieldType = (String)this.typeName.getValue();
                field = this.fieldOperations.addFieldTo(targetEntity, fieldType, fieldNameStr, Column.class.getCanonicalName());
            }
            if (this.length.isEnabled() && this.length.getValue() != null && (Integer)this.length.getValue() != 255) {
                field.getAnnotation(Column.class).setLiteralValue("length", String.valueOf(this.length.getValue()));
            }
            if (this.temporalType.isEnabled()) {
                field.addAnnotation(Temporal.class).setEnumValue(new Enum[]{(Enum)this.temporalType.getValue()});
            }
            if ((selectedProject = this.getSelectedProject(context)) != null) {
                JavaSourceFacet facet = (JavaSourceFacet)selectedProject.getFacet(JavaSourceFacet.class);
                facet.saveJavaSource((JavaSource)field.getOrigin());
            }
            context.setSelection((Object)javaResource);
            return Results.success((String)("Field " + (String)this.fieldName.getValue() + " created"));
        }
        return Results.success();
    }

    public void validate(UIValidationContext validator) {
        String primitiveType;
        super.validate(validator);
        try {
            JavaClass javaClass;
            JavaResource javaResource = (JavaResource)this.entity.getValue();
            if (javaResource != null && (javaClass = (JavaClass)javaResource.getJavaSource()).hasField((String)this.fieldName.getValue())) {
                validator.addValidationError(this.entity, "Field '" + (String)this.fieldName.getValue() + "' already exists");
            }
        }
        catch (FileNotFoundException ffe) {
            validator.addValidationError(this.entity, "Entity could not be found");
        }
        if (((Boolean)this.primitive.getValue()).booleanValue() && (primitiveType = this.getPrimitiveTypeFor((String)this.typeName.getValue())) == null) {
            validator.addValidationError(this.typeName, "Type is not a wrapper of a primitive type");
        }
        if (this.length.isEnabled() && (this.length.getValue() == null || (Integer)this.length.getValue() <= 0)) {
            validator.addValidationError(this.length, "Length should be a positive integer");
        }
    }

    private String getPrimitiveTypeFor(String value) {
        if (value == null) {
            return null;
        }
        String val = value.toLowerCase().replaceAll("java.lang.", "");
        if (val.equals("integer")) {
            val = "int";
        } else if (val.equals("character")) {
            val = "char";
        }
        return Types.isPrimitive((String)val) ? val : null;
    }

    public NavigationResult next(UIContext context) throws Exception {
        context.setAttribute(JavaResource.class, this.entity.getValue());
        context.setAttribute((Object)"fieldName", this.fieldName.getValue());
        context.setAttribute((Object)"fieldType", this.typeName.getValue());
        context.setAttribute(RelationshipType.class, this.relationshipType.getValue());
        context.getAttribute(RelationshipType.class);
        if (this.relationshipType.getValue() == RelationshipType.BASIC) {
            return null;
        }
        return Results.navigateTo(NewFieldRelationshipWizardStep.class);
    }

    protected boolean isProjectRequired() {
        return false;
    }
}

