/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.javaee.jpa.ui.setup;

import java.util.List;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.jboss.forge.addon.javaee.jpa.DatabaseType;
import org.jboss.forge.addon.javaee.jpa.JPADataSource;
import org.jboss.forge.addon.javaee.jpa.JPAFacet;
import org.jboss.forge.addon.javaee.jpa.PersistenceContainer;
import org.jboss.forge.addon.javaee.jpa.PersistenceOperations;
import org.jboss.forge.addon.javaee.jpa.PersistenceProvider;
import org.jboss.forge.addon.javaee.jpa.containers.JavaEEDefaultContainer;
import org.jboss.forge.addon.javaee.ui.AbstractJavaEECommand;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.resource.FileResource;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIValidationContext;
import org.jboss.forge.addon.ui.hints.InputType;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.NavigationResult;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.addon.ui.wizard.UIWizardStep;
import org.jboss.shrinkwrap.descriptor.api.persistence.PersistenceCommonDescriptor;
import org.jboss.shrinkwrap.descriptor.api.persistence.PersistenceUnitCommon;

public class JPASetupConnectionStep
extends AbstractJavaEECommand
implements UIWizardStep {
    @Inject
    @WithAttributes(shortName=116, label="Database Type", required=true)
    private UISelectOne<DatabaseType> dbType;
    @Inject
    @WithAttributes(shortName=100, label="DataSource Name", required=true)
    private UIInput<String> dataSourceName;
    @Inject
    @WithAttributes(label="JDBC Driver", required=true)
    private UIInput<String> jdbcDriver;
    @Inject
    @WithAttributes(label="Database URL", required=true)
    private UIInput<String> databaseURL;
    @Inject
    @WithAttributes(label="Username", required=true)
    private UIInput<String> username;
    @Inject
    @WithAttributes(label="Password", required=true, type=InputType.SECRET)
    private UIInput<String> password;
    @Inject
    @WithAttributes(label="Persistence Unit Name", required=true)
    private UIInput<String> persistenceUnitName;
    @Inject
    private PersistenceOperations persistenceOperations;

    public NavigationResult next(UIContext context) throws Exception {
        return null;
    }

    public Metadata getMetadata(UIContext context) {
        return Metadata.from((UICommandMetadata)super.getMetadata(context), ((Object)((Object)this)).getClass()).name("JPA: Connection Settings").description("Configure your connection settings");
    }

    public boolean isEnabled(UIContext context) {
        return true;
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        UIContext uiContext = builder.getUIContext();
        PersistenceContainer pc = (PersistenceContainer)uiContext.getAttribute(PersistenceContainer.class);
        this.initDBType(uiContext);
        this.initDatasourceName(uiContext);
        this.initPersistenceUnitName(builder);
        builder.add(this.dbType);
        if (pc.isJTASupported()) {
            builder.add(this.dataSourceName);
        } else {
            builder.add(this.jdbcDriver).add(this.databaseURL).add(this.username).add(this.password);
        }
    }

    private void initPersistenceUnitName(UIBuilder builder) {
        int i = 1;
        String unitName = "forge-default";
        while (this.isExistingPersistenceUnitName(this.getSelectedProject(builder.getUIContext()), unitName)) {
            unitName = "forge-default-" + i++;
        }
        builder.add((InputComponent)this.persistenceUnitName.setDefaultValue((Object)unitName));
    }

    private void initDatasourceName(final UIContext uiContext) {
        this.dataSourceName.setDefaultValue((Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                PersistenceContainer pc = (PersistenceContainer)uiContext.getAttribute(PersistenceContainer.class);
                if (pc instanceof JavaEEDefaultContainer) {
                    return ((JavaEEDefaultContainer)pc).getDefaultDataSource();
                }
                return null;
            }
        });
    }

    private void initDBType(final UIContext uiContext) {
        this.dbType.setDefaultValue((Callable)new Callable<DatabaseType>(){

            @Override
            public DatabaseType call() throws Exception {
                DatabaseType type = DatabaseType.DEFAULT;
                PersistenceContainer pc = (PersistenceContainer)uiContext.getAttribute(PersistenceContainer.class);
                if (pc instanceof JavaEEDefaultContainer) {
                    type = ((JavaEEDefaultContainer)pc).getDefaultDatabaseType();
                }
                return type;
            }
        });
    }

    private JPADataSource getDataSource(UIContext context) {
        JPADataSource dataSource = new JPADataSource();
        dataSource.setDatabase((DatabaseType)this.dbType.getValue());
        dataSource.setJndiDataSource((String)this.dataSourceName.getValue());
        dataSource.setDatabaseURL((String)this.databaseURL.getValue());
        dataSource.setUsername((String)this.username.getValue());
        dataSource.setPassword((String)this.password.getValue());
        dataSource.setProvider((PersistenceProvider)context.getAttribute(PersistenceProvider.class));
        dataSource.setContainer((PersistenceContainer)context.getAttribute(PersistenceContainer.class));
        return dataSource;
    }

    public void validate(UIValidationContext validator) {
        UIContext uiContext = validator.getUIContext();
        JPADataSource ds = this.getDataSource(uiContext);
        try {
            ds.validate();
        }
        catch (Exception e) {
            validator.addValidationError(null, e.getMessage());
        }
        Project project = this.getSelectedProject(uiContext);
        if (this.isExistingPersistenceUnitName(project, (String)this.persistenceUnitName.getValue())) {
            validator.addValidationError(this.persistenceUnitName, "A persistence-unit with the name [" + (String)this.persistenceUnitName.getValue() + "] already exists.");
        }
    }

    private boolean isExistingPersistenceUnitName(Project project, String unitName) {
        if (project != null && project.hasFacet(JPAFacet.class)) {
            JPAFacet facet = (JPAFacet)project.getFacet(JPAFacet.class);
            PersistenceCommonDescriptor config = (PersistenceCommonDescriptor)facet.getConfig();
            List allPersistenceUnit = config.getAllPersistenceUnit();
            for (PersistenceUnitCommon persistenceUnit : allPersistenceUnit) {
                if (!unitName.equals(persistenceUnit.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public Result execute(UIContext context) throws Exception {
        Project project = this.getSelectedProject(context);
        JPADataSource dataSource = this.getDataSource(context);
        Boolean configureMetadata = (Boolean)context.getAttribute((Object)"ConfigureMetadata");
        String puName = (String)this.persistenceUnitName.getValue();
        FileResource<?> configFile = this.persistenceOperations.setup(puName, project, dataSource, configureMetadata);
        context.setSelection(configFile);
        return Results.success((String)"Persistence (JPA) is installed.");
    }

    protected boolean isProjectRequired() {
        return false;
    }
}

