/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.javaee.jpa.ui.setup;

import java.util.Comparator;
import java.util.TreeSet;
import javax.inject.Inject;
import org.jboss.forge.addon.convert.Converter;
import org.jboss.forge.addon.facets.Facet;
import org.jboss.forge.addon.facets.FacetFactory;
import org.jboss.forge.addon.facets.Faceted;
import org.jboss.forge.addon.javaee.jpa.JPAFacet;
import org.jboss.forge.addon.javaee.jpa.PersistenceContainer;
import org.jboss.forge.addon.javaee.jpa.PersistenceMetaModelFacet;
import org.jboss.forge.addon.javaee.jpa.PersistenceProvider;
import org.jboss.forge.addon.javaee.jpa.containers.JBossEAP6Container;
import org.jboss.forge.addon.javaee.jpa.providers.JavaEEDefaultProvider;
import org.jboss.forge.addon.javaee.jpa.ui.setup.JPASetupConnectionStep;
import org.jboss.forge.addon.javaee.ui.AbstractJavaEECommand;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIValidationContext;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.NavigationResult;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.addon.ui.wizard.UIWizard;
import org.jboss.forge.furnace.services.Imported;

public class JPASetupWizard
extends AbstractJavaEECommand
implements UIWizard {
    @Inject
    @WithAttributes(shortName=106, label="JPA Version", required=true)
    private UISelectOne<JPAFacet<?>> jpaVersion;
    @Inject
    @WithAttributes(shortName=99, label="Container", required=true)
    private UISelectOne<PersistenceContainer> container;
    @Inject
    @WithAttributes(shortName=112, label="Provider", required=true)
    private UISelectOne<PersistenceProvider> provider;
    @Inject
    @WithAttributes(shortName=109, label="Install a JPA 2 metamodel generator?")
    private UIInput<Boolean> configureMetadata;
    @Inject
    private JBossEAP6Container defaultContainer;
    @Inject
    private JavaEEDefaultProvider defaultProvider;
    @Inject
    private Imported<PersistenceMetaModelFacet> metaModelFacets;
    @Inject
    private FacetFactory facetFactory;

    public Metadata getMetadata(UIContext context) {
        return Metadata.from((UICommandMetadata)super.getMetadata(context), ((Object)((Object)this)).getClass()).name("JPA: Setup").description("Setup JPA in your project").category(Categories.create((String[])new String[]{super.getMetadata(context).getCategory().getName(), "JPA"}));
    }

    public boolean isEnabled(UIContext context) {
        return this.containsProject(context);
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        this.initFacets();
        this.initContainers(builder.getUIContext());
        this.initProviders();
        this.initConfigureMetadata();
        builder.add(this.jpaVersion).add(this.container).add(this.provider).add(this.configureMetadata);
    }

    private void initFacets() {
        this.jpaVersion.setItemLabelConverter(new Converter<JPAFacet<?>, String>(){

            public String convert(JPAFacet<?> source) {
                return source == null ? null : source.getSpecVersion().toString();
            }
        });
        for (JPAFacet choice : this.jpaVersion.getValueChoices()) {
            if (this.jpaVersion.getValue() != null && choice.getSpecVersion().compareTo((Object)((JPAFacet)this.jpaVersion.getValue()).getSpecVersion()) < 1) continue;
            this.jpaVersion.setDefaultValue((Object)choice);
        }
    }

    private void initContainers(UIContext context) {
        final boolean isGUI = context.getProvider().isGUI();
        this.container.setItemLabelConverter((Converter)new Converter<PersistenceContainer, String>(){

            public String convert(PersistenceContainer source) {
                return source != null ? source.getName(isGUI) : null;
            }
        });
        TreeSet<PersistenceContainer> treeSet = new TreeSet<PersistenceContainer>(new Comparator<PersistenceContainer>(){

            @Override
            public int compare(PersistenceContainer o1, PersistenceContainer o2) {
                return String.valueOf(o1.getName(isGUI)).compareTo(o2.getName(isGUI));
            }
        });
        Iterable valueChoices = this.container.getValueChoices();
        for (PersistenceContainer persistenceContainer : valueChoices) {
            treeSet.add(persistenceContainer);
        }
        this.container.setValueChoices(treeSet);
        this.container.setDefaultValue((Object)this.defaultContainer);
    }

    private void initProviders() {
        this.provider.setItemLabelConverter((Converter)new Converter<PersistenceProvider, String>(){

            public String convert(PersistenceProvider source) {
                return source != null ? source.getName() : null;
            }
        });
        this.provider.setDefaultValue((Object)this.defaultProvider);
    }

    private void initConfigureMetadata() {
        this.configureMetadata.setDefaultValue((Object)Boolean.FALSE);
        if (this.metaModelFacets.isUnsatisfied()) {
            this.configureMetadata.setEnabled(false);
        }
    }

    public void validate(UIValidationContext validator) {
    }

    public Result execute(UIContext context) throws Exception {
        this.applyUIValues(context);
        if (this.facetFactory.install((Faceted)this.getSelectedProject(context), (Facet)this.jpaVersion.getValue())) {
            return Results.success((String)"JPA has been installed.");
        }
        return Results.fail((String)"Could not install JPA.");
    }

    public NavigationResult next(UIContext context) throws Exception {
        this.applyUIValues(context);
        return Results.navigateTo(JPASetupConnectionStep.class);
    }

    private void applyUIValues(UIContext context) {
        context.setAttribute(JPAFacet.class, this.jpaVersion.getValue());
        context.setAttribute(PersistenceProvider.class, this.provider.getValue());
        context.setAttribute(PersistenceContainer.class, this.container.getValue());
        context.setAttribute((Object)"ConfigureMetadata", this.configureMetadata.getValue());
    }

    protected boolean isProjectRequired() {
        return false;
    }
}

