/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.javaee.jta.ui;

import javax.inject.Inject;
import org.jboss.forge.addon.convert.Converter;
import org.jboss.forge.addon.facets.Facet;
import org.jboss.forge.addon.facets.FacetFactory;
import org.jboss.forge.addon.facets.Faceted;
import org.jboss.forge.addon.facets.constraints.FacetConstraint;
import org.jboss.forge.addon.javaee.jta.JTAFacet;
import org.jboss.forge.addon.javaee.ui.AbstractJavaEECommand;
import org.jboss.forge.addon.projects.facets.DependencyFacet;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.metadata.UICategory;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;

@FacetConstraint(value={DependencyFacet.class})
public class JTASetupWizard
extends AbstractJavaEECommand {
    @Inject
    private FacetFactory facetFactory;
    @Inject
    @WithAttributes(required=true, label="JTA Version")
    private UISelectOne<JTAFacet> version;

    public Metadata getMetadata(UIContext context) {
        return Metadata.from((UICommandMetadata)super.getMetadata(context), ((Object)((Object)this)).getClass()).name("JTA: Setup").description("Setup JTA in your project").category(Categories.create((UICategory)super.getMetadata(context).getCategory(), (String[])new String[]{"JTA"}));
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        this.version.setItemLabelConverter((Converter)new Converter<JTAFacet, String>(){

            public String convert(JTAFacet source) {
                return source.getSpecVersion().toString();
            }
        });
        for (JTAFacet choice : this.version.getValueChoices()) {
            if (this.version.getValue() != null && choice.getSpecVersion().compareTo((Object)((JTAFacet)this.version.getValue()).getSpecVersion()) < 1) continue;
            this.version.setDefaultValue((Object)choice);
        }
        builder.add(this.version);
    }

    public Result execute(UIContext context) throws Exception {
        if (this.facetFactory.install((Faceted)this.getSelectedProject(context), (Facet)this.version.getValue())) {
            return Results.success((String)"JTA has been installed.");
        }
        return Results.fail((String)"Could not install JTA.");
    }

    protected boolean isProjectRequired() {
        return true;
    }
}

