/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.javaee.rest.generator.dto;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.jboss.forge.parser.java.JavaClass;

public class DTOCollection {
    private Map<JavaClass, DTOPair> dtos = new HashMap<JavaClass, DTOPair>();

    public Collection<JavaClass> allResources() {
        HashSet<JavaClass> result = new HashSet<JavaClass>();
        for (DTOPair pair : this.dtos.values()) {
            if (pair.rootDTO != null) {
                result.add(pair.rootDTO);
            }
            if (pair.nestedDTO == null) continue;
            result.add(pair.nestedDTO);
        }
        return result;
    }

    public void addRootDTO(JavaClass entity, JavaClass rootDTO) {
        DTOPair dtoPair = this.dtos.containsKey(entity) ? this.dtos.get(entity) : new DTOPair();
        dtoPair.rootDTO = rootDTO;
        this.dtos.put(entity, dtoPair);
    }

    public void addNestedDTO(JavaClass entity, JavaClass nestedDTO) {
        DTOPair dtoPair = this.dtos.containsKey(entity) ? this.dtos.get(entity) : new DTOPair();
        dtoPair.nestedDTO = nestedDTO;
        this.dtos.put(entity, dtoPair);
    }

    public boolean containsDTOFor(JavaClass entity, boolean root) {
        if (this.dtos.get(entity) == null) {
            return false;
        }
        return root ? this.dtos.get((Object)entity).rootDTO != null : this.dtos.get((Object)entity).nestedDTO != null;
    }

    public JavaClass getDTOFor(JavaClass entity, boolean root) {
        if (this.dtos.get(entity) == null) {
            return null;
        }
        return root ? this.dtos.get((Object)entity).rootDTO : this.dtos.get((Object)entity).nestedDTO;
    }

    private static class DTOPair {
        JavaClass rootDTO;
        JavaClass nestedDTO;

        private DTOPair() {
        }
    }
}

