/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.javaee.rest.generator.impl;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.xml.bind.annotation.XmlRootElement;
import org.jboss.forge.addon.javaee.rest.generation.RestGenerationContext;
import org.jboss.forge.addon.javaee.rest.generation.RestResourceGenerator;
import org.jboss.forge.addon.javaee.rest.generator.ResourceGeneratorUtil;
import org.jboss.forge.addon.parser.java.facets.JavaSourceFacet;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.resource.Resource;
import org.jboss.forge.addon.resource.ResourceFactory;
import org.jboss.forge.addon.templates.TemplateProcessor;
import org.jboss.forge.addon.templates.TemplateProcessorFactory;
import org.jboss.forge.parser.JavaParser;
import org.jboss.forge.parser.java.JavaClass;
import org.jboss.forge.parser.java.JavaSource;

public class EntityBasedResourceGenerator
implements RestResourceGenerator {
    @Inject
    TemplateProcessorFactory processorFactory;
    @Inject
    ResourceFactory resourceFactory;

    public List<JavaClass> generateFrom(RestGenerationContext context) throws Exception {
        JavaClass entity = context.getEntity();
        Project project = context.getProject();
        String contentType = context.getContentType();
        if (!entity.hasAnnotation(XmlRootElement.class)) {
            entity.addAnnotation(XmlRootElement.class);
            ((JavaSourceFacet)project.getFacet(JavaSourceFacet.class)).saveJavaSource((JavaSource)entity);
        }
        String idType = ResourceGeneratorUtil.resolveIdType(entity);
        String persistenceUnitName = context.getPersistenceUnitName();
        String idGetterName = ResourceGeneratorUtil.resolveIdGetterName(entity);
        String entityTable = ResourceGeneratorUtil.getEntityTable(entity);
        String selectExpression = ResourceGeneratorUtil.getSelectExpression(entity, entityTable);
        String idClause = ResourceGeneratorUtil.getIdClause(entity, entityTable);
        String orderClause = ResourceGeneratorUtil.getOrderClause(entity, ResourceGeneratorUtil.getJpqlEntityVariable(entityTable));
        String resourcePath = ResourceGeneratorUtil.getResourcePath(context);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("entity", entity);
        map.put("idType", idType);
        map.put("getIdStatement", idGetterName);
        map.put("contentType", contentType);
        map.put("persistenceUnitName", persistenceUnitName);
        map.put("entityTable", entityTable);
        map.put("selectExpression", selectExpression);
        map.put("idClause", idClause);
        map.put("orderClause", orderClause);
        map.put("resourcePath", resourcePath);
        Resource templateResource = this.resourceFactory.create((Object)this.getClass().getResource("Endpoint.jv"));
        TemplateProcessor processor = this.processorFactory.fromTemplate(templateResource);
        String output = processor.process(map);
        JavaClass resource = (JavaClass)JavaParser.parse(JavaClass.class, (String)output);
        resource.addImport(entity.getQualifiedName());
        resource.setPackage(context.getTargetPackageName());
        return Arrays.asList(resource);
    }

    public String getDescription() {
        return "Expose JPA entities directly in the REST resources";
    }

    public String getName() {
        return "JPA_ENTITY";
    }
}

