/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.javaee.rest.generator.impl;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.persistence.Embeddable;
import javax.persistence.Embedded;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Transient;
import org.jboss.forge.addon.javaee.rest.generation.RestGenerationContext;
import org.jboss.forge.addon.javaee.rest.generation.RestResourceGenerator;
import org.jboss.forge.addon.javaee.rest.generator.ResourceGeneratorUtil;
import org.jboss.forge.addon.javaee.rest.generator.dto.DTOClassBuilder;
import org.jboss.forge.addon.javaee.rest.generator.dto.DTOCollection;
import org.jboss.forge.addon.parser.java.beans.JavaClassIntrospector;
import org.jboss.forge.addon.parser.java.beans.Property;
import org.jboss.forge.addon.parser.java.facets.JavaSourceFacet;
import org.jboss.forge.addon.parser.java.resources.JavaResource;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.resource.Resource;
import org.jboss.forge.addon.resource.ResourceFactory;
import org.jboss.forge.addon.templates.TemplateProcessor;
import org.jboss.forge.addon.templates.TemplateProcessorFactory;
import org.jboss.forge.parser.JavaParser;
import org.jboss.forge.parser.java.JavaClass;
import org.jboss.forge.parser.java.JavaSource;
import org.jboss.forge.parser.java.Type;

public class RootAndNestedDTOResourceGenerator
implements RestResourceGenerator {
    @Inject
    TemplateProcessorFactory processorFactory;
    @Inject
    ResourceFactory resourceFactory;

    public List<JavaClass> generateFrom(RestGenerationContext context) throws Exception {
        ArrayList<JavaClass> result = new ArrayList<JavaClass>();
        JavaClass entity = context.getEntity();
        Project project = context.getProject();
        String contentType = context.getContentType();
        String idType = ResourceGeneratorUtil.resolveIdType(entity);
        String persistenceUnitName = context.getPersistenceUnitName();
        String idGetterName = ResourceGeneratorUtil.resolveIdGetterName(entity);
        String entityTable = ResourceGeneratorUtil.getEntityTable(entity);
        String selectExpression = ResourceGeneratorUtil.getSelectExpression(entity, entityTable);
        String idClause = ResourceGeneratorUtil.getIdClause(entity, entityTable);
        String orderClause = ResourceGeneratorUtil.getOrderClause(entity, ResourceGeneratorUtil.getJpqlEntityVariable(entityTable));
        String resourcePath = ResourceGeneratorUtil.getResourcePath(context);
        DTOCollection createdDtos = this.from(project, entity, context.getTargetPackageName() + ".dto");
        JavaClass rootDto = createdDtos.getDTOFor(entity, true);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("entity", entity);
        map.put("dto", rootDto);
        map.put("idType", idType);
        map.put("getIdStatement", idGetterName);
        map.put("contentType", contentType);
        map.put("persistenceUnitName", persistenceUnitName);
        map.put("entityTable", entityTable);
        map.put("selectExpression", selectExpression);
        map.put("idClause", idClause);
        map.put("orderClause", orderClause);
        map.put("resourcePath", resourcePath);
        Resource templateResource = this.resourceFactory.create((Object)this.getClass().getResource("EndpointWithDTO.jv"));
        TemplateProcessor processor = this.processorFactory.fromTemplate(templateResource);
        String output = processor.process(map);
        JavaClass resource = (JavaClass)JavaParser.parse(JavaClass.class, (String)output);
        resource.addImport(rootDto.getQualifiedName());
        resource.addImport(entity.getQualifiedName());
        resource.setPackage(context.getTargetPackageName());
        result.add(resource);
        result.addAll(createdDtos.allResources());
        return result;
    }

    public DTOCollection from(Project project, JavaClass entity, String dtoPackage) {
        DTOCollection dtoCollection = new DTOCollection();
        if (entity == null) {
            throw new IllegalArgumentException("The argument entity was null.");
        }
        this.generatedDTOGraphForEntity(project, entity, dtoPackage, true, false, dtoCollection);
        return dtoCollection;
    }

    private JavaClass generatedDTOGraphForEntity(Project project, JavaClass entity, String dtoPackage, boolean topLevel, boolean isEmbeddedType, DTOCollection dtoCollection) {
        if (dtoCollection.containsDTOFor(entity, topLevel)) {
            return dtoCollection.getDTOFor(entity, topLevel);
        }
        Property idProperty = null;
        JavaClassIntrospector bean = new JavaClassIntrospector(entity);
        idProperty = this.parseIdPropertyForJPAEntity(bean);
        DTOClassBuilder dtoClassBuilder = new DTOClassBuilder(entity, idProperty, topLevel, this.processorFactory, this.resourceFactory).setPackage(dtoPackage).setEmbeddedType(isEmbeddedType);
        for (Property property : bean.getProperties()) {
            boolean isEmbedded;
            if (property.isTransient() || property.hasAnnotation(Transient.class)) continue;
            String qualifiedPropertyType = property.getQualifiedType();
            JavaClass propertyClass = this.tryGetJavaClass(project, qualifiedPropertyType);
            boolean isReadable = property.isReadable();
            boolean isCollection = property.hasAnnotation(OneToMany.class) || property.hasAnnotation(ManyToMany.class);
            Type propertyTypeInspector = property.getType();
            boolean parameterized = propertyTypeInspector.isParameterized();
            boolean hasAssociation = property.hasAnnotation(OneToOne.class) || property.hasAnnotation(ManyToOne.class);
            boolean bl = isEmbedded = property.hasAnnotation(Embedded.class) || propertyClass != null && propertyClass.hasAnnotation(Embeddable.class);
            if (!isReadable) continue;
            if (isCollection && parameterized) {
                Type type;
                String qualifiedParameterizedType;
                JavaClass parameterizedClass;
                if (!topLevel || (parameterizedClass = this.tryGetJavaClass(project, qualifiedParameterizedType = (type = (Type)propertyTypeInspector.getTypeArguments().get(0)).getQualifiedName())) == null) continue;
                JavaClass nestedDTOClass = this.generatedDTOGraphForEntity(project, parameterizedClass, dtoPackage, false, false, dtoCollection);
                JavaClassIntrospector parameterizedClassBean = new JavaClassIntrospector(parameterizedClass);
                Property nestedDtoId = this.parseIdPropertyForJPAEntity(parameterizedClassBean);
                dtoClassBuilder.updateForCollectionProperty(property, nestedDTOClass, type, nestedDtoId);
                continue;
            }
            if (hasAssociation) {
                JavaClass associatedClass;
                if (!topLevel || (associatedClass = this.tryGetJavaClass(project, qualifiedPropertyType)) == null) continue;
                JavaClass nestedDTOClass = this.generatedDTOGraphForEntity(project, associatedClass, dtoPackage, false, false, dtoCollection);
                dtoClassBuilder.updateForReferencedProperty(property, nestedDTOClass);
                continue;
            }
            if (isEmbedded) {
                JavaClass dtoForEmbeddedType = this.generatedDTOGraphForEntity(project, propertyClass, dtoPackage, true, true, dtoCollection);
                dtoClassBuilder.updateForReferencedProperty(property, dtoForEmbeddedType);
                continue;
            }
            dtoClassBuilder.updateForSimpleProperty(property, property.getType());
        }
        JavaClass dtoClass = dtoClassBuilder.createDTO();
        if (topLevel) {
            dtoCollection.addRootDTO(entity, dtoClass);
        } else {
            dtoCollection.addNestedDTO(entity, dtoClass);
        }
        return dtoClass;
    }

    private Property parseIdPropertyForJPAEntity(JavaClassIntrospector bean) {
        for (Property property : bean.getProperties()) {
            if (!property.hasAnnotation(Id.class)) continue;
            return property;
        }
        return null;
    }

    private JavaClass tryGetJavaClass(Project project, String qualifiedFieldType) {
        try {
            JavaResource javaResource = ((JavaSourceFacet)project.getFacet(JavaSourceFacet.class)).getJavaResource(qualifiedFieldType);
            JavaSource javaSource = javaResource.getJavaSource();
            if (javaSource instanceof JavaClass) {
                return (JavaClass)javaSource;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return null;
    }

    public String getName() {
        return "ROOT_AND_NESTED_DTO";
    }

    public String getDescription() {
        return "Expose DTOs for JPA entities in the REST resources";
    }
}

