/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.javaee.rest.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.jboss.forge.addon.convert.Converter;
import org.jboss.forge.addon.javaee.ejb.EJBFacet;
import org.jboss.forge.addon.javaee.ejb.ui.EJBSetupWizard;
import org.jboss.forge.addon.javaee.jpa.JPAFacet;
import org.jboss.forge.addon.javaee.rest.generation.RestGenerationContext;
import org.jboss.forge.addon.javaee.rest.generation.RestResourceGenerator;
import org.jboss.forge.addon.javaee.rest.generator.RestGenerationContextImpl;
import org.jboss.forge.addon.javaee.rest.generator.impl.EntityBasedResourceGenerator;
import org.jboss.forge.addon.javaee.ui.AbstractJavaEECommand;
import org.jboss.forge.addon.parser.java.facets.JavaSourceFacet;
import org.jboss.forge.addon.parser.java.resources.JavaResource;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.text.Inflector;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIValidationContext;
import org.jboss.forge.addon.ui.hints.InputType;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.input.UISelectMany;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.metadata.UICategory;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.NavigationResult;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.addon.ui.wizard.UIWizard;
import org.jboss.forge.parser.java.JavaClass;
import org.jboss.forge.parser.java.JavaSource;
import org.jboss.shrinkwrap.descriptor.api.persistence.PersistenceCommonDescriptor;
import org.jboss.shrinkwrap.descriptor.api.persistence.PersistenceUnitCommon;

public class RestEndpointFromEntityWizard
extends AbstractJavaEECommand
implements UIWizard {
    @Inject
    @WithAttributes(label="Content Type", defaultValue="application/xml", required=true)
    private UISelectOne<String> contentType;
    @Inject
    @WithAttributes(label="Targets", required=true)
    private UISelectMany<JavaClass> targets;
    @Inject
    @WithAttributes(label="Generator", required=true)
    private UISelectOne<RestResourceGenerator> generator;
    @Inject
    @WithAttributes(label="Persistence Unit", required=true)
    private UISelectOne<String> persistenceUnit;
    @Inject
    @WithAttributes(label="Target Package Name", required=true, type=InputType.JAVA_PACKAGE_PICKER)
    private UIInput<String> packageName;
    @Inject
    @WithAttributes(label="Overwrite existing classes?", enabled=false, defaultValue="false")
    private UIInput<Boolean> overwrite;
    @Inject
    private EntityBasedResourceGenerator defaultResourceGenerator;
    @Inject
    private Inflector inflector;

    @Override
    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.from((UICommandMetadata)super.getMetadata(context), ((Object)((Object)this)).getClass()).name("REST: Endpoint From Entity").description("Generate REST endpoints from JPA entities").category(Categories.create((UICategory)super.getMetadata(context).getCategory(), (String[])new String[]{"JAX-RS"}));
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        UIContext context = builder.getUIContext();
        Project project = this.getSelectedProject(context);
        JPAFacet persistenceFacet = (JPAFacet)project.getFacet(JPAFacet.class);
        JavaSourceFacet javaSourceFacet = (JavaSourceFacet)project.getFacet(JavaSourceFacet.class);
        this.targets.setValueChoices((Iterable)persistenceFacet.getAllEntities());
        this.targets.setItemLabelConverter((Converter)new Converter<JavaClass, String>(){

            public String convert(JavaClass source) {
                return source == null ? null : source.getQualifiedName();
            }
        });
        ArrayList<String> persistenceUnits = new ArrayList<String>();
        List allUnits = ((PersistenceCommonDescriptor)persistenceFacet.getConfig()).getAllPersistenceUnit();
        for (PersistenceUnitCommon persistenceUnit : allUnits) {
            persistenceUnits.add(persistenceUnit.getName());
        }
        if (!persistenceUnits.isEmpty()) {
            ((UISelectOne)this.persistenceUnit.setValueChoices(persistenceUnits)).setDefaultValue(persistenceUnits.get(0));
        }
        this.packageName.setDefaultValue((Object)(javaSourceFacet.getBasePackage() + ".rest"));
        this.contentType.setValueChoices(Arrays.asList("application/xml", "application/json"));
        this.generator.setDefaultValue((Object)this.defaultResourceGenerator);
        if (context.getProvider().isGUI()) {
            this.generator.setItemLabelConverter((Converter)new Converter<RestResourceGenerator, String>(){

                public String convert(RestResourceGenerator source) {
                    return source == null ? null : source.getDescription();
                }
            });
        } else {
            this.generator.setItemLabelConverter((Converter)new Converter<RestResourceGenerator, String>(){

                public String convert(RestResourceGenerator source) {
                    return source == null ? null : source.getName();
                }
            });
        }
        builder.add(this.targets).add(this.generator).add(this.contentType).add(this.packageName).add(this.persistenceUnit).add(this.overwrite);
    }

    public Result execute(UIContext context) throws Exception {
        RestGenerationContextImpl generationContext = this.createContextFor(context);
        Set<JavaClass> endpoints = this.generateEndpoints(generationContext);
        Project project = generationContext.getProject();
        JavaSourceFacet javaSourceFacet = (JavaSourceFacet)project.getFacet(JavaSourceFacet.class);
        ArrayList<JavaResource> selection = new ArrayList<JavaResource>();
        for (JavaClass javaClass : endpoints) {
            selection.add(javaSourceFacet.saveJavaSource((JavaSource)javaClass));
        }
        context.setSelection(selection);
        return Results.success((String)"Endpoint created");
    }

    private Set<JavaClass> generateEndpoints(RestGenerationContextImpl generationContext) throws Exception {
        RestResourceGenerator selectedGenerator = (RestResourceGenerator)this.generator.getValue();
        HashSet<JavaClass> classes = new HashSet<JavaClass>();
        for (JavaClass target : this.targets.getValue()) {
            generationContext.setEntity(target);
            List artifacts = selectedGenerator.generateFrom((RestGenerationContext)generationContext);
            classes.addAll(artifacts);
        }
        return classes;
    }

    public void validate(UIValidationContext validator) {
        super.validate(validator);
    }

    public boolean isEnabled(UIContext context) {
        Project project;
        boolean enabled = super.isEnabled(context) ? (project = this.getSelectedProject(context)).hasFacet(JPAFacet.class) && project.hasFacet(JavaSourceFacet.class) : false;
        return enabled;
    }

    protected boolean isProjectRequired() {
        return true;
    }

    private RestGenerationContextImpl createContextFor(UIContext context) {
        RestGenerationContextImpl generationContext = new RestGenerationContextImpl();
        generationContext.setProject(this.getSelectedProject(context));
        generationContext.setContentType((String)this.contentType.getValue());
        generationContext.setPersistenceUnitName((String)this.persistenceUnit.getValue());
        generationContext.setTargetPackageName((String)this.packageName.getValue());
        generationContext.setInflector(this.inflector);
        return generationContext;
    }

    public NavigationResult next(UIContext context) throws Exception {
        Project project = this.getSelectedProject(context);
        if (project.hasFacet(EJBFacet.class)) {
            return null;
        }
        return Results.navigateTo(EJBSetupWizard.class);
    }
}

