/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.javaee.rest.ui.setup;

import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.jboss.forge.addon.convert.Converter;
import org.jboss.forge.addon.facets.Facet;
import org.jboss.forge.addon.facets.FacetFactory;
import org.jboss.forge.addon.facets.Faceted;
import org.jboss.forge.addon.javaee.rest.RestFacet;
import org.jboss.forge.addon.javaee.rest.config.RestConfigurationStrategy;
import org.jboss.forge.addon.javaee.rest.config.RestConfigurationStrategyFactory;
import org.jboss.forge.addon.javaee.rest.ui.setup.RestActivatorType;
import org.jboss.forge.addon.javaee.ui.AbstractJavaEECommand;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.facets.MetadataFacet;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIValidationContext;
import org.jboss.forge.addon.ui.hints.InputType;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.metadata.UICategory;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.parser.JavaParser;
import org.jboss.forge.parser.java.JavaClass;

public class RestSetupWizard
extends AbstractJavaEECommand {
    @Inject
    private FacetFactory facetFactory;
    @Inject
    @WithAttributes(required=true, label="JAX-RS Version")
    private UISelectOne<RestFacet> jaxrsVersion;
    @Inject
    @WithAttributes(required=true, label="Configuration Strategy", type=InputType.RADIO)
    private UISelectOne<RestActivatorType> config;
    @Inject
    @WithAttributes(label="Application Path", description="The Application path for the REST resources", defaultValue="/rest", required=true)
    private UIInput<String> applicationPath;
    @Inject
    @WithAttributes(label="Package Name", type=InputType.JAVA_PACKAGE_PICKER)
    private UIInput<String> packageName;
    @Inject
    @WithAttributes(label="Class Name", defaultValue="RestApplication")
    private UIInput<String> className;

    public Metadata getMetadata(UIContext context) {
        return Metadata.from((UICommandMetadata)super.getMetadata(context), ((Object)((Object)this)).getClass()).name("REST: Setup").description("Setup REST in your project").category(Categories.create((UICategory)super.getMetadata(context).getCategory(), (String[])new String[]{"JAX-RS"}));
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        this.configureVersions();
        this.configureActivationStrategy(builder.getUIContext());
        builder.add(this.jaxrsVersion).add(this.applicationPath).add(this.config).add(this.packageName).add(this.className);
    }

    private void configureActivationStrategy(UIContext context) {
        this.config.setDefaultValue((Object)RestActivatorType.APP_CLASS);
        Callable<Boolean> appClassChosen = new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return RestActivatorType.APP_CLASS == RestSetupWizard.this.config.getValue();
            }
        };
        if (context.getProvider().isGUI()) {
            this.config.setItemLabelConverter((Converter)new Converter<RestActivatorType, String>(){

                public String convert(RestActivatorType source) {
                    return source != null ? source.getDescription() : null;
                }
            });
        }
        ((UIInput)this.packageName.setRequired((Callable)appClassChosen)).setEnabled((Callable)appClassChosen);
        ((UIInput)this.className.setRequired((Callable)appClassChosen)).setEnabled((Callable)appClassChosen);
        Project project = this.getSelectedProject(context);
        this.packageName.setDefaultValue((Object)(((MetadataFacet)project.getFacet(MetadataFacet.class)).getTopLevelPackage() + ".rest"));
    }

    private void configureVersions() {
        this.jaxrsVersion.setItemLabelConverter((Converter)new Converter<RestFacet, String>(){

            public String convert(RestFacet source) {
                return source.getSpecVersion().toString();
            }
        });
        for (RestFacet choice : this.jaxrsVersion.getValueChoices()) {
            if (this.jaxrsVersion.getValue() != null && choice.getSpecVersion().compareTo((Object)((RestFacet)this.jaxrsVersion.getValue()).getSpecVersion()) < 1) continue;
            this.jaxrsVersion.setDefaultValue((Object)choice);
        }
    }

    public void validate(UIValidationContext validator) {
        super.validate(validator);
    }

    public Result execute(UIContext context) throws Exception {
        RestFacet facet = (RestFacet)this.jaxrsVersion.getValue();
        if (this.facetFactory.install((Faceted)this.getSelectedProject(context), (Facet)facet)) {
            RestConfigurationStrategy strategy;
            String path = (String)this.applicationPath.getValue();
            if (this.config.getValue() == RestActivatorType.WEB_XML) {
                strategy = RestConfigurationStrategyFactory.createUsingWebXml((String)path);
            } else {
                JavaClass javaClass = (JavaClass)((JavaClass)((JavaClass)JavaParser.create(JavaClass.class)).setPackage((String)this.packageName.getValue())).setName((String)this.className.getValue());
                strategy = RestConfigurationStrategyFactory.createUsingJavaClass((String)path, (JavaClass)javaClass);
            }
            facet.setConfigurationStrategy(strategy);
            return Results.success((String)"JAX-RS has been installed.");
        }
        return Results.fail((String)"Could not install JAX-RS.");
    }

    protected boolean isProjectRequired() {
        return true;
    }
}

