/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.javaee.servlet.ui;

import javax.inject.Inject;
import org.jboss.forge.addon.convert.Converter;
import org.jboss.forge.addon.facets.Facet;
import org.jboss.forge.addon.facets.FacetFactory;
import org.jboss.forge.addon.facets.Faceted;
import org.jboss.forge.addon.facets.constraints.FacetConstraint;
import org.jboss.forge.addon.javaee.servlet.ServletFacet;
import org.jboss.forge.addon.javaee.ui.AbstractJavaEECommand;
import org.jboss.forge.addon.projects.facets.DependencyFacet;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.metadata.UICategory;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;

@FacetConstraint(value={DependencyFacet.class})
public class ServletSetupWizard
extends AbstractJavaEECommand {
    @Inject
    private FacetFactory facetFactory;
    @Inject
    @WithAttributes(required=true, label="Servlet Version")
    private UISelectOne<ServletFacet<?>> servletVersion;

    public Metadata getMetadata(UIContext context) {
        return Metadata.from((UICommandMetadata)super.getMetadata(context), ((Object)((Object)this)).getClass()).name("Servlet: Setup").description("Setup Servlet API in your project").category(Categories.create((UICategory)super.getMetadata(context).getCategory(), (String[])new String[]{"Servlet"}));
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        this.servletVersion.setItemLabelConverter(new Converter<ServletFacet<?>, String>(){

            public String convert(ServletFacet<?> source) {
                return source.getSpecVersion().toString();
            }
        });
        for (ServletFacet choice : this.servletVersion.getValueChoices()) {
            if (this.servletVersion.getValue() != null && choice.getSpecVersion().compareTo((Object)((ServletFacet)this.servletVersion.getValue()).getSpecVersion()) < 1) continue;
            this.servletVersion.setDefaultValue((Object)choice);
        }
        builder.add(this.servletVersion);
    }

    public Result execute(UIContext context) throws Exception {
        if (this.facetFactory.install((Faceted)this.getSelectedProject(context), (Facet)this.servletVersion.getValue())) {
            return Results.success((String)"Servlet API has been installed.");
        }
        return Results.fail((String)"Could not install Servlet API.");
    }

    protected boolean isProjectRequired() {
        return true;
    }
}

