/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.javaee.validation;

import org.jboss.forge.parser.java.Field;
import org.jboss.forge.parser.java.JavaClass;
import org.jboss.forge.parser.java.Method;

public final class JavaHelper {
    private static final String GET_PREFIX = "get";
    private static final String IS_PREFIX = "is";

    private JavaHelper() {
    }

    public static Method<JavaClass> getFieldAccessor(Field<JavaClass> field) {
        if (field == null) {
            throw new IllegalArgumentException("The parameter 'field' cannot be null");
        }
        JavaClass javaClass = (JavaClass)field.getOrigin();
        String accessorMethodSuffix = JavaHelper.getAccessorMethodSuffix(field);
        Method method = null;
        if (field.isType(Boolean.class) || field.isType(Boolean.TYPE) || field.isType(Boolean.TYPE)) {
            method = javaClass.getMethod(IS_PREFIX + accessorMethodSuffix);
        }
        if (method == null) {
            method = javaClass.getMethod(GET_PREFIX + accessorMethodSuffix);
        }
        return method;
    }

    private static String getAccessorMethodSuffix(Field<JavaClass> field) {
        String fieldName = field.getName();
        StringBuilder methodSuffix = new StringBuilder();
        if (fieldName.length() > 0) {
            methodSuffix.append(Character.toUpperCase(fieldName.charAt(0)));
            if (fieldName.length() > 1) {
                methodSuffix.append(fieldName.substring(1, fieldName.length()));
            }
        }
        return methodSuffix.toString();
    }
}

