/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.javaee.validation;

import java.util.Set;
import javax.inject.Inject;
import org.jboss.forge.addon.dependencies.Dependency;
import org.jboss.forge.addon.dependencies.builder.DependencyBuilder;
import org.jboss.forge.addon.facets.FacetFactory;
import org.jboss.forge.addon.facets.Faceted;
import org.jboss.forge.addon.javaee.Descriptors;
import org.jboss.forge.addon.javaee.validation.ValidationFacet;
import org.jboss.forge.addon.javaee.validation.provider.ValidationProvider;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.dependencies.DependencyInstaller;
import org.jboss.shrinkwrap.descriptor.api.validationConfiguration11.ValidationConfigurationDescriptor;

public class ValidationOperations {
    @Inject
    private DependencyInstaller installer;
    @Inject
    private FacetFactory facetFactory;

    public void setup(Project project, ValidationProvider provider, boolean provided, String messageInterpolator, String traversableResolver, String constraintValidatorFactory) throws Exception {
        if (project != null) {
            ValidationFacet facet = (ValidationFacet)this.facetFactory.install((Faceted)project, ValidationFacet.class);
            String scopeType = provided ? "PROVIDED" : "COMPILE";
            this.installDependencies(project, provider.getDependencies(), scopeType);
            this.installDependencies(project, provider.getAdditionalDependencies(), scopeType);
            if (provider.getDefaultDescriptor() != null) {
                ValidationConfigurationDescriptor providerDescriptor = provider.getDefaultDescriptor();
                ValidationConfigurationDescriptor descriptor = (ValidationConfigurationDescriptor)Descriptors.create(ValidationConfigurationDescriptor.class);
                String defaultProvider = providerDescriptor.getDefaultProvider();
                if (defaultProvider != null && !defaultProvider.isEmpty()) {
                    descriptor.defaultProvider(defaultProvider);
                }
                if (messageInterpolator != null) {
                    descriptor.messageInterpolator(messageInterpolator);
                }
                if (traversableResolver != null) {
                    descriptor.traversableResolver(traversableResolver);
                }
                if (constraintValidatorFactory != null) {
                    descriptor.constraintValidatorFactory(constraintValidatorFactory);
                }
                ((ValidationFacet)project.getFacet(ValidationFacet.class)).saveConfig((Object)descriptor);
            }
            ValidationConfigurationDescriptor config = (ValidationConfigurationDescriptor)facet.getConfig();
            facet.saveConfig((Object)config);
        }
    }

    private void installDependencies(Project project, Set<Dependency> dependencies, String scopeType) {
        for (Dependency dep : dependencies) {
            if (this.installer.isInstalled(project, dep)) continue;
            dep = DependencyBuilder.create((Dependency)dep).setScopeType(scopeType);
            this.installer.install(project, dep);
        }
    }
}

