/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.javaee.validation.ui;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import javax.inject.Inject;
import org.jboss.forge.addon.javaee.ui.AbstractJavaEECommand;
import org.jboss.forge.addon.javaee.validation.ValidationFacet;
import org.jboss.forge.addon.javaee.validation.ui.SelectFieldWizardStep;
import org.jboss.forge.addon.parser.java.facets.JavaSourceFacet;
import org.jboss.forge.addon.parser.java.resources.JavaResource;
import org.jboss.forge.addon.parser.java.resources.JavaResourceVisitor;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UISelection;
import org.jboss.forge.addon.ui.hints.InputType;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.NavigationResult;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.addon.ui.wizard.UIWizard;

public class AddConstraintWizard
extends AbstractJavaEECommand
implements UIWizard {
    @Inject
    @WithAttributes(label="Class", description="The Java class containing the field", required=true, type=InputType.DROPDOWN)
    private UISelectOne<JavaResource> javaClass;

    @Override
    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.from((UICommandMetadata)super.getMetadata(context), ((Object)((Object)this)).getClass()).name("Bean Validation: Add constraint").description("Add a Bean Validation constraint").category(Categories.create((String[])new String[]{super.getMetadata(context).getCategory().getName(), "Bean Validation"}));
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        this.configureClassPicker(builder.getUIContext());
        builder.add(this.javaClass);
    }

    private void configureClassPicker(UIContext context) {
        UISelection selection = context.getInitialSelection();
        Project project = this.getSelectedProject(context);
        final ArrayList classes = new ArrayList();
        if (project != null) {
            ((JavaSourceFacet)project.getFacet(JavaSourceFacet.class)).visitJavaSources(new JavaResourceVisitor(){

                public void visit(JavaResource resource) {
                    try {
                        if (resource.getJavaSource().isClass()) {
                            classes.add(resource);
                        }
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        // empty catch block
                    }
                }
            });
        }
        this.javaClass.setValueChoices(classes);
        int idx = -1;
        if (!selection.isEmpty()) {
            idx = classes.indexOf(selection.get());
        }
        if (idx == -1) {
            idx = classes.size() - 1;
        }
        if (idx != -1) {
            this.javaClass.setDefaultValue(classes.get(idx));
        }
    }

    public Result execute(UIContext context) throws Exception {
        return Results.success();
    }

    public NavigationResult next(UIContext context) throws Exception {
        JavaResource selectedClass = (JavaResource)this.javaClass.getValue();
        context.setAttribute(JavaResource.class, (Object)selectedClass);
        return Results.navigateTo(SelectFieldWizardStep.class);
    }

    public boolean isEnabled(UIContext context) {
        return super.isEnabled(context) && this.getSelectedProject(context).hasFacet(ValidationFacet.class);
    }

    protected boolean isProjectRequired() {
        return true;
    }
}

